/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.protocol.views.AbstractView;
import com.couchbase.client.protocol.views.Query;
import com.couchbase.client.protocol.views.View;
import com.couchbase.client.protocol.views.ViewResponse;
import com.couchbase.client.protocol.views.ViewRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.PersistTo;
import net.spy.memcached.ReplicateTo;
import net.spy.memcached.internal.OperationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.data.couchbase.core.BucketCallback;
import org.springframework.data.couchbase.core.CouchbaseDataIntegrityViolationException;
import org.springframework.data.couchbase.core.CouchbaseExceptionTranslator;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.OperationInterruptedException;
import org.springframework.data.couchbase.core.WriteResultChecking;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.CouchbaseStorable;
import org.springframework.data.couchbase.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.AfterSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.CouchbaseMappingEvent;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;

public class CouchbaseTemplate
implements CouchbaseOperations,
ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseTemplate.class);
    private static final Collection<String> ITERABLE_CLASSES;
    private static final WriteResultChecking DEFAULT_WRITE_RESULT_CHECKING;
    private final CouchbaseClient client;
    protected final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final CouchbaseExceptionTranslator exceptionTranslator = new CouchbaseExceptionTranslator();
    private final TranslationService translationService;
    private ApplicationEventPublisher eventPublisher;
    private CouchbaseConverter couchbaseConverter;
    private WriteResultChecking writeResultChecking = DEFAULT_WRITE_RESULT_CHECKING;

    public void setWriteResultChecking(WriteResultChecking resultChecking) {
        this.writeResultChecking = resultChecking == null ? DEFAULT_WRITE_RESULT_CHECKING : resultChecking;
    }

    public CouchbaseTemplate(CouchbaseClient client) {
        this(client, null, null);
    }

    public CouchbaseTemplate(CouchbaseClient client, TranslationService translationService) {
        this(client, null, translationService);
    }

    public CouchbaseTemplate(CouchbaseClient client, CouchbaseConverter couchbaseConverter, TranslationService translationService) {
        this.client = client;
        this.couchbaseConverter = couchbaseConverter == null ? CouchbaseTemplate.getDefaultConverter() : couchbaseConverter;
        this.translationService = translationService == null ? CouchbaseTemplate.getDefaultTranslationService() : translationService;
        this.mappingContext = this.couchbaseConverter.getMappingContext();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    private static CouchbaseConverter getDefaultConverter() {
        MappingCouchbaseConverter converter = new MappingCouchbaseConverter((MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty>)new CouchbaseMappingContext());
        converter.afterPropertiesSet();
        return converter;
    }

    private static TranslationService getDefaultTranslationService() {
        JacksonTranslationService jacksonTranslationService = new JacksonTranslationService();
        jacksonTranslationService.afterPropertiesSet();
        return jacksonTranslationService;
    }

    private Object translateEncode(CouchbaseStorable source) {
        return this.translationService.encode(source);
    }

    private CouchbaseStorable translateDecode(String source, CouchbaseStorable target) {
        return this.translationService.decode(source, target);
    }

    @Override
    public final void insert(Object objectToInsert) {
        this.insert(objectToInsert, PersistTo.ZERO, ReplicateTo.ZERO);
    }

    @Override
    public final void insert(Collection<?> batchToInsert) {
        for (Object toInsert : batchToInsert) {
            this.insert(toInsert);
        }
    }

    @Override
    public void save(Object objectToSave) {
        this.save(objectToSave, PersistTo.ZERO, ReplicateTo.ZERO);
    }

    @Override
    public void save(Collection<?> batchToSave) {
        for (Object toSave : batchToSave) {
            this.save(toSave);
        }
    }

    @Override
    public void update(Object objectToUpdate) {
        this.update(objectToUpdate, PersistTo.ZERO, ReplicateTo.ZERO);
    }

    @Override
    public void update(Collection<?> batchToUpdate) {
        for (Object toUpdate : batchToUpdate) {
            this.update(toUpdate);
        }
    }

    @Override
    public final <T> T findById(final String id, Class<T> entityClass) {
        CASValue result = this.execute(new BucketCallback<CASValue>(){

            @Override
            public CASValue doInBucket() {
                return CouchbaseTemplate.this.client.gets(id);
            }
        });
        if (result == null) {
            return null;
        }
        CouchbaseDocument converted = new CouchbaseDocument(id);
        Object readEntity = this.couchbaseConverter.read(entityClass, (CouchbaseDocument)this.translateDecode((String)result.getValue(), converted));
        BeanWrapper beanWrapper = BeanWrapper.create((Object)readEntity, (ConversionService)this.couchbaseConverter.getConversionService());
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(readEntity.getClass());
        if (persistentEntity.hasVersionProperty()) {
            beanWrapper.setProperty(persistentEntity.getVersionProperty(), (Object)result.getCas());
        }
        return (T)readEntity;
    }

    @Override
    public <T> List<T> findByView(String designName, String viewName, Query query, Class<T> entityClass) {
        if (query.willIncludeDocs()) {
            query.setIncludeDocs(false);
        }
        if (query.willReduce()) {
            query.setReduce(false);
        }
        ViewResponse response = this.queryView(designName, viewName, query);
        ArrayList<T> result = new ArrayList<T>(response.size());
        for (ViewRow row : response) {
            result.add(this.findById(row.getId(), entityClass));
        }
        return result;
    }

    @Override
    public ViewResponse queryView(final String designName, final String viewName, final Query query) {
        return this.execute(new BucketCallback<ViewResponse>(){

            @Override
            public ViewResponse doInBucket() {
                View view = CouchbaseTemplate.this.client.getView(designName, viewName);
                return CouchbaseTemplate.this.client.query((AbstractView)view, query);
            }
        });
    }

    @Override
    public void remove(Object objectToRemove) {
        this.remove(objectToRemove, PersistTo.ZERO, ReplicateTo.ZERO);
    }

    @Override
    public void remove(Collection<?> batchToRemove) {
        for (Object toRemove : batchToRemove) {
            this.remove(toRemove);
        }
    }

    @Override
    public <T> T execute(BucketCallback<T> action) {
        try {
            return action.doInBucket();
        }
        catch (RuntimeException e) {
            throw this.exceptionTranslator.translateExceptionIfPossible(e);
        }
        catch (TimeoutException e) {
            throw new QueryTimeoutException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new OperationInterruptedException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new OperationInterruptedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean exists(final String id) {
        String result = this.execute(new BucketCallback<String>(){

            @Override
            public String doInBucket() {
                return (String)CouchbaseTemplate.this.client.get(id);
            }
        });
        return result != null;
    }

    protected static void ensureNotIterable(Object o) {
        if (null != o && (o.getClass().isArray() || ITERABLE_CLASSES.contains(o.getClass().getName()))) {
            throw new IllegalArgumentException("Cannot use a collection here.");
        }
    }

    @Override
    public CouchbaseConverter getConverter() {
        return this.couchbaseConverter;
    }

    @Override
    public void save(Object objectToSave, final PersistTo persistTo, final ReplicateTo replicateTo) {
        CouchbaseTemplate.ensureNotIterable(objectToSave);
        final BeanWrapper beanWrapper = BeanWrapper.create((Object)objectToSave, (ConversionService)this.couchbaseConverter.getConversionService());
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(objectToSave.getClass());
        final CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        final Long version = versionProperty != null ? (Long)beanWrapper.getProperty((PersistentProperty)versionProperty, Long.class) : null;
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(objectToSave));
        final CouchbaseDocument converted = new CouchbaseDocument();
        this.couchbaseConverter.write(objectToSave, converted);
        this.maybeEmitEvent(new BeforeSaveEvent<Object>(objectToSave, converted));
        this.execute(new BucketCallback<Boolean>(){

            @Override
            public Boolean doInBucket() throws InterruptedException, ExecutionException {
                if (version == null) {
                    OperationFuture setFuture = CouchbaseTemplate.this.client.set(converted.getId(), converted.getExpiration(), CouchbaseTemplate.this.translateEncode(converted), persistTo, replicateTo);
                    boolean future = (Boolean)setFuture.get();
                    if (!future) {
                        CouchbaseTemplate.this.handleWriteResultError("Saving document failed: " + setFuture.getStatus().getMessage());
                    }
                    return future;
                }
                OperationFuture casFuture = CouchbaseTemplate.this.client.asyncCas(converted.getId(), version.longValue(), converted.getExpiration(), CouchbaseTemplate.this.translateEncode(converted), persistTo, replicateTo);
                CASResponse cas = (CASResponse)casFuture.get();
                if (cas == CASResponse.EXISTS) {
                    throw new OptimisticLockingFailureException("Saving document with version value failed: " + cas);
                }
                long newCas = casFuture.getCas();
                beanWrapper.setProperty((PersistentProperty)versionProperty, (Object)newCas);
                return true;
            }
        });
        this.maybeEmitEvent(new AfterSaveEvent<Object>(objectToSave, converted));
    }

    @Override
    public void save(Collection<?> batchToSave, PersistTo persistTo, ReplicateTo replicateTo) {
        for (Object toSave : batchToSave) {
            this.save(toSave, persistTo, replicateTo);
        }
    }

    @Override
    public void insert(Object objectToInsert, final PersistTo persistTo, final ReplicateTo replicateTo) {
        Long version;
        CouchbaseTemplate.ensureNotIterable(objectToInsert);
        final CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(objectToInsert.getClass());
        final BeanWrapper beanWrapper = BeanWrapper.create((Object)objectToInsert, (ConversionService)this.couchbaseConverter.getConversionService());
        if (persistentEntity != null && persistentEntity.hasVersionProperty() && (version = (Long)beanWrapper.getProperty(persistentEntity.getVersionProperty(), Long.class)) == 0L) {
            beanWrapper.setProperty(persistentEntity.getVersionProperty(), (Object)0);
        }
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(objectToInsert));
        final CouchbaseDocument converted = new CouchbaseDocument();
        this.couchbaseConverter.write(objectToInsert, converted);
        this.maybeEmitEvent(new BeforeSaveEvent<Object>(objectToInsert, converted));
        this.execute(new BucketCallback<Boolean>(){

            @Override
            public Boolean doInBucket() throws InterruptedException, ExecutionException {
                OperationFuture addFuture = CouchbaseTemplate.this.client.add(converted.getId(), converted.getExpiration(), CouchbaseTemplate.this.translateEncode(converted), persistTo, replicateTo);
                boolean result = (Boolean)addFuture.get();
                if (!result) {
                    CouchbaseTemplate.this.handleWriteResultError("Inserting document failed: " + addFuture.getStatus().getMessage());
                }
                if (result && persistentEntity.hasVersionProperty()) {
                    beanWrapper.setProperty(persistentEntity.getVersionProperty(), (Object)addFuture.getCas());
                }
                return result;
            }
        });
        this.maybeEmitEvent(new AfterSaveEvent<Object>(objectToInsert, converted));
    }

    @Override
    public void insert(Collection<?> batchToInsert, PersistTo persistTo, ReplicateTo replicateTo) {
        for (Object toInsert : batchToInsert) {
            this.insert(toInsert, persistTo, replicateTo);
        }
    }

    @Override
    public void update(Object objectToUpdate, final PersistTo persistTo, final ReplicateTo replicateTo) {
        CouchbaseTemplate.ensureNotIterable(objectToUpdate);
        final BeanWrapper beanWrapper = BeanWrapper.create((Object)objectToUpdate, (ConversionService)this.couchbaseConverter.getConversionService());
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(objectToUpdate.getClass());
        final CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        final Long version = versionProperty != null ? (Long)beanWrapper.getProperty((PersistentProperty)versionProperty, Long.class) : null;
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(objectToUpdate));
        final CouchbaseDocument converted = new CouchbaseDocument();
        this.couchbaseConverter.write(objectToUpdate, converted);
        this.maybeEmitEvent(new BeforeSaveEvent<Object>(objectToUpdate, converted));
        this.execute(new BucketCallback<Boolean>(){

            @Override
            public Boolean doInBucket() throws InterruptedException, ExecutionException {
                if (version == null) {
                    return (Boolean)CouchbaseTemplate.this.client.replace(converted.getId(), converted.getExpiration(), CouchbaseTemplate.this.translateEncode(converted), persistTo, replicateTo).get();
                }
                OperationFuture casFuture = CouchbaseTemplate.this.client.asyncCas(converted.getId(), version.longValue(), converted.getExpiration(), CouchbaseTemplate.this.translateEncode(converted), persistTo, replicateTo);
                CASResponse cas = (CASResponse)casFuture.get();
                if (cas == CASResponse.EXISTS) {
                    throw new OptimisticLockingFailureException("Updating document with version value failed: " + cas);
                }
                long newCas = casFuture.getCas();
                beanWrapper.setProperty((PersistentProperty)versionProperty, (Object)newCas);
                return true;
            }
        });
        this.maybeEmitEvent(new AfterSaveEvent<Object>(objectToUpdate, converted));
    }

    @Override
    public void update(Collection<?> batchToUpdate, PersistTo persistTo, ReplicateTo replicateTo) {
        for (Object toUpdate : batchToUpdate) {
            this.update(toUpdate, persistTo, replicateTo);
        }
    }

    @Override
    public void remove(final Object objectToRemove, final PersistTo persistTo, final ReplicateTo replicateTo) {
        CouchbaseTemplate.ensureNotIterable(objectToRemove);
        this.maybeEmitEvent(new BeforeDeleteEvent<Object>(objectToRemove));
        if (objectToRemove instanceof String) {
            this.execute(new BucketCallback<Boolean>(){

                @Override
                public Boolean doInBucket() throws InterruptedException, ExecutionException {
                    return (Boolean)CouchbaseTemplate.this.client.delete((String)objectToRemove, persistTo, replicateTo).get();
                }
            });
            this.maybeEmitEvent(new AfterDeleteEvent<Object>(objectToRemove));
            return;
        }
        final CouchbaseDocument converted = new CouchbaseDocument();
        this.couchbaseConverter.write(objectToRemove, converted);
        this.execute(new BucketCallback<OperationFuture<Boolean>>(){

            @Override
            public OperationFuture<Boolean> doInBucket() {
                return CouchbaseTemplate.this.client.delete(converted.getId());
            }
        });
        this.maybeEmitEvent(new AfterDeleteEvent<Object>(objectToRemove));
    }

    @Override
    public void remove(Collection<?> batchToRemove, PersistTo persistTo, ReplicateTo replicateTo) {
        for (Object toRemove : batchToRemove) {
            this.remove(toRemove, persistTo, replicateTo);
        }
    }

    private void handleWriteResultError(String message) {
        if (this.writeResultChecking == WriteResultChecking.NONE) {
            return;
        }
        if (this.writeResultChecking == WriteResultChecking.EXCEPTION) {
            throw new CouchbaseDataIntegrityViolationException(message);
        }
        LOGGER.error(message);
    }

    protected <T> void maybeEmitEvent(CouchbaseMappingEvent<T> event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    @Override
    public CouchbaseClient getCouchbaseClient() {
        return this.client;
    }

    static {
        DEFAULT_WRITE_RESULT_CHECKING = WriteResultChecking.NONE;
        HashSet<String> iterableClasses = new HashSet<String>();
        iterableClasses.add(List.class.getName());
        iterableClasses.add(Collection.class.getName());
        iterableClasses.add(Iterator.class.getName());
        ITERABLE_CLASSES = Collections.unmodifiableCollection(iterableClasses);
    }
}

