/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.data.javapoet.TypeNames;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.javapoet.TypeName;

class AotRepositoryFragmentMetadata {
    private final Map<String, LocalField> fields = new HashMap<String, LocalField>(3);
    private final Map<String, ConstructorArgument> constructorArguments = new LinkedHashMap<String, ConstructorArgument>(3);
    private final Map<String, LocalMethod> methods = new LinkedHashMap<String, LocalMethod>();
    private final Map<String, DelegateMethod> delegateMethods = new LinkedHashMap<String, DelegateMethod>();

    AotRepositoryFragmentMetadata() {
    }

    public @Nullable String fieldNameOf(Class<?> type) {
        ResolvableType lookup = ResolvableType.forClass(type);
        for (Map.Entry<String, LocalField> field : this.fields.entrySet()) {
            if (!field.getValue().fieldType().getType().equals(lookup.getType())) continue;
            return field.getKey();
        }
        return null;
    }

    public void addField(String fieldName, ResolvableType type, Modifier ... modifiers) {
        this.fields.putIfAbsent(fieldName, new LocalField(fieldName, type, modifiers));
    }

    public Map<String, LocalField> getFields() {
        return this.fields;
    }

    public void addConstructorArgument(String parameterName, ResolvableType type, Supplier<ConstructorArgument> argumentSupplier) {
        this.constructorArguments.computeIfAbsent(parameterName, it -> {
            ConstructorArgument constructorArgument = (ConstructorArgument)argumentSupplier.get();
            if (constructorArgument.isBoundToField()) {
                this.addField(parameterName, type, Modifier.PRIVATE, Modifier.FINAL);
            }
            return constructorArgument;
        });
    }

    public void addRepositoryMethod(Method source, MethodContributor<? extends QueryMethod> methodContributor) {
        this.methods.putIfAbsent(source.toGenericString(), new LocalMethod(source, methodContributor));
    }

    public void addDelegateMethod(Method source, MethodContributor<? extends QueryMethod> methodContributor) {
        this.delegateMethods.putIfAbsent(source.toGenericString(), new DelegateMethod(source, null, methodContributor));
    }

    public void addDelegateMethod(Method source, RepositoryFragment<?> fragment) {
        this.delegateMethods.putIfAbsent(source.toGenericString(), new DelegateMethod(source, fragment, null));
    }

    public Map<String, ConstructorArgument> getConstructorArguments() {
        return this.constructorArguments;
    }

    Map<String, ResolvableType> getAutowireFields() {
        LinkedHashMap<String, ResolvableType> autowireFields = new LinkedHashMap<String, ResolvableType>(this.getConstructorArguments().size());
        for (Map.Entry<String, ConstructorArgument> entry : this.getConstructorArguments().entrySet()) {
            autowireFields.put(entry.getKey(), entry.getValue().parameterType());
        }
        return autowireFields;
    }

    public Map<String, LocalMethod> getMethods() {
        return this.methods;
    }

    public Map<String, DelegateMethod> getDelegateMethods() {
        return this.delegateMethods;
    }

    static TypeName typeNameOf(ResolvableType type) {
        return TypeNames.resolvedTypeName(type);
    }

    public record LocalField(String fieldName, ResolvableType fieldType, Modifier[] modifiers) {
        TypeName typeName() {
            return AotRepositoryFragmentMetadata.typeNameOf(this.fieldType());
        }
    }

    public record LocalMethod(Method source, MethodContributor<? extends QueryMethod> methodContributor) {
    }

    public record DelegateMethod(Method source, @Nullable RepositoryFragment<?> fragment, @Nullable MethodContributor<? extends QueryMethod> methodContributor) {
    }

    public record ConstructorArgument(String parameterName, ResolvableType parameterType, boolean bindToField, AotRepositoryConstructorBuilder.ParameterOrigin parameterOrigin) {
        boolean isBoundToField() {
            return this.bindToField;
        }

        TypeName typeName() {
            return AotRepositoryFragmentMetadata.typeNameOf(this.parameterType());
        }
    }
}

