/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.aot.generate.AotFragmentTarget;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryFragmentMetadata;
import org.springframework.data.repository.aot.generate.AotRepositoryMetadata;
import org.springframework.data.repository.aot.generate.AotRepositoryMethod;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.data.repository.aot.generate.RepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.ResolvableGenerics;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.Lazy;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.FieldSpec;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.TypeSpec;
import org.springframework.util.Assert;

class AotRepositoryCreator {
    private static final Log logger = LogFactory.getLog(AotRepositoryCreator.class);
    private final RepositoryInformation repositoryInformation;
    private final String moduleName;
    private final ProjectionFactory projectionFactory;
    private final AotRepositoryFragmentMetadata generationMetadata;
    private @Nullable RepositoryConstructorBuilder constructorBuilder;
    private Consumer<AotRepositoryClassBuilder> classCustomizer;

    private AotRepositoryCreator(RepositoryInformation repositoryInformation, String moduleName, ProjectionFactory projectionFactory) {
        this.repositoryInformation = repositoryInformation;
        this.moduleName = moduleName;
        this.projectionFactory = projectionFactory;
        this.generationMetadata = new AotRepositoryFragmentMetadata();
        this.classCustomizer = builder -> {};
    }

    static AotRepositoryCreator forRepository(RepositoryInformation information, String moduleName, ProjectionFactory projectionFactory) {
        return new AotRepositoryCreator(information, moduleName, projectionFactory);
    }

    ClassName getClassName() {
        return ClassName.get((String)this.packageName(), (String)"%sImpl".formatted(this.repositoryInformation.getRepositoryInterface().getSimpleName()), (String[])new String[0]);
    }

    String packageName() {
        return this.repositoryInformation.getRepositoryInterface().getPackageName();
    }

    AotRepositoryFragmentMetadata getRepositoryMetadata() {
        return this.generationMetadata;
    }

    RepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    ProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    AotBundle create(TypeSpec.Builder target) {
        ArrayList methodMetadata = new ArrayList();
        target.addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addJavadoc("AOT generated $L repository implementation for {@link $T}.\n", new Object[]{this.moduleName, this.repositoryInformation.getRepositoryInterface()});
        target.addMethod(this.buildConstructor());
        this.generationMetadata.getMethods().values().forEach(localMethod -> {
            AotQueryMethodGenerationContext context;
            MethodContributor<? extends QueryMethod> methodContributor = localMethod.methodContributor();
            MethodSpec methodSpec = methodContributor.contribute(context = new AotQueryMethodGenerationContext(this.repositoryInformation, localMethod.source(), methodContributor.getQueryMethod(), this.generationMetadata));
            if (methodSpec != null) {
                target.addMethod(methodSpec);
            }
            methodMetadata.add(new AotRepositoryMethod(localMethod.source().getName(), localMethod.source().toGenericString(), methodContributor.getMetadata(), null));
        });
        this.generationMetadata.getDelegateMethods().values().forEach(delegateMethod -> {
            String signature = delegateMethod.fragment() != null ? delegateMethod.fragment().getSignatureContributor().getName() : delegateMethod.source().getDeclaringClass().getName();
            String implementation = delegateMethod.fragment() != null ? (String)delegateMethod.fragment().getImplementationClass().map(Class::getName).orElse(null) : null;
            QueryMetadata query = delegateMethod.methodContributor() != null ? delegateMethod.methodContributor().getMetadata() : null;
            methodMetadata.add(new AotRepositoryMethod(delegateMethod.source().getName(), signature, query, new AotFragmentTarget(signature, implementation)));
        });
        this.generationMetadata.getFields().values().stream().map(field -> FieldSpec.builder((Type)field.fieldType().getType(), (String)field.fieldName(), (javax.lang.model.element.Modifier[])field.modifiers()).build()).forEach(arg_0 -> ((TypeSpec.Builder)target).addField(arg_0));
        this.classCustomizer.accept(customizer -> {
            Assert.notNull((Object)customizer, (String)"ClassCustomizer must not be null");
            customizer.customize(target);
        });
        return new AotBundle(this.repositoryInformation.getRepositoryInterface(), Lazy.of(() -> this.getAotRepositoryMetadata(methodMetadata)));
    }

    private MethodSpec buildConstructor() {
        return this.constructorBuilder != null ? this.constructorBuilder.buildConstructor() : MethodSpec.constructorBuilder().addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).build();
    }

    private AotRepositoryMetadata getAotRepositoryMetadata(List<AotRepositoryMethod> methodMetadata) {
        AotRepositoryMetadata.RepositoryType repositoryType = this.repositoryInformation.isReactiveRepository() ? AotRepositoryMetadata.RepositoryType.REACTIVE : AotRepositoryMetadata.RepositoryType.IMPERATIVE;
        String jsonModuleName = this.moduleName != null ? this.moduleName.replaceAll("Reactive", "").trim() : null;
        return new AotRepositoryMetadata(this.repositoryInformation.getRepositoryInterface().getName(), jsonModuleName, repositoryType, methodMetadata);
    }

    AotRepositoryCreator customizeClass(Consumer<AotRepositoryClassBuilder> classCustomizer) {
        this.classCustomizer = classCustomizer;
        return this;
    }

    AotRepositoryCreator customizeConstructor(Consumer<AotRepositoryConstructorBuilder> constructorCustomizer) {
        if (this.constructorBuilder != null) {
            this.constructorBuilder.dispose();
        }
        RepositoryConstructorBuilder constructorBuilder = new RepositoryConstructorBuilder(this.generationMetadata);
        constructorCustomizer.accept(constructorBuilder);
        this.constructorBuilder = constructorBuilder;
        return this;
    }

    void contributeMethods(@Nullable MethodContributorFactory methodContributorFactory) {
        Arrays.stream(this.repositoryInformation.getRepositoryInterface().getMethods()).sorted(Comparator.comparing(it -> it.getDeclaringClass().getName()).thenComparing(Method::getName).thenComparing(Method::getParameterCount).thenComparing(Method::toString)).forEach(method -> {
            block2: {
                try {
                    this.contributeMethod((Method)method, methodContributorFactory);
                }
                catch (RuntimeException e) {
                    if (!logger.isErrorEnabled()) break block2;
                    logger.error((Object)"Failed to contribute Repository method [%s.%s]".formatted(this.repositoryInformation.getRepositoryInterface().getName(), method.getName()), (Throwable)e);
                }
            }
        });
    }

    private void contributeMethod(Method method, @Nullable MethodContributorFactory contributorFactory) {
        RepositoryComposition repositoryComposition;
        RepositoryFragment<?> fragment;
        if ((this.repositoryInformation.isCustomMethod(method) || this.repositoryInformation.isBaseClassMethod(method) && !this.repositoryInformation.isQueryMethod(method)) && (fragment = (repositoryComposition = this.repositoryInformation.getRepositoryComposition()).findFragment(method)) != null) {
            this.generationMetadata.addDelegateMethod(method, fragment);
            return;
        }
        if (method.isBridge() || method.isDefault() || Modifier.isStatic(method.getModifiers())) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Skipping %s method [%s.%s] contribution".formatted(method.isBridge() ? "bridge" : (method.isDefault() ? "default" : "static"), this.repositoryInformation.getRepositoryInterface().getName(), method.getName()));
            }
            return;
        }
        if (!this.repositoryInformation.isQueryMethod(method)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Skipping method [%s.%s] contribution, not a query method".formatted(this.repositoryInformation.getRepositoryInterface().getName(), method.getName()));
            }
            return;
        }
        if (contributorFactory == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Skipping method [%s.%s] contribution, no MethodContributorFactory available".formatted(this.repositoryInformation.getRepositoryInterface().getName(), method.getName()));
            }
            return;
        }
        MethodContributor<? extends QueryMethod> contributor = contributorFactory.create(method);
        if (contributor == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Skipping method [%s.%s] contribution, no MethodContributor available".formatted(this.repositoryInformation.getRepositoryInterface().getName(), method.getName()));
            }
            return;
        }
        if (ResolvableGenerics.of(method, this.repositoryInformation.getRepositoryInterface()).hasUnresolvableGenerics()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Skipping implementation method [%s.%s] contribution. Method uses generics that currently cannot be resolved.".formatted(this.repositoryInformation.getRepositoryInterface().getName(), method.getName()));
            }
            this.generationMetadata.addDelegateMethod(method, contributor);
            return;
        }
        if (!contributor.contributesMethodSpec() || this.repositoryInformation.isReactiveRepository()) {
            if (this.repositoryInformation.isReactiveRepository() && logger.isTraceEnabled()) {
                logger.trace((Object)"Skipping implementation method [%s.%s] contribution. AOT repositories are not supported for reactive repositories.".formatted(this.repositoryInformation.getRepositoryInterface().getName(), method.getName()));
            }
            if (!contributor.contributesMethodSpec() && logger.isTraceEnabled()) {
                logger.trace((Object)"Skipping implementation method [%s.%s] contribution. Spring Data %s did not provide a method implementation.".formatted(this.repositoryInformation.getRepositoryInterface().getName(), method.getName(), this.moduleName));
            }
            this.generationMetadata.addDelegateMethod(method, contributor);
            return;
        }
        this.generationMetadata.addRepositoryMethod(method, contributor);
    }

    record AotBundle(Class<?> sourceRepository, Lazy<AotRepositoryMetadata> metadata) {
        String repositoryJsonFileName() {
            return this.sourceRepository.getName().replace('.', '/') + ".json";
        }
    }

    public static interface MethodContributorFactory {
        public @Nullable MethodContributor<? extends QueryMethod> create(Method var1);
    }
}

