/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.EventPublishingRepositoryProxyPostProcessor;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactoryCustomizer;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryFragmentsContributor;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;

public abstract class RepositoryFactoryBeanSupport<T extends Repository<S, ID>, S, ID>
implements InitializingBean,
RepositoryFactoryInformation<S, ID>,
FactoryBean<T>,
ApplicationEventPublisherAware,
BeanClassLoaderAware,
BeanFactoryAware,
EnvironmentAware {
    private final Class<? extends T> repositoryInterface;
    private @Nullable RepositoryFactorySupport factory;
    private boolean exposeMetadata;
    private  @Nullable QueryLookupStrategy.Key queryLookupStrategyKey;
    private @Nullable Class<?> repositoryBaseClass;
    private @Nullable Object customImplementation;
    private final List<RepositoryFragmentsFunction> fragments = new ArrayList<RepositoryFragmentsFunction>();
    private NamedQueries namedQueries = PropertiesBasedNamedQueries.EMPTY;
    private @Nullable MappingContext<?, ?> mappingContext;
    private @Nullable ClassLoader classLoader;
    private @Nullable ApplicationEventPublisher publisher;
    private @Nullable BeanFactory beanFactory;
    private @Nullable Environment environment;
    private boolean lazyInit = Boolean.getBoolean("spring.aot.processing");
    private @Nullable EvaluationContextProvider evaluationContextProvider;
    private final List<RepositoryFactoryCustomizer> repositoryFactoryCustomizers = new ArrayList<RepositoryFactoryCustomizer>();
    private RepositoryComposition.RepositoryFragments cachedFragments = RepositoryComposition.RepositoryFragments.empty();
    private @Nullable Lazy<T> repository;
    private @Nullable RepositoryMetadata repositoryMetadata;

    protected RepositoryFactoryBeanSupport(Class<? extends T> repositoryInterface) {
        Assert.notNull(repositoryInterface, (String)"Repository interface must not be null");
        this.repositoryInterface = repositoryInterface;
    }

    public void setRepositoryBaseClass(Class<?> repositoryBaseClass) {
        this.repositoryBaseClass = repositoryBaseClass;
    }

    public void setExposeMetadata(boolean exposeMetadata) {
        this.exposeMetadata = exposeMetadata;
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key queryLookupStrategyKey) {
        this.queryLookupStrategyKey = queryLookupStrategyKey;
    }

    public void setCustomImplementation(Object customImplementation) {
        this.customImplementation = customImplementation;
    }

    public void setRepositoryFragments(RepositoryComposition.RepositoryFragments repositoryFragments) {
        this.setRepositoryFragmentsFunction(RepositoryFragmentsFunction.just(repositoryFragments));
    }

    public void setRepositoryFragmentsFunction(RepositoryFragmentsFunction fragmentsFunction) {
        this.fragments.add(fragmentsFunction);
    }

    public void setNamedQueries(NamedQueries namedQueries) {
        this.namedQueries = namedQueries;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public void setEvaluationContextProvider(EvaluationContextProvider evaluationContextProvider) {
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public void addRepositoryFactoryCustomizer(RepositoryFactoryCustomizer customizer) {
        Assert.notNull((Object)customizer, (String)"RepositoryFactoryCustomizer must not be null");
        this.repositoryFactoryCustomizers.add(customizer);
    }

    public void setLazyInit(boolean lazy) {
        this.lazyInit = lazy;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (this.evaluationContextProvider == null && beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            this.evaluationContextProvider = this.createDefaultEvaluationContextProvider(lbf);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected @Nullable EvaluationContextProvider createDefaultEvaluationContextProvider(ListableBeanFactory beanFactory) {
        return QueryMethodValueEvaluationContextAccessor.createEvaluationContextProvider(beanFactory);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public EntityInformation<S, ID> getEntityInformation() {
        return this.getRequiredFactory().getEntityInformation(this.getRequiredRepositoryMetadata());
    }

    @Override
    public RepositoryInformation getRepositoryInformation() {
        return this.getRequiredFactory().getRepositoryInformation(this.getRequiredRepositoryMetadata(), this.cachedFragments);
    }

    @Override
    public RepositoryFragmentsContributor getRepositoryFragmentsContributor() {
        return RepositoryFragmentsContributor.empty();
    }

    @Override
    public PersistentEntity<?, ?> getPersistentEntity() {
        Assert.state((this.mappingContext != null ? 1 : 0) != 0, (String)"No MappingContext available");
        return this.mappingContext.getRequiredPersistentEntity(this.getRequiredRepositoryMetadata().getDomainType());
    }

    @Override
    public List<QueryMethod> getQueryMethods() {
        return this.getRequiredFactory().getQueryMethods();
    }

    public @NonNull T getObject() {
        Assert.state((this.repository != null ? 1 : 0) != 0, (String)"RepositoryFactory is not initialized");
        return (T)((Repository)this.repository.get());
    }

    public @NonNull Class<? extends T> getObjectType() {
        return this.repositoryInterface;
    }

    RepositoryFactorySupport getRequiredFactory() {
        Assert.state((this.factory != null ? 1 : 0) != 0, (String)"RepositoryFactory is not initialized");
        return this.factory;
    }

    RepositoryMetadata getRequiredRepositoryMetadata() {
        Assert.state((this.repositoryMetadata != null ? 1 : 0) != 0, (String)"RepositoryMetadata is not initialized");
        return this.repositoryMetadata;
    }

    public void afterPropertiesSet() {
        RepositoryComposition.RepositoryFragments repositoryFragments;
        this.factory = this.createRepositoryFactory();
        this.factory.setExposeMetadata(this.exposeMetadata);
        this.factory.setQueryLookupStrategyKey(this.queryLookupStrategyKey);
        this.factory.setNamedQueries(this.namedQueries);
        this.factory.setEvaluationContextProvider(this.evaluationContextProvider != null ? this.evaluationContextProvider : QueryMethodValueEvaluationContextAccessor.DEFAULT_CONTEXT_PROVIDER);
        this.factory.setBeanClassLoader(this.classLoader);
        if (this.beanFactory != null) {
            this.factory.setBeanFactory(this.beanFactory);
        }
        if (this.publisher != null) {
            this.factory.addRepositoryProxyPostProcessor(new EventPublishingRepositoryProxyPostProcessor(this.publisher));
        }
        if (this.environment != null) {
            this.factory.setEnvironment(this.environment);
        }
        if (this.repositoryBaseClass != null) {
            this.factory.setRepositoryBaseClass(this.repositoryBaseClass);
        }
        this.repositoryFactoryCustomizers.forEach(customizer -> customizer.customize(this.factory));
        RepositoryMetadata metadata = this.factory.getRepositoryMetadata(this.repositoryInterface);
        this.cachedFragments = repositoryFragments = this.getRepositoryFragments(metadata);
        this.repositoryMetadata = metadata;
        this.repository = Lazy.of(() -> (Repository)this.getRequiredFactory().getRepository(this.repositoryInterface, repositoryFragments));
        if (this.mappingContext != null) {
            this.mappingContext.getPersistentEntity(this.repositoryMetadata.getDomainType());
        }
        if (!this.lazyInit) {
            this.repository.get();
        }
    }

    protected abstract RepositoryFactorySupport createRepositoryFactory();

    private RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata repositoryMetadata) {
        RepositoryFactorySupport factory = this.getRequiredFactory();
        ValueExpressionDelegate valueExpressionDelegate = factory.getValueExpressionDelegate();
        ArrayList<RepositoryFragmentsFunction> functions = new ArrayList<RepositoryFragmentsFunction>(this.fragments);
        if (this.customImplementation != null) {
            functions.add(0, RepositoryFragmentsFunction.just(RepositoryComposition.RepositoryFragments.just(this.customImplementation)));
        }
        DefaultFragmentCreationContext creationContext = new DefaultFragmentCreationContext(repositoryMetadata, valueExpressionDelegate, factory::getProjectionFactory);
        RepositoryComposition.RepositoryFragments fragments = RepositoryComposition.RepositoryFragments.empty();
        for (RepositoryFragmentsFunction function : functions) {
            fragments = fragments.append(function.getRepositoryFragments(this.beanFactory, creationContext));
        }
        return fragments;
    }

    public static interface RepositoryFragmentsFunction {
        public RepositoryComposition.RepositoryFragments getRepositoryFragments(@Nullable BeanFactory var1, FragmentCreationContext var2);

        public static RepositoryFragmentsFunction just(RepositoryComposition.RepositoryFragments fragments) {
            return (bf, context) -> fragments;
        }
    }

    private record DefaultFragmentCreationContext(RepositoryMetadata repositoryMetadata, ValueExpressionDelegate valueExpressionDelegate, Supplier<ProjectionFactory> projectionFactory) implements FragmentCreationContext
    {
        @Override
        public RepositoryMetadata getRepositoryMetadata() {
            return this.repositoryMetadata;
        }

        @Override
        public ValueExpressionDelegate getValueExpressionDelegate() {
            return this.valueExpressionDelegate();
        }

        @Override
        public ProjectionFactory getProjectionFactory() {
            return this.projectionFactory().get();
        }
    }

    public static interface FragmentCreationContext {
        public RepositoryMetadata getRepositoryMetadata();

        public ValueExpressionDelegate getValueExpressionDelegate();

        public ProjectionFactory getProjectionFactory();
    }
}

