/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core;

import org.jspecify.annotations.Nullable;
import org.springframework.core.NamedThreadLocal;
import org.springframework.data.repository.core.RepositoryMethodContext;

public class RepositoryMethodContextHolder {
    private static final ThreadLocal<RepositoryMethodContext> currentMethod = new NamedThreadLocal("Current Repository Method");

    public static @Nullable RepositoryMethodContext setContext(@Nullable RepositoryMethodContext context) {
        RepositoryMethodContext old = currentMethod.get();
        if (context != null) {
            currentMethod.set(context);
        } else {
            currentMethod.remove();
        }
        return old;
    }

    public static RepositoryMethodContext getContext() {
        RepositoryMethodContext metadata = currentMethod.get();
        if (metadata == null) {
            throw new IllegalStateException("Cannot find current repository method: Set 'exposeMetadata' property on RepositoryFactorySupport to 'true' to make it available, and ensure that RepositoryMethodContext.getContext() is invoked in the same thread as the repository invocation.");
        }
        return metadata;
    }
}

