/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.Generated;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.aot.generate.AotFragmentTarget;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryFragmentMetadata;
import org.springframework.data.repository.aot.generate.AotRepositoryMetadata;
import org.springframework.data.repository.aot.generate.AotRepositoryMethod;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.aot.generate.RepositoryConstructorBuilder;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.JavaFile;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;
import org.springframework.util.Assert;

class AotRepositoryBuilder {
    private static final Log logger = LogFactory.getLog(AotRepositoryBuilder.class);
    private final RepositoryInformation repositoryInformation;
    private final String moduleName;
    private final ProjectionFactory projectionFactory;
    private final AotRepositoryFragmentMetadata generationMetadata;
    private @Nullable Consumer<AotRepositoryConstructorBuilder> constructorCustomizer;
    private @Nullable MethodContributorFactory methodContributorFactory;
    private @Nullable String targetClassName;
    private Consumer<AotRepositoryClassBuilder> classCustomizer;
    private final RepositoryConstructorBuilder constructorBuilder;

    private AotRepositoryBuilder(RepositoryInformation repositoryInformation, String moduleName, ProjectionFactory projectionFactory) {
        this.repositoryInformation = repositoryInformation;
        this.moduleName = moduleName;
        this.projectionFactory = projectionFactory;
        this.generationMetadata = new AotRepositoryFragmentMetadata();
        this.classCustomizer = builder -> {};
        this.constructorBuilder = new RepositoryConstructorBuilder(this.generationMetadata);
    }

    public static AotRepositoryBuilder forRepository(RepositoryInformation information, String moduleName, ProjectionFactory projectionFactory) {
        return new AotRepositoryBuilder(information, moduleName, projectionFactory);
    }

    public AotRepositoryBuilder withClassCustomizer(Consumer<AotRepositoryClassBuilder> classCustomizer) {
        this.classCustomizer = classCustomizer;
        return this;
    }

    public AotRepositoryBuilder withConstructorCustomizer(Consumer<AotRepositoryConstructorBuilder> constructorCustomizer) {
        this.constructorCustomizer = constructorCustomizer;
        return this;
    }

    public AotRepositoryBuilder withQueryMethodContributor(MethodContributorFactory methodContributorFactory) {
        this.methodContributorFactory = methodContributorFactory;
        return this;
    }

    public AotRepositoryBuilder withClassName(@Nullable String className) {
        this.targetClassName = className;
        return this;
    }

    public AotBundle build(TypeSpec.Builder builder) {
        ArrayList<AotRepositoryMethod> methodMetadata = new ArrayList<AotRepositoryMethod>();
        RepositoryComposition repositoryComposition = this.repositoryInformation.getRepositoryComposition();
        builder.addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addJavadoc("AOT generated $L repository implementation for {@link $T}.\n", new Object[]{this.moduleName, this.repositoryInformation.getRepositoryInterface()});
        builder.addMethod(this.buildConstructor());
        Arrays.stream(this.repositoryInformation.getRepositoryInterface().getMethods()).sorted(Comparator.comparing(it -> it.getDeclaringClass().getName()).thenComparing(Method::getName).thenComparing(Method::getParameterCount).thenComparing(Method::toString)).forEach(method -> {
            block2: {
                try {
                    this.contributeMethod((Method)method, repositoryComposition, (List<AotRepositoryMethod>)methodMetadata, builder);
                }
                catch (RuntimeException e) {
                    if (!logger.isErrorEnabled()) break block2;
                    logger.error((Object)"Failed to contribute Repository method [%s.%s]".formatted(this.repositoryInformation.getRepositoryInterface().getName(), method.getName()), (Throwable)e);
                }
            }
        });
        this.generationMetadata.getFields().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addField(arg_0));
        this.classCustomizer.accept(customizer -> {
            Assert.notNull((Object)customizer, (String)"ClassCustomizer must not be null");
            customizer.customize(builder);
        });
        JavaFile javaFile = JavaFile.builder((String)this.packageName(), (TypeSpec)builder.build()).build();
        AotRepositoryMetadata metadata = this.getAotRepositoryMetadata(methodMetadata);
        return new AotBundle(javaFile, metadata);
    }

    public AotBundle build() {
        return this.build(TypeSpec.classBuilder((ClassName)this.getClassName()).addAnnotation(Generated.class));
    }

    public ClassName getClassName() {
        return ClassName.get((String)this.packageName(), (String)(this.targetClassName != null ? this.targetClassName : this.typeName()), (String[])new String[0]);
    }

    private MethodSpec buildConstructor() {
        if (this.constructorCustomizer != null) {
            this.constructorCustomizer.accept(this.constructorBuilder);
        }
        return this.constructorBuilder.buildConstructor();
    }

    private AotRepositoryMetadata getAotRepositoryMetadata(List<AotRepositoryMethod> methodMetadata) {
        AotRepositoryMetadata.RepositoryType repositoryType = this.repositoryInformation.isReactiveRepository() ? AotRepositoryMetadata.RepositoryType.REACTIVE : AotRepositoryMetadata.RepositoryType.IMPERATIVE;
        String jsonModuleName = this.moduleName != null ? this.moduleName.replaceAll("Reactive", "").trim() : null;
        return new AotRepositoryMetadata(this.repositoryInformation.getRepositoryInterface().getName(), jsonModuleName, repositoryType, methodMetadata);
    }

    private void contributeMethod(Method method, RepositoryComposition repositoryComposition, List<AotRepositoryMethod> methodMetadata, TypeSpec.Builder builder) {
        MethodContributor<? extends QueryMethod> contributor;
        RepositoryFragment<?> fragment;
        if ((this.repositoryInformation.isCustomMethod(method) || this.repositoryInformation.isBaseClassMethod(method) && !this.repositoryInformation.isQueryMethod(method)) && (fragment = repositoryComposition.findFragment(method)) != null) {
            methodMetadata.add(this.getFragmentMetadata(method, fragment));
            return;
        }
        if (method.isBridge() || method.isDefault() || Modifier.isStatic(method.getModifiers())) {
            return;
        }
        if (this.repositoryInformation.isQueryMethod(method) && this.methodContributorFactory != null && (contributor = this.methodContributorFactory.create(method)) != null) {
            if (contributor.contributesMethodSpec() && !this.repositoryInformation.isReactiveRepository()) {
                AotQueryMethodGenerationContext context = new AotQueryMethodGenerationContext(this.repositoryInformation, method, contributor.getQueryMethod(), this.generationMetadata);
                builder.addMethod(contributor.contribute(context));
            }
            methodMetadata.add(new AotRepositoryMethod(method.getName(), method.toGenericString(), contributor.getMetadata(), null));
        }
    }

    private AotRepositoryMethod getFragmentMetadata(Method method, RepositoryFragment<?> fragment) {
        String signature = fragment.getSignatureContributor().getName();
        String implementation = fragment.getImplementationClass().map(Class::getName).orElse(null);
        AotFragmentTarget fragmentTarget = new AotFragmentTarget(signature, implementation);
        return new AotRepositoryMethod(method.getName(), method.toGenericString(), null, fragmentTarget);
    }

    public AotRepositoryFragmentMetadata getGenerationMetadata() {
        return this.generationMetadata;
    }

    public String packageName() {
        return this.repositoryInformation.getRepositoryInterface().getPackageName();
    }

    public String typeName() {
        return "%sImpl".formatted(this.repositoryInformation.getRepositoryInterface().getSimpleName());
    }

    public Map<String, TypeName> getAutowireFields() {
        LinkedHashMap<String, TypeName> autowireFields = new LinkedHashMap<String, TypeName>(this.generationMetadata.getConstructorArguments().size());
        for (Map.Entry<String, AotRepositoryFragmentMetadata.ConstructorArgument> entry : this.generationMetadata.getConstructorArguments().entrySet()) {
            autowireFields.put(entry.getKey(), entry.getValue().typeName());
        }
        return autowireFields;
    }

    public RepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    public ProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    public static interface MethodContributorFactory {
        public @Nullable MethodContributor<? extends QueryMethod> create(Method var1);
    }

    record AotBundle(JavaFile javaFile, AotRepositoryMetadata metadata) {
    }

    public static interface ConstructorCustomizer {
        public void customize(AotRepositoryConstructorBuilder var1);
    }
}

