/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.geo;

import java.io.Serializable;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class Distance
implements Serializable,
Comparable<Distance> {
    private static final long serialVersionUID = 2460886201934027744L;
    private final double value;
    private final Metric metric;

    public Distance(double value) {
        this(value, Metrics.NEUTRAL);
    }

    public Distance(double value, Metric metric) {
        Assert.notNull((Object)metric, (String)"Metric must not be null");
        this.value = value;
        this.metric = metric;
    }

    public static Distance of(double value) {
        return new Distance(value);
    }

    public static Distance of(double value, Metric metric) {
        return new Distance(value, metric);
    }

    public static Range<Distance> between(Distance min, Distance max) {
        return Range.from(Range.Bound.inclusive(min)).to(Range.Bound.inclusive(max));
    }

    public static Range<Distance> between(double minValue, Metric minMetric, double maxValue, Metric maxMetric) {
        return Distance.between(new Distance(minValue, minMetric), new Distance(maxValue, maxMetric));
    }

    public double getNormalizedValue() {
        return this.value / this.metric.getMultiplier();
    }

    public String getUnit() {
        return this.metric.getAbbreviation();
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    public Distance add(Distance other) {
        Assert.notNull((Object)other, (String)"Distance to add must not be null");
        double newNormalizedValue = this.getNormalizedValue() + other.getNormalizedValue();
        return new Distance(newNormalizedValue * this.metric.getMultiplier(), this.metric);
    }

    @Contract(value="_, _ -> new")
    public Distance add(Distance other, Metric metric) {
        Assert.notNull((Object)other, (String)"Distance to must not be null");
        Assert.notNull((Object)metric, (String)"Result metric must not be null");
        double newLeft = this.getNormalizedValue() * metric.getMultiplier();
        double newRight = other.getNormalizedValue() * metric.getMultiplier();
        return new Distance(newLeft + newRight, metric);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    public Distance in(Metric metric) {
        Assert.notNull((Object)metric, (String)"Metric must not be null");
        return this.metric.equals(metric) ? this : new Distance(this.getNormalizedValue() * metric.getMultiplier(), metric);
    }

    @Override
    public int compareTo(@Nullable Distance that) {
        if (that == null) {
            return 1;
        }
        double difference = this.getNormalizedValue() - that.getNormalizedValue();
        return difference == 0.0 ? 0 : (difference > 0.0 ? 1 : -1);
    }

    public double getValue() {
        return this.value;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Distance)) {
            return false;
        }
        Distance distance = (Distance)o;
        if (this.value != distance.value) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.metric, (Object)distance.metric);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash((Object[])new Object[]{this.value, this.metric});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        if (this.metric != Metrics.NEUTRAL) {
            builder.append(" ").append(this.metric.toString());
        }
        return builder.toString();
    }
}

