/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

public class ValueExpressionQueryRewriter {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("([:?])([#$]\\{[^}]+})");
    private final ValueExpressionParser expressionParser;
    private final BiFunction<Integer, String, String> parameterNameSource;
    private final BiFunction<String, String, String> replacementSource;

    private ValueExpressionQueryRewriter(ValueExpressionParser expressionParser, BiFunction<Integer, String, String> parameterNameSource, BiFunction<String, String, String> replacementSource) {
        Assert.notNull((Object)expressionParser, (String)"ValueExpressionParser must not be null");
        Assert.notNull(parameterNameSource, (String)"Parameter name source must not be null");
        Assert.notNull(replacementSource, (String)"Replacement source must not be null");
        this.parameterNameSource = parameterNameSource;
        this.replacementSource = replacementSource;
        this.expressionParser = expressionParser;
    }

    public static ValueExpressionQueryRewriter of(ValueExpressionParser expressionParser, BiFunction<Integer, String, String> parameterNameSource, BiFunction<String, String, String> replacementSource) {
        return new ValueExpressionQueryRewriter(expressionParser, parameterNameSource, replacementSource);
    }

    public static EvaluatingValueExpressionQueryRewriter of(ValueExpressionDelegate delegate, BiFunction<Integer, String, String> parameterNameSource, BiFunction<String, String, String> replacementSource) {
        return ValueExpressionQueryRewriter.of((ValueExpressionParser)delegate, parameterNameSource, replacementSource).withEvaluationContextAccessor(delegate.getEvaluationContextAccessor());
    }

    public ParsedQuery parse(String query) {
        return new ParsedQuery(this.expressionParser, query);
    }

    public EvaluatingValueExpressionQueryRewriter withEvaluationContextAccessor(QueryMethodValueEvaluationContextAccessor accessor) {
        Assert.notNull((Object)accessor, (String)"QueryMethodValueEvaluationContextAccessor must not be null");
        return new EvaluatingValueExpressionQueryRewriter(this.expressionParser, accessor, this.parameterNameSource, this.replacementSource);
    }

    public static class EvaluatingValueExpressionQueryRewriter
    extends ValueExpressionQueryRewriter {
        private final QueryMethodValueEvaluationContextAccessor contextProviderFactory;

        private EvaluatingValueExpressionQueryRewriter(ValueExpressionParser expressionParser, QueryMethodValueEvaluationContextAccessor factory, BiFunction<Integer, String, String> parameterNameSource, BiFunction<String, String, String> replacementSource) {
            super(expressionParser, parameterNameSource, replacementSource);
            this.contextProviderFactory = factory;
        }

        public QueryExpressionEvaluator parse(String query, Parameters<?, ?> parameters) {
            return new QueryExpressionEvaluator(this.contextProviderFactory.create(parameters), this.parse(query));
        }
    }

    public class ParsedQuery {
        private static final int PREFIX_GROUP_INDEX = 1;
        private static final int EXPRESSION_GROUP_INDEX = 2;
        private final String query;
        private final Map<String, ValueExpression> expressions;
        private final QuotationMap quotations;

        ParsedQuery(ValueExpressionParser parser, String query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            HashMap<String, ValueExpression> expressions = new HashMap<String, ValueExpression>();
            Matcher matcher = EXPRESSION_PATTERN.matcher(query);
            StringBuilder resultQuery = new StringBuilder();
            QuotationMap quotedAreas = new QuotationMap(query);
            int expressionCounter = 0;
            int matchedUntil = 0;
            while (matcher.find()) {
                if (quotedAreas.isQuoted(matcher.start())) {
                    resultQuery.append(query, matchedUntil, matcher.end());
                } else {
                    String expressionString = matcher.group(2);
                    String prefix = matcher.group(1);
                    String parameterName = ValueExpressionQueryRewriter.this.parameterNameSource.apply(expressionCounter, expressionString);
                    String replacement = ValueExpressionQueryRewriter.this.replacementSource.apply(prefix, parameterName);
                    resultQuery.append(query, matchedUntil, matcher.start());
                    resultQuery.append(replacement);
                    expressions.put(parameterName, parser.parse(expressionString));
                    ++expressionCounter;
                }
                matchedUntil = matcher.end();
            }
            resultQuery.append(query.substring(matchedUntil));
            this.expressions = Collections.unmodifiableMap(expressions);
            this.query = resultQuery.toString();
            this.quotations = new QuotationMap(this.query);
        }

        public String getQueryString() {
            return this.query;
        }

        public boolean isQuoted(int index) {
            return this.quotations.isQuoted(index);
        }

        public boolean hasExpression(String name) {
            return this.expressions.get(name) != null;
        }

        public @Nullable ValueExpression getParameter(String name) {
            return this.expressions.get(name);
        }

        public ValueExpression getRequiredParameter(String name) {
            ValueExpression valueExpression = this.getParameter(name);
            if (valueExpression == null) {
                throw new IllegalArgumentException("No ValueExpression with name '%s' found in query".formatted(name));
            }
            return valueExpression;
        }

        public int size() {
            return this.expressions.size();
        }

        public boolean hasParameterBindings() {
            return !this.expressions.isEmpty();
        }

        public Map<String, ValueExpression> getParameterMap() {
            return this.expressions;
        }
    }

    public class QueryExpressionEvaluator {
        private final ValueEvaluationContextProvider evaluationContextProvider;
        private final ParsedQuery detector;

        public QueryExpressionEvaluator(ValueEvaluationContextProvider evaluationContextProvider, ParsedQuery detector) {
            this.evaluationContextProvider = evaluationContextProvider;
            this.detector = detector;
        }

        public Map<String, @Nullable Object> evaluate(Object[] values) {
            Assert.notNull((Object)values, (String)"Values must not be null.");
            Map<String, ValueExpression> parameterMap = this.detector.getParameterMap();
            LinkedHashMap<String, @Nullable Object> results = new LinkedHashMap<String, Object>(parameterMap.size());
            parameterMap.forEach((parameter, expression) -> results.put((String)parameter, this.evaluate((ValueExpression)expression, values)));
            return results;
        }

        public String getQueryString() {
            return this.detector.getQueryString();
        }

        private @Nullable Object evaluate(ValueExpression expression, Object[] values) {
            ValueEvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(values, expression.getExpressionDependencies());
            return expression.evaluate(evaluationContext);
        }
    }

    static class QuotationMap {
        private static final Collection<Character> QUOTING_CHARACTERS = Arrays.asList(Character.valueOf('\"'), Character.valueOf('\''));
        private final List<Range<Integer>> quotedRanges = new ArrayList<Range<Integer>>();

        public QuotationMap(@Nullable String query) {
            if (query == null) {
                return;
            }
            Character inQuotation = null;
            int start = 0;
            for (int i = 0; i < query.length(); ++i) {
                char currentChar = query.charAt(i);
                if (!QUOTING_CHARACTERS.contains(Character.valueOf(currentChar))) continue;
                if (inQuotation == null) {
                    inQuotation = Character.valueOf(currentChar);
                    start = i;
                    continue;
                }
                if (currentChar != inQuotation.charValue()) continue;
                inQuotation = null;
                this.quotedRanges.add(Range.from(Range.Bound.inclusive(start)).to(Range.Bound.inclusive(i)));
            }
            if (inQuotation != null) {
                throw new IllegalArgumentException(String.format("The string <%s> starts a quoted range at %d, but never ends it.", query, start));
            }
        }

        public boolean isQuoted(int index) {
            return this.quotedRanges.stream().anyMatch(r -> r.contains(Integer.valueOf(index)));
        }
    }
}

