/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.javapoet.ParameterSpec;
import org.springframework.javapoet.TypeName;

class MethodMetadata {
    private final Map<String, ParameterSpec> methodArguments = new LinkedHashMap<String, ParameterSpec>();
    private final ResolvableType actualReturnType;
    private final ResolvableType returnType;

    public MethodMetadata(RepositoryInformation repositoryInformation, Method method) {
        this.returnType = repositoryInformation.getReturnType(method).toResolvableType();
        this.actualReturnType = ResolvableType.forType(repositoryInformation.getReturnedDomainClass(method));
    }

    public @Nullable String getParameterNameOf(Class<?> type) {
        for (Map.Entry<String, ParameterSpec> entry : this.methodArguments.entrySet()) {
            if (!entry.getValue().type.equals((Object)TypeName.get(type))) continue;
            return entry.getKey();
        }
        return null;
    }

    public ResolvableType getReturnType() {
        return this.returnType;
    }

    public ResolvableType getActualReturnType() {
        return this.actualReturnType;
    }

    public void addParameter(ParameterSpec parameterSpec) {
        this.methodArguments.put(parameterSpec.name, parameterSpec);
    }

    public Map<String, ParameterSpec> getMethodArguments() {
        return this.methodArguments;
    }
}

