/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.util.List;
import org.springframework.data.repository.aot.generate.AotRepositoryMethod;
import org.springframework.data.repository.aot.generate.JSONArray;
import org.springframework.data.repository.aot.generate.JSONException;
import org.springframework.data.repository.aot.generate.JSONObject;

record AotRepositoryMetadata(String name, String module, RepositoryType type, List<AotRepositoryMethod> methods) {
    JSONObject toJson() throws JSONException {
        JSONObject metadata = new JSONObject();
        metadata.put("name", this.name());
        metadata.put("module", this.module());
        metadata.put("type", this.type().name());
        JSONArray methods = new JSONArray();
        for (AotRepositoryMethod method : this.methods()) {
            methods.put(method.toJson());
        }
        metadata.put("methods", methods);
        return metadata;
    }

    static enum RepositoryType {
        IMPERATIVE,
        REACTIVE;

    }
}

