/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.SynthesizedAnnotation;

public class TypeContributor {
    public static final String DATA_NAMESPACE = "org.springframework.data";

    public static void contribute(Class<?> type, GenerationContext contribution) {
        TypeContributor.contribute(type, Collections.emptySet(), contribution);
    }

    public static void contribute(Class<?> type, Predicate<Class<? extends Annotation>> filter, GenerationContext contribution) {
        if (type.isPrimitive()) {
            return;
        }
        if (type.isAnnotation() && filter.test(type)) {
            contribution.getRuntimeHints().reflection().registerType(type, hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS}));
            if (type.getPackage().getName().startsWith(DATA_NAMESPACE)) {
                contribution.getRuntimeHints().proxies().registerJdkProxy(new Class[]{type, SynthesizedAnnotation.class});
            }
            return;
        }
        if (type.isInterface()) {
            contribution.getRuntimeHints().reflection().registerType(type, hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}));
            return;
        }
        contribution.getRuntimeHints().reflection().registerType(type, hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.DECLARED_FIELDS}));
    }

    public static void contribute(Class<?> type, Set<String> annotationNamespaces, GenerationContext contribution) {
        TypeContributor.contribute(type, (Class<? extends Annotation> it) -> TypeContributor.isPartOfOrMetaAnnotatedWith(it, annotationNamespaces), contribution);
    }

    public static boolean isPartOf(Class<?> type, Set<String> namespaces) {
        return namespaces.stream().anyMatch(namespace -> type.getPackageName().startsWith((String)namespace));
    }

    public static boolean isPartOfOrMetaAnnotatedWith(Class<? extends Annotation> annotation, Set<String> namespaces) {
        if (TypeContributor.isPartOf(annotation, namespaces)) {
            return true;
        }
        return MergedAnnotation.of(annotation).getMetaTypes().stream().anyMatch(it -> TypeContributor.isPartOf(annotation, namespaces));
    }
}

