/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.util.List;
import java.util.function.BiConsumer;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.core.ResolvableType;
import org.springframework.data.aot.AotContext;
import org.springframework.data.aot.TypeCollector;
import org.springframework.data.domain.ManagedTypes;
import org.springframework.lang.Nullable;

public class ManagedTypesRegistrationAotContribution
implements BeanRegistrationAotContribution {
    private final AotContext aotContext;
    private final ManagedTypes managedTypes;
    private final BiConsumer<ResolvableType, GenerationContext> contributionAction;

    public ManagedTypesRegistrationAotContribution(AotContext aotContext, @Nullable ManagedTypes managedTypes, BiConsumer<ResolvableType, GenerationContext> contributionAction) {
        this.aotContext = aotContext;
        this.managedTypes = managedTypes;
        this.contributionAction = contributionAction;
    }

    protected AotContext getAotContext() {
        return this.aotContext;
    }

    protected ManagedTypes getManagedTypes() {
        return this.managedTypes == null ? ManagedTypes.empty() : this.managedTypes;
    }

    public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
        List<Class<?>> types = this.getManagedTypes().toList();
        if (!types.isEmpty()) {
            TypeCollector.inspect(types).forEach(type -> this.contributionAction.accept((ResolvableType)type, generationContext));
        }
    }
}

