/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

class FindByIdQuery {
    private final @Nullable String idProperty;
    private final List<Object> idCollection;

    private FindByIdQuery(@Nullable String idProperty, List<Object> idCollection) {
        this.idProperty = idProperty;
        this.idCollection = idCollection;
    }

    static FindByIdQuery forIds(Iterable<?> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null");
        ArrayList<Object> idCollection = new ArrayList<Object>();
        String idField = null;
        for (Object id : ids) {
            if (id instanceof MapId) {
                MapId mapId = (MapId)id;
                Iterator iterator = mapId.keySet().iterator();
                if (mapId.size() > 1) {
                    throw new InvalidDataAccessApiUsageException("MapId with multiple keys are not supported");
                }
                if (!iterator.hasNext()) {
                    throw new InvalidDataAccessApiUsageException("MapId is empty");
                }
                idField = (String)iterator.next();
                idCollection.add(mapId.get(idField));
                continue;
            }
            idCollection.add(id);
        }
        return new FindByIdQuery(idField, idCollection);
    }

    static boolean hasCompositeKeys(Iterable<?> ids, MappingContext<BasicCassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null");
        for (Object id : ids) {
            BasicCassandraPersistentEntity persistentEntity;
            MapId mapId;
            if (!(id instanceof MapId ? (mapId = (MapId)id).size() > 1 : (persistentEntity = (BasicCassandraPersistentEntity)mappingContext.getPersistentEntity(id.getClass())) != null && persistentEntity.isCompositePrimaryKey())) continue;
            return true;
        }
        return false;
    }

    @Nullable String getIdProperty() {
        return this.idProperty;
    }

    List<Object> getIdCollection() {
        return this.idCollection;
    }
}

