/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.repository.support.CassandraRepositoryFactory;
import org.springframework.data.cassandra.repository.support.CassandraRepositoryFragmentsContributor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class CassandraRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private boolean mappingContextConfigured = false;
    private @Nullable CassandraOperations cassandraOperations;
    private CassandraRepositoryFragmentsContributor repositoryFragmentsContributor = CassandraRepositoryFragmentsContributor.DEFAULT;

    public CassandraRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        Assert.state((this.cassandraOperations != null ? 1 : 0) != 0, (String)"CassandraOperations must not be null");
        CassandraRepositoryFactory factory = this.getFactoryInstance(this.cassandraOperations);
        factory.setFragmentsContributor(this.repositoryFragmentsContributor);
        return factory;
    }

    protected CassandraRepositoryFactory getFactoryInstance(CassandraOperations operations) {
        return new CassandraRepositoryFactory(operations);
    }

    public CassandraRepositoryFragmentsContributor getRepositoryFragmentsContributor() {
        return this.repositoryFragmentsContributor;
    }

    public void setRepositoryFragmentsContributor(CassandraRepositoryFragmentsContributor repositoryFragmentsContributor) {
        this.repositoryFragmentsContributor = repositoryFragmentsContributor;
    }

    public void setCassandraTemplate(CassandraTemplate cassandraTemplate) {
        this.cassandraOperations = cassandraTemplate;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.cassandraOperations, (String)"CassandraOperations must not be null");
        if (!this.mappingContextConfigured) {
            this.setMappingContext((MappingContext<?, ?>)this.cassandraOperations.getConverter().getMappingContext());
        }
    }
}

