/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.cassandra.core.query.CassandraScrollPosition;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ProjectionUtil;
import org.springframework.data.cassandra.repository.query.WindowUtil;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.SearchResult;
import org.springframework.data.domain.SearchResults;
import org.springframework.data.domain.Similarity;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Window;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.ClassUtils;

@FunctionalInterface
interface CassandraQueryExecution {
    public @Nullable Object execute(Statement<?> var1, Class<?> var2);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        private final ResultProcessor processor;
        private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
        private final EntityInstantiators instantiators;

        ResultProcessingConverter(ResultProcessor processor, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, EntityInstantiators instantiators) {
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
        }

        public @Nullable Object convert(@Nullable Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            if (source != null && returnedType.isInstance(source)) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }
    }

    public static final class ResultProcessingExecution
    implements CassandraQueryExecution {
        private final CassandraQueryExecution delegate;
        private final Converter<Object, Object> converter;

        ResultProcessingExecution(CassandraQueryExecution delegate, Converter<Object, Object> converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public @Nullable Object execute(Statement<?> statement, Class<?> type) {
            Object result = this.delegate.execute(statement, type);
            return result != null ? this.converter.convert(result) : null;
        }
    }

    public static final class ResultSetQuery
    implements CassandraQueryExecution {
        private final CassandraOperations operations;

        ResultSetQuery(CassandraOperations operations) {
            this.operations = operations;
        }

        @Override
        public @Nullable Object execute(Statement<?> statement, Class<?> type) {
            return this.operations.execute(statement);
        }
    }

    public static final class ExistsExecution
    implements CassandraQueryExecution {
        private final CassandraOperations operations;

        ExistsExecution(CassandraOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(Statement<?> statement, Class<?> type) {
            List<Row> resultSet = this.operations.select(statement, Row.class);
            if (resultSet.isEmpty()) {
                return false;
            }
            Row row = resultSet.get(0);
            if (resultSet.size() == 1 && ProjectionUtil.qualifiesAsCountProjection(row)) {
                Object object = row.getObject(0);
                return object != null && ((Number)object).longValue() > 0L;
            }
            return true;
        }
    }

    public static final class SingleEntityExecution
    implements CassandraQueryExecution {
        private final CassandraOperations operations;
        private final boolean limiting;

        SingleEntityExecution(CassandraOperations operations, boolean limiting) {
            this.operations = operations;
            this.limiting = limiting;
        }

        @Override
        public @Nullable Object execute(Statement<?> statement, Class<?> type) {
            List<?> objects = this.operations.select(statement, type);
            if (objects.isEmpty()) {
                return null;
            }
            if (objects.size() == 1 || this.limiting) {
                return objects.get(0);
            }
            throw new IncorrectResultSizeDataAccessException(1, objects.size());
        }
    }

    public static final class SearchExecution
    implements CassandraQueryExecution {
        private final CassandraOperations operations;
        private final CassandraParameterAccessor accessor;

        public SearchExecution(CassandraOperations operations, CassandraParameterAccessor accessor) {
            this.operations = operations;
            this.accessor = accessor;
        }

        @Override
        public Object execute(Statement<?> statement, Class<?> type) {
            ScoringFunction function = this.accessor.getScoringFunction();
            List<SearchResult> results = this.operations.query(statement).as(type).map((row, reader) -> {
                Object o = reader.get();
                if (row.getColumnDefinitions().contains("__score__")) {
                    return new SearchResult(o, this.getScore(row, "__score__", function));
                }
                if (row.getColumnDefinitions().contains("score")) {
                    return new SearchResult(o, this.getScore(row, "score", function));
                }
                return new SearchResult(o, (Score)Similarity.of((double)0.0));
            }).all();
            return new SearchResults(results);
        }

        private Score getScore(Row row, String columnName, @Nullable ScoringFunction function) {
            Object object = row.getObject(columnName);
            return Similarity.raw((double)((Number)object).doubleValue(), (ScoringFunction)(function == null ? ScoringFunction.unspecified() : function));
        }
    }

    public static final class CollectionExecution
    implements CassandraQueryExecution {
        private final CassandraOperations operations;
        private final CassandraParameterAccessor parameterAccessor;

        CollectionExecution(CassandraOperations operations, CassandraParameterAccessor parameterAccessor) {
            this.operations = operations;
            this.parameterAccessor = parameterAccessor;
        }

        @Override
        public Object execute(Statement<?> statement, Class<?> type) {
            Pageable pageable = this.parameterAccessor.getPageable();
            if (pageable.isPaged()) {
                return new SlicedExecution(this.operations, pageable).execute(statement, type).getContent();
            }
            Limit limit = this.parameterAccessor.getLimit();
            CassandraScrollPosition scrollPosition = this.parameterAccessor.getScrollPosition();
            if (limit.isLimited() || !scrollPosition.isInitial()) {
                return new WindowExecution(this.operations, scrollPosition, limit).execute(statement, type).getContent();
            }
            return this.operations.select(statement, type);
        }
    }

    public static final class WindowExecution
    implements CassandraQueryExecution {
        private final CassandraOperations operations;
        private final CassandraScrollPosition scrollPosition;
        private final Limit limit;

        public WindowExecution(CassandraOperations operations, CassandraScrollPosition scrollPosition, Limit limit) {
            this.operations = operations;
            this.scrollPosition = scrollPosition;
            this.limit = limit;
        }

        public Window<?> execute(Statement<?> statement, Class<?> type) {
            Statement statementToUse;
            Statement statement2 = statementToUse = this.limit.isLimited() ? statement.setPageSize(this.limit.max()) : statement;
            if (!this.scrollPosition.isInitial()) {
                statementToUse = statementToUse.setPagingState(this.scrollPosition.getPagingState());
            }
            return WindowUtil.of(this.operations.slice(statementToUse, type));
        }
    }

    public static final class SlicedExecution
    implements CassandraQueryExecution {
        private final CassandraOperations operations;
        private final Pageable pageable;

        SlicedExecution(CassandraOperations operations, Pageable pageable) {
            this.operations = operations;
            this.pageable = pageable;
        }

        public Slice<?> execute(Statement<?> statement, Class<?> type) {
            CassandraPageRequest.validatePageable(this.pageable);
            Statement statementToUse = statement.setPageSize(this.pageable.getPageSize());
            if (this.pageable instanceof CassandraPageRequest) {
                statementToUse = statementToUse.setPagingState(((CassandraPageRequest)this.pageable).getPagingState());
            }
            Slice<?> slice = this.operations.slice(statementToUse, type);
            if (this.pageable.getSort().isUnsorted()) {
                return slice;
            }
            CassandraPageRequest cassandraPageRequest = (CassandraPageRequest)slice.getPageable();
            return new SliceImpl(slice.getContent(), (Pageable)cassandraPageRequest.withSort(this.pageable.getSort()), slice.hasNext());
        }
    }

    public static final class StreamExecution
    implements CassandraQueryExecution {
        private final CassandraOperations operations;
        private final Converter<Object, Object> resultProcessing;

        StreamExecution(CassandraOperations operations, Converter<Object, Object> resultProcessing) {
            this.operations = operations;
            this.resultProcessing = resultProcessing;
        }

        @Override
        public Object execute(Statement<?> statement, Class<?> type) {
            return this.operations.stream(statement, type).map(arg_0 -> this.resultProcessing.convert(arg_0));
        }
    }
}

