/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.aot;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.aot.AotQuery;
import org.springframework.data.cassandra.repository.aot.AotRepositoryFragmentSupport;
import org.springframework.data.cassandra.repository.aot.CassandraCodeBlocks;
import org.springframework.data.cassandra.repository.aot.CassandraQueryMetadata;
import org.springframework.data.cassandra.repository.aot.QueriesFactory;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.StringUtils;

public class CassandraRepositoryContributor
extends RepositoryContributor {
    private final AotRepositoryContext context;
    private final CassandraMappingContext mappingContext;
    private final CassandraCustomConversions customConversions;
    private final QueriesFactory queryFactory;

    public CassandraRepositoryContributor(AotRepositoryContext context) {
        super(context);
        this.context = context;
        this.mappingContext = new CassandraMappingContext();
        this.customConversions = new CassandraCustomConversions(List.of());
        this.queryFactory = new QueriesFactory(context.getConfigurationSource(), context.getRequiredClassLoader(), ValueExpressionDelegate.create(), this.mappingContext);
    }

    protected void customizeClass(AotRepositoryClassBuilder builder) {
        builder.customize(b -> b.superclass(TypeName.get(AotRepositoryFragmentSupport.class)));
    }

    protected void customizeConstructor(AotRepositoryConstructorBuilder constructorBuilder) {
        constructorBuilder.addParameter("operations", CassandraOperations.class, customizer -> {
            String cassandraTemplateRef = this.getCassandraTemplateRef();
            customizer.bindToField().origin((BeanReference)(StringUtils.hasText((String)cassandraTemplateRef) ? new RuntimeBeanReference(cassandraTemplateRef, CassandraOperations.class) : new RuntimeBeanReference(CassandraOperations.class)));
        });
        constructorBuilder.addParameter("context", RepositoryFactoryBeanSupport.FragmentCreationContext.class, false);
    }

    private @Nullable String getCassandraTemplateRef() {
        return this.context.getConfigurationSource().getAttribute("cassandraTemplateRef").orElse(null);
    }

    protected @Nullable MethodContributor<? extends QueryMethod> contributeQueryMethod(Method method) {
        CassandraQueryMethod queryMethod = new CassandraQueryMethod(method, (RepositoryMetadata)this.getRepositoryInformation(), this.getProjectionFactory(), (MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty>)this.mappingContext);
        ReturnedType returnedType = queryMethod.getResultProcessor().getReturnedType();
        MergedAnnotation query2 = MergedAnnotations.from((AnnotatedElement)method).get(Query.class);
        if (queryMethod.isSearchQuery()) {
            return null;
        }
        AotQuery aotQuery = this.queryFactory.createQuery(this.getRepositoryInformation(), returnedType, (MergedAnnotation<Query>)query2, queryMethod);
        return MethodContributor.forQueryMethod((QueryMethod)queryMethod).withMetadata((QueryMetadata)new CassandraQueryMetadata(aotQuery)).contribute(context -> {
            CodeBlock.Builder body = CodeBlock.builder();
            String queryVariableName = context.localVariable("query");
            body.add(CassandraCodeBlocks.queryBuilder(context, queryMethod).usingQueryVariableName(queryVariableName).query(aotQuery).query((MergedAnnotation<Query>)query2).build());
            body.add(CassandraCodeBlocks.executionBuilder(context, this.customConversions, queryMethod).usingQueryVariableName(queryVariableName).query(aotQuery).build());
            return body.build();
        });
    }
}

