/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.keyspace.CqlStringUtils;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceActionSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOption;
import org.springframework.util.ObjectUtils;

public abstract class KeyspaceOptionsSpecification<T extends KeyspaceOptionsSpecification<T>>
extends KeyspaceActionSpecification {
    protected Map<String, @Nullable Object> options = new LinkedHashMap<String, Object>();

    protected KeyspaceOptionsSpecification(CqlIdentifier name) {
        super(name);
    }

    public T with(KeyspaceOption option) {
        return this.with(option.getName(), null, option.escapesValue(), option.quotesValue());
    }

    public T with(KeyspaceOption option, Object value) {
        option.checkValue(value);
        return this.with(option.getName(), value, option.escapesValue(), option.quotesValue());
    }

    public T with(String name, @Nullable Object value, boolean escape, boolean quote) {
        if (!(value instanceof Map)) {
            if (escape) {
                value = CqlStringUtils.escapeSingle(value);
            }
            if (quote) {
                value = CqlStringUtils.singleQuote(value);
            }
        }
        this.options.put(name, value);
        return (T)this;
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyspaceOptionsSpecification)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyspaceOptionsSpecification that = (KeyspaceOptionsSpecification)o;
        return ObjectUtils.nullSafeEquals(this.options, that.options);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.options);
        return result;
    }
}

