/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.data.cassandra.core.cql.IncorrectResultSetColumnCountException;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.RowUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;

public class SingleColumnRowMapper<T>
implements RowMapper<T> {
    private @Nullable Class<?> requiredType;

    public SingleColumnRowMapper() {
    }

    public SingleColumnRowMapper(Class<T> requiredType) {
        this.setRequiredType(requiredType);
    }

    public void setRequiredType(Class<T> requiredType) {
        this.requiredType = ClassUtils.resolvePrimitiveIfNecessary(requiredType);
    }

    @Override
    public T mapRow(Row row, int rowNum) throws DriverException {
        ColumnDefinitions definitions = row.getColumnDefinitions();
        int nrOfColumns = definitions.size();
        if (nrOfColumns != 1) {
            throw new IncorrectResultSetColumnCountException(1, nrOfColumns);
        }
        Object result = this.getColumnValue(row, 0, this.requiredType);
        if (result != null && this.requiredType != null && !this.requiredType.isInstance(result)) {
            try {
                return (T)this.convertValueToRequiredType(result, this.requiredType);
            }
            catch (IllegalArgumentException ex) {
                ColumnDefinition columnDefinition = definitions.get(0);
                throw new TypeMismatchDataAccessException(String.format("Type mismatch affecting row number %d and column type '%s': %s", rowNum, columnDefinition.getType(), ex.getMessage()));
            }
        }
        return (T)result;
    }

    protected @Nullable Object getColumnValue(Row row, int index, @Nullable Class<?> requiredType) throws DriverException {
        if (requiredType != null) {
            return RowUtils.getRowValue(row, index, requiredType);
        }
        return this.getColumnValue(row, index);
    }

    protected @Nullable Object getColumnValue(Row row, int index) {
        return RowUtils.getRowValue(row, index, null);
    }

    protected Object convertValueToRequiredType(Object value, Class<?> requiredType) {
        if (String.class == requiredType) {
            return value.toString();
        }
        if (Number.class.isAssignableFrom(requiredType)) {
            if (value instanceof Number) {
                return NumberUtils.convertNumberToTargetClass((Number)((Number)value), requiredType);
            }
            return NumberUtils.parseNumber((String)value.toString(), requiredType);
        }
        throw new IllegalArgumentException(String.format("Value [%s] is of type [%s] and cannot be converted to required type [%s]", value, value.getClass().getName(), requiredType.getName()));
    }

    public static <T> SingleColumnRowMapper<T> newInstance(Class<T> requiredType) {
        return new SingleColumnRowMapper<T>(requiredType);
    }
}

