/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.Row;
import java.lang.reflect.Constructor;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.cassandra.core.cql.BeanPropertyRowMapper;
import org.springframework.util.Assert;

public class DataClassRowMapper<T>
extends BeanPropertyRowMapper<T> {
    private @Nullable Constructor<T> mappedConstructor;
    private String @Nullable [] constructorParameterNames;
    private TypeDescriptor @Nullable [] constructorParameterTypes;

    public DataClassRowMapper(Class<T> mappedClass) {
        super(mappedClass);
    }

    @Override
    protected void initialize(Class<T> mappedClass) {
        super.initialize(mappedClass);
        this.mappedConstructor = BeanUtils.getResolvableConstructor(mappedClass);
        int paramCount = this.mappedConstructor.getParameterCount();
        if (paramCount > 0) {
            this.constructorParameterNames = BeanUtils.getParameterNames(this.mappedConstructor);
            this.constructorParameterTypes = new TypeDescriptor[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                this.constructorParameterTypes[i] = new TypeDescriptor(new MethodParameter(this.mappedConstructor, i));
            }
        }
    }

    @Override
    protected T constructMappedInstance(Row row, TypeConverter tc) {
        Object[] args;
        Assert.state((this.mappedConstructor != null ? 1 : 0) != 0, (String)"Mapped constructor was not initialized");
        if (this.constructorParameterNames != null && this.constructorParameterTypes != null) {
            args = new Object[this.constructorParameterNames.length];
            for (int i = 0; i < args.length; ++i) {
                String name = this.underscoreName(this.constructorParameterNames[i]);
                TypeDescriptor td = this.constructorParameterTypes[i];
                Object value = this.getColumnValue(row, row.getColumnDefinitions().firstIndexOf(name), td.getType());
                args[i] = tc.convertIfNecessary(value, td.getType(), td);
            }
        } else {
            args = new Object[]{};
        }
        return (T)BeanUtils.instantiateClass(this.mappedConstructor, (Object[])args);
    }

    public static <T> DataClassRowMapper<T> newInstance(Class<T> mappedClass) {
        return new DataClassRowMapper<T>(mappedClass);
    }

    public static <T> DataClassRowMapper<T> newInstance(Class<T> mappedClass, @Nullable ConversionService conversionService) {
        DataClassRowMapper<T> rowMapper = DataClassRowMapper.newInstance(mappedClass);
        rowMapper.setConversionService(conversionService);
        return rowMapper;
    }
}

