/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.cql.Row;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;

public class CassandraConversionContext
implements ValueConversionContext<CassandraPersistentProperty> {
    private final PropertyValueProvider<CassandraPersistentProperty> accessor;
    private final CassandraPersistentProperty persistentProperty;
    private final CassandraConverter cassandraConverter;
    private final @Nullable SpELContext spELContext;

    public CassandraConversionContext(PropertyValueProvider<CassandraPersistentProperty> accessor, CassandraPersistentProperty persistentProperty, CassandraConverter CassandraConverter2) {
        this(accessor, persistentProperty, CassandraConverter2, null);
    }

    public CassandraConversionContext(PropertyValueProvider<CassandraPersistentProperty> accessor, CassandraPersistentProperty persistentProperty, CassandraConverter CassandraConverter2, @Nullable SpELContext spELContext) {
        this.accessor = accessor;
        this.persistentProperty = persistentProperty;
        this.cassandraConverter = CassandraConverter2;
        this.spELContext = spELContext;
    }

    public CassandraPersistentProperty getProperty() {
        return this.persistentProperty;
    }

    public @Nullable Object getValue(String propertyPath) {
        return this.accessor.getPropertyValue((PersistentProperty)((CassandraPersistentProperty)this.persistentProperty.getOwner().getRequiredPersistentProperty(propertyPath)));
    }

    public <T> @Nullable T write(@Nullable Object value, TypeInformation<T> target) {
        if (value == null) {
            return null;
        }
        return (T)this.cassandraConverter.convertToColumnType(value, target);
    }

    public <T> @Nullable T read(@Nullable Object value, TypeInformation<T> target) {
        Object object;
        if (value instanceof Row) {
            Row row = (Row)value;
            object = this.cassandraConverter.read(target.getType(), row);
        } else {
            object = super.read(value, target);
        }
        return (T)object;
    }

    public @Nullable SpELContext getSpELContext() {
        return this.spELContext;
    }
}

