/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.keyspace.DefaultOption;
import org.springframework.data.cassandra.core.cql.keyspace.Option;

public enum TableOption implements Option
{
    COMMENT("comment", String.class, true),
    COMPACT_STORAGE("COMPACT STORAGE"),
    COMPACTION("compaction", Map.class),
    COMPRESSION("compression", Map.class),
    CACHING("caching", Map.class),
    BLOOM_FILTER_FP_CHANCE("bloom_filter_fp_chance", Double.class),
    READ_REPAIR_CHANCE("read_repair_chance", Double.class),
    DCLOCAL_READ_REPAIR_CHANCE("dclocal_read_repair_chance", Double.class),
    GC_GRACE_SECONDS("gc_grace_seconds", Long.class),
    DEFAULT_TIME_TO_LIVE("default_time_to_live", Long.class),
    CDC("cdc", Boolean.class),
    SPECULATIVE_RETRY("speculative_retry", String.class, true),
    MEMTABLE_FLUSH_PERIOD_IN_MS("memtable_flush_period_in_ms", Long.class),
    CRC_CHECK_CHANCE("crc_check_chance", Double.class),
    MIN_INDEX_INTERVAL("min_index_interval", Long.class),
    MAX_INDEX_INTERVAL("max_index_interval", Long.class),
    READ_REPAIR("read_repair", String.class, true);

    private final Option delegate;

    private TableOption(String name) {
        this(name, Void.class, false, false, false);
    }

    private TableOption(String name, Class<?> type) {
        this(name, type, true, false, false);
    }

    private TableOption(String name, Class<?> type, boolean escapeAndQuote) {
        this(name, type, true, escapeAndQuote, escapeAndQuote);
    }

    private TableOption(String name, Class<?> type, boolean requiresValue, boolean escapesValue, boolean quotesValue) {
        this.delegate = new DefaultOption(name, type, requiresValue, escapesValue, quotesValue);
    }

    public static TableOption valueOfIgnoreCase(String optionName) {
        TableOption tableOption = TableOption.findByName(optionName);
        if (tableOption != null) {
            return tableOption;
        }
        throw new IllegalArgumentException(String.format("Unable to recognize specified Table option '%s'", optionName));
    }

    public static @Nullable TableOption findByName(String optionName) {
        for (TableOption value : TableOption.values()) {
            if (!value.getName().equalsIgnoreCase(optionName)) continue;
            return value;
        }
        return null;
    }

    @Override
    public Class<?> getType() {
        return this.delegate.getType();
    }

    @Override
    public boolean takesValue() {
        return this.delegate.takesValue();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean escapesValue() {
        return this.delegate.escapesValue();
    }

    @Override
    public boolean quotesValue() {
        return this.delegate.quotesValue();
    }

    @Override
    public boolean requiresValue() {
        return this.delegate.requiresValue();
    }

    @Override
    public void checkValue(Object value) {
        this.delegate.checkValue(value);
    }

    @Override
    public boolean isCoerceable(Object value) {
        return this.delegate.isCoerceable(value);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String toString(@Nullable Object value) {
        return this.delegate.toString(value);
    }

    public static enum CompressionOption implements Option
    {
        SSTABLE_COMPRESSION("sstable_compression", String.class, true, false, true),
        CHUNK_LENGTH_KB("chunk_length_kb", Long.class, true, false, false),
        CRC_CHECK_CHANCE("crc_check_chance", Double.class, true, false, false);

        private final Option delegate;

        private CompressionOption(String name, Class<?> type, boolean requiresValue, boolean escapesValue, boolean quotesValue) {
            this.delegate = new DefaultOption(name, type, requiresValue, escapesValue, quotesValue);
        }

        @Override
        public Class<?> getType() {
            return this.delegate.getType();
        }

        @Override
        public boolean takesValue() {
            return this.delegate.takesValue();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean escapesValue() {
            return this.delegate.escapesValue();
        }

        @Override
        public boolean quotesValue() {
            return this.delegate.quotesValue();
        }

        @Override
        public boolean requiresValue() {
            return this.delegate.requiresValue();
        }

        @Override
        public void checkValue(Object value) {
            this.delegate.checkValue(value);
        }

        @Override
        public boolean isCoerceable(Object value) {
            return this.delegate.isCoerceable(value);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String toString(@Nullable Object value) {
            return this.delegate.toString(value);
        }
    }

    public static enum CompactionOption implements Option
    {
        CLASS("class", String.class, true, false, true),
        TOMBSTONE_THRESHOLD("tombstone_threshold", Double.class),
        TOMBSTONE_COMPACTION_INTERVAL("tombstone_compaction_interval", Double.class),
        MIN_SSTABLE_SIZE("min_sstable_size", Long.class),
        MIN_THRESHOLD("min_threshold", Long.class),
        MAX_THRESHOLD("max_threshold", Long.class),
        BUCKET_LOW("bucket_low", Double.class),
        BUCKET_HIGH("bucket_high", Double.class),
        SSTABLE_SIZE_IN_MB("sstable_size_in_mb", Long.class);

        private final Option delegate;

        private CompactionOption(String name, Class<?> type) {
            this(name, type, true, false, false);
        }

        private CompactionOption(String name, Class<?> type, boolean requiresValue, boolean escapesValue, boolean quotesValue) {
            this.delegate = new DefaultOption(name, type, requiresValue, escapesValue, quotesValue);
        }

        @Override
        public Class<?> getType() {
            return this.delegate.getType();
        }

        @Override
        public boolean takesValue() {
            return this.delegate.takesValue();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean escapesValue() {
            return this.delegate.escapesValue();
        }

        @Override
        public boolean quotesValue() {
            return this.delegate.quotesValue();
        }

        @Override
        public boolean requiresValue() {
            return this.delegate.requiresValue();
        }

        @Override
        public void checkValue(Object value) {
            this.delegate.checkValue(value);
        }

        @Override
        public boolean isCoerceable(Object value) {
            return this.delegate.isCoerceable(value);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String toString(@Nullable Object value) {
            return this.delegate.toString(value);
        }
    }

    public static enum CachingOption implements Option
    {
        KEYS("keys", KeyCachingOption.class, true, false, true),
        ROWS_PER_PARTITION("rows_per_partition", String.class, true, false, true);

        private final Option delegate;

        private CachingOption(String name, Class<?> type, boolean requiresValue, boolean escapesValue, boolean quotesValue) {
            this.delegate = new DefaultOption(name, type, requiresValue, escapesValue, quotesValue);
        }

        @Override
        public Class<?> getType() {
            return this.delegate.getType();
        }

        @Override
        public boolean takesValue() {
            return this.delegate.takesValue();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean escapesValue() {
            return this.delegate.escapesValue();
        }

        @Override
        public boolean quotesValue() {
            return this.delegate.quotesValue();
        }

        @Override
        public boolean requiresValue() {
            return this.delegate.requiresValue();
        }

        @Override
        public void checkValue(Object value) {
            this.delegate.checkValue(value);
        }

        @Override
        public boolean isCoerceable(Object value) {
            return this.delegate.isCoerceable(value);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String toString(@Nullable Object value) {
            return this.delegate.toString(value);
        }
    }

    public static enum KeyCachingOption {
        ALL("all"),
        NONE("none");

        private final String value;

        private KeyCachingOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

