/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.cassandra.core.query.CassandraScrollPosition;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ProjectionUtil;
import org.springframework.data.cassandra.repository.query.WindowUtil;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.SearchResult;
import org.springframework.data.domain.Similarity;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@FunctionalInterface
interface ReactiveCassandraQueryExecution {
    public Publisher<? extends Object> execute(Statement<?> var1, Class<?> var2);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        private final ResultProcessor processor;
        private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
        private final EntityInstantiators instantiators;

        ResultProcessingConverter(ResultProcessor processor, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, EntityInstantiators instantiators) {
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
        }

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ReflectionUtils.isVoid((Class)returnedType.getReturnedType())) {
                if (source instanceof Mono) {
                    return ((Mono)source).then();
                }
                if (source instanceof Publisher) {
                    return Flux.from((Publisher)((Publisher)source)).then();
                }
            }
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            if (returnedType.isInstance(source)) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }
    }

    public static final class ResultProcessingExecution
    implements ReactiveCassandraQueryExecution {
        private final ReactiveCassandraQueryExecution delegate;
        private final Converter<Object, Object> converter;

        ResultProcessingExecution(ReactiveCassandraQueryExecution delegate, Converter<Object, Object> converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public Publisher<? extends Object> execute(Statement<?> statement, Class<?> type) {
            return (Publisher)this.converter.convert(this.delegate.execute(statement, type));
        }
    }

    public static final class ExistsExecution
    implements ReactiveCassandraQueryExecution {
        private final ReactiveCassandraOperations operations;

        ExistsExecution(ReactiveCassandraOperations operations) {
            this.operations = operations;
        }

        @Override
        public Publisher<? extends Object> execute(Statement<?> statement, Class<?> type) {
            Mono rows = this.operations.select(statement, Row.class).buffer(2).next();
            return rows.map(it -> {
                Row row;
                if (it.isEmpty()) {
                    return false;
                }
                if (it.size() == 1 && ProjectionUtil.qualifiesAsCountProjection(row = (Row)it.get(0))) {
                    Object object = row.getObject(0);
                    return ((Number)object).longValue() > 0L;
                }
                return true;
            }).switchIfEmpty(Mono.just((Object)false));
        }
    }

    public static final class SingleEntityExecution
    implements ReactiveCassandraQueryExecution {
        private final ReactiveCassandraOperations operations;
        private final boolean limiting;

        SingleEntityExecution(ReactiveCassandraOperations operations, boolean limiting) {
            this.operations = operations;
            this.limiting = limiting;
        }

        @Override
        public Publisher<? extends Object> execute(Statement<?> statement, Class<?> type) {
            return this.operations.select(statement, type).buffer(2).handle((objects, sink) -> {
                if (objects.isEmpty()) {
                    return;
                }
                if (objects.size() == 1 || this.limiting) {
                    sink.next(objects.get(0));
                    return;
                }
                sink.error((Throwable)new IncorrectResultSizeDataAccessException(1, objects.size()));
            });
        }
    }

    public static final class SearchExecution
    implements ReactiveCassandraQueryExecution {
        private final ReactiveCassandraOperations operations;
        private final CassandraParameterAccessor accessor;

        public SearchExecution(ReactiveCassandraOperations operations, CassandraParameterAccessor accessor) {
            this.operations = operations;
            this.accessor = accessor;
        }

        @Override
        public Publisher<? extends Object> execute(Statement<?> statement, Class<?> type) {
            ScoringFunction function = this.accessor.getScoringFunction();
            return this.operations.query(statement).as(type).map((row, reader) -> {
                Object entity = reader.get();
                if (row.getColumnDefinitions().contains("__score__")) {
                    return new SearchResult(entity, this.getScore(row, "__score__", function));
                }
                if (row.getColumnDefinitions().contains("score")) {
                    return new SearchResult(entity, this.getScore(row, "score", function));
                }
                return new SearchResult(entity, 0.0);
            }).all();
        }

        private Score getScore(Row row, String columnName, @Nullable ScoringFunction function) {
            Object object = row.getObject(columnName);
            return Similarity.raw((double)((Number)object).doubleValue(), (ScoringFunction)(function == null ? ScoringFunction.unspecified() : function));
        }
    }

    public static final class CollectionExecution
    implements ReactiveCassandraQueryExecution {
        private final ReactiveCassandraOperations operations;

        CollectionExecution(ReactiveCassandraOperations operations) {
            this.operations = operations;
        }

        @Override
        public Publisher<? extends Object> execute(Statement<?> statement, Class<?> type) {
            return this.operations.select(statement, type);
        }
    }

    public static final class WindowExecution
    implements ReactiveCassandraQueryExecution {
        private final ReactiveCassandraOperations operations;
        private final CassandraScrollPosition scrollPosition;
        private final Limit limit;

        public WindowExecution(ReactiveCassandraOperations operations, CassandraScrollPosition scrollPosition, Limit limit) {
            this.operations = operations;
            this.scrollPosition = scrollPosition;
            this.limit = limit;
        }

        @Override
        public Publisher<? extends Object> execute(Statement<?> statement, Class<?> type) {
            Statement statementToUse;
            Statement statement2 = statementToUse = this.limit.isLimited() ? statement.setPageSize(this.limit.max()) : statement;
            if (!this.scrollPosition.isInitial()) {
                statementToUse = statementToUse.setPagingState(this.scrollPosition.getPagingState());
            }
            Mono<Slice<?>> slice = this.operations.slice(statementToUse, type);
            return slice.map(WindowUtil::of);
        }
    }

    public static final class SlicedExecution
    implements ReactiveCassandraQueryExecution {
        private final ReactiveCassandraOperations operations;
        private final Pageable pageable;

        SlicedExecution(ReactiveCassandraOperations operations, Pageable pageable) {
            this.operations = operations;
            this.pageable = pageable;
        }

        @Override
        public Publisher<? extends Object> execute(Statement<?> statement, Class<?> type) {
            CassandraPageRequest.validatePageable(this.pageable);
            Statement statementToUse = statement.setPageSize(this.pageable.getPageSize());
            if (this.pageable instanceof CassandraPageRequest) {
                statementToUse = statementToUse.setPagingState(((CassandraPageRequest)this.pageable).getPagingState());
            }
            Mono<Slice<?>> slice = this.operations.slice(statementToUse, type);
            if (this.pageable.getSort().isUnsorted()) {
                return slice;
            }
            return slice.map(it -> {
                CassandraPageRequest cassandraPageRequest = (CassandraPageRequest)it.getPageable();
                return new SliceImpl(it.getContent(), (Pageable)cassandraPageRequest.withSort(this.pageable.getSort()), it.hasNext());
            });
        }
    }
}

