/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import com.datastax.oss.driver.api.core.cql.PagingState;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.cassandra.core.query.CassandraScrollPosition;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.data.cassandra.core.query.SerializationUtils;
import org.springframework.data.cassandra.core.query.VectorSort;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Query
implements Filter {
    private static final Query EMPTY = new Query(Collections.emptyList(), Columns.empty(), Sort.unsorted(), CassandraScrollPosition.initial(), Optional.empty(), Limit.unlimited(), false);
    private final boolean allowFiltering;
    private final Columns columns;
    private final List<CriteriaDefinition> criteriaDefinitions;
    private final Limit limit;
    private final CassandraScrollPosition scrollPosition;
    private final Optional<QueryOptions> queryOptions;
    private final Sort sort;

    private Query(List<CriteriaDefinition> criteriaDefinitions, Columns columns, Sort sort, CassandraScrollPosition pagingState, Optional<QueryOptions> queryOptions, Limit limit, boolean allowFiltering) {
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        this.criteriaDefinitions = criteriaDefinitions;
        this.columns = columns;
        this.sort = sort;
        this.scrollPosition = pagingState;
        this.queryOptions = queryOptions;
        this.limit = limit;
        this.allowFiltering = allowFiltering;
    }

    public static Query empty() {
        return EMPTY;
    }

    public static Query select(Columns columns) {
        return EMPTY.columns(columns);
    }

    public static Query query(CriteriaDefinition ... criteriaDefinitions) {
        Assert.notNull((Object)criteriaDefinitions, (String)"CriteriaDefinitions must not be null");
        return Query.query(Arrays.asList(criteriaDefinitions));
    }

    public static Query query(Iterable<? extends CriteriaDefinition> criteriaDefinitions) {
        Assert.notNull(criteriaDefinitions, (String)"CriteriaDefinitions must not be null");
        List<CriteriaDefinition> collect = StreamSupport.stream(criteriaDefinitions.spliterator(), false).collect(Collectors.toList());
        return new Query(collect, Columns.empty(), Sort.unsorted(), CassandraScrollPosition.initial(), Optional.empty(), Limit.unlimited(), false);
    }

    public Query and(CriteriaDefinition criteriaDefinition) {
        Assert.notNull((Object)criteriaDefinition, (String)"Criteria must not be null");
        ArrayList<CriteriaDefinition> criteriaDefinitions = new ArrayList<CriteriaDefinition>(this.criteriaDefinitions.size() + 1);
        criteriaDefinitions.addAll(this.criteriaDefinitions);
        if (!criteriaDefinitions.contains(criteriaDefinition)) {
            criteriaDefinitions.add(criteriaDefinition);
        }
        return new Query(criteriaDefinitions, this.columns, this.sort, this.scrollPosition, this.queryOptions, this.limit, this.allowFiltering);
    }

    @Override
    public Iterable<CriteriaDefinition> getCriteriaDefinitions() {
        return Collections.unmodifiableCollection(this.criteriaDefinitions);
    }

    public Query columns(Columns columns) {
        Assert.notNull((Object)columns, (String)"Columns must not be null");
        return new Query(this.criteriaDefinitions, this.columns.and(columns), this.sort, this.scrollPosition, this.queryOptions, this.limit, this.allowFiltering);
    }

    public Columns getColumns() {
        return this.columns;
    }

    public Query sort(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        for (Sort.Order order : sort) {
            if (!order.isIgnoreCase()) continue;
            throw new IllegalArgumentException(String.format("Given sort contained an Order for %s with ignore case; Apache Cassandra does not support sorting ignoring case currently", order.getProperty()));
        }
        Sort sortToUse = this.sort;
        if (this.sort.isUnsorted()) {
            sortToUse = sort;
        } else {
            if (sortToUse instanceof VectorSort || sort instanceof VectorSort) {
                throw new InvalidDataAccessApiUsageException("Cannot concatenate multiple VectorSort instances");
            }
            sortToUse = this.sort.and(sort);
        }
        return new Query(this.criteriaDefinitions, this.columns, sortToUse, this.scrollPosition, this.queryOptions, this.limit, this.allowFiltering);
    }

    public Sort getSort() {
        return this.sort;
    }

    public Query pageRequest(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        CassandraPageRequest.validatePageable(pageable);
        if (pageable.isUnpaged()) {
            return this;
        }
        CassandraScrollPosition scrollPosition = this.getScrollPosition();
        if (pageable instanceof CassandraPageRequest) {
            CassandraPageRequest cpr = (CassandraPageRequest)pageable;
            scrollPosition = cpr.getScrollPosition();
        }
        QueryOptions queryOptions = this.queryOptions.map(QueryOptions::mutate).orElse(QueryOptions.builder()).pageSize(pageable.getPageSize()).build();
        return new Query(this.criteriaDefinitions, this.columns, this.sort.and(pageable.getSort()), scrollPosition, Optional.of(queryOptions), this.limit, this.allowFiltering);
    }

    public Query pagingState(CassandraScrollPosition scrollPosition) {
        Assert.notNull((Object)scrollPosition, (String)"CassandraScrollPosition must not be null");
        return new Query(this.criteriaDefinitions, this.columns, this.sort, scrollPosition, this.queryOptions, this.limit, this.allowFiltering);
    }

    public Query pagingState(PagingState pagingState) {
        return this.pagingState(CassandraScrollPosition.of(pagingState));
    }

    public Query pagingState(ByteBuffer pagingState) {
        Assert.notNull((Object)pagingState, (String)"PagingState must not be null");
        return new Query(this.criteriaDefinitions, this.columns, this.sort, CassandraScrollPosition.of(pagingState), this.queryOptions, this.limit, this.allowFiltering);
    }

    public Optional<ByteBuffer> getPagingState() {
        if (this.scrollPosition.isInitial()) {
            return Optional.empty();
        }
        return Optional.of(this.scrollPosition.getPagingState());
    }

    public Query queryOptions(QueryOptions queryOptions) {
        Assert.notNull((Object)queryOptions, (String)"QueryOptions must not be null");
        return new Query(this.criteriaDefinitions, this.columns, this.sort, this.scrollPosition, Optional.of(queryOptions), this.limit, this.allowFiltering);
    }

    public Optional<QueryOptions> getQueryOptions() {
        return this.queryOptions;
    }

    public Query limit(long limit) {
        return new Query(this.criteriaDefinitions, this.columns, this.sort, this.scrollPosition, this.queryOptions, Limit.of((int)Math.toIntExact(limit)), this.allowFiltering);
    }

    public Query limit(Limit limit) {
        return new Query(this.criteriaDefinitions, this.columns, this.sort, this.scrollPosition, this.queryOptions, limit, this.allowFiltering);
    }

    public long getLimit() {
        return this.limit.isLimited() ? (long)this.limit.max() : 0L;
    }

    public boolean isLimited() {
        return this.limit.isLimited();
    }

    public Query withAllowFiltering() {
        return new Query(this.criteriaDefinitions, this.columns, this.sort, this.scrollPosition, this.queryOptions, this.limit, true);
    }

    public boolean isAllowFiltering() {
        return this.allowFiltering;
    }

    private CassandraScrollPosition getScrollPosition() {
        return this.scrollPosition;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.querySettingsEquals((Query)obj);
    }

    protected boolean querySettingsEquals(Query that) {
        boolean criteriaEqual = this.criteriaDefinitions.equals(that.criteriaDefinitions);
        boolean columnsEqual = ObjectUtils.nullSafeEquals((Object)this.columns, (Object)that.columns);
        boolean sortEqual = ObjectUtils.nullSafeEquals((Object)this.sort, (Object)that.sort);
        boolean pagingStateEqual = ObjectUtils.nullSafeEquals((Object)this.scrollPosition, (Object)that.scrollPosition);
        boolean queryOptionsEqual = ObjectUtils.nullSafeEquals(this.queryOptions, that.queryOptions);
        boolean limitEqual = this.limit == that.limit;
        boolean allowFilteringEqual = this.allowFiltering == that.allowFiltering;
        return criteriaEqual && columnsEqual && sortEqual && pagingStateEqual && queryOptionsEqual && limitEqual && allowFilteringEqual;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.criteriaDefinitions.hashCode();
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.columns);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.sort);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.scrollPosition);
        result += 31 * ObjectUtils.nullSafeHashCode(this.queryOptions);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.limit);
        return result += this.allowFiltering ? 0 : 1;
    }

    public String toString() {
        String query2 = StreamSupport.stream(this.spliterator(), false).map(SerializationUtils::serializeToCqlSafely).collect(Collectors.joining(" AND "));
        return String.format("Query: %s, Columns: %s, Sort: %s, Limit: %d", query2, this.getColumns(), this.getSort(), this.getLimit());
    }
}

