/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.PartTreeCassandraQuery;
import org.springframework.data.cassandra.repository.query.StringBasedCassandraQuery;
import org.springframework.data.cassandra.repository.support.CassandraRepositoryFragmentsContributor;
import org.springframework.data.cassandra.repository.support.MappingCassandraEntityInformation;
import org.springframework.data.cassandra.repository.support.SimpleCassandraRepository;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.CachingValueExpressionDelegate;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

public class CassandraRepositoryFactory
extends RepositoryFactorySupport {
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final CassandraOperations operations;
    private CassandraRepositoryFragmentsContributor fragmentsContributor = CassandraRepositoryFragmentsContributor.DEFAULT;

    public CassandraRepositoryFactory(CassandraOperations operations) {
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        this.operations = operations;
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    public void setFragmentsContributor(CassandraRepositoryFragmentsContributor fragmentsContributor) {
        this.fragmentsContributor = fragmentsContributor;
    }

    protected ProjectionFactory getProjectionFactory(@Nullable ClassLoader classLoader, @Nullable BeanFactory beanFactory) {
        return this.operations.getConverter().getProjectionFactory();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleCassandraRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation((RepositoryMetadata)information);
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
    }

    public CassandraEntityInformation<?, ?> getEntityInformation(RepositoryMetadata metadata) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(metadata.getDomainType());
        return new MappingCassandraEntityInformation(entity, this.operations.getConverter());
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new CassandraQueryLookupStrategy(this.operations, (ValueExpressionDelegate)new CachingValueExpressionDelegate(valueExpressionDelegate), this.mappingContext));
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return this.getRepositoryFragments(metadata, this.operations);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata, CassandraOperations operations) {
        return this.fragmentsContributor.contribute(metadata, (CassandraEntityInformation<?, ?>)this.getEntityInformation(metadata), operations);
    }

    private record CassandraQueryLookupStrategy(CassandraOperations operations, ValueExpressionDelegate valueExpressionDelegate, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext) implements QueryLookupStrategy
    {
        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            CassandraQueryMethod queryMethod = new CassandraQueryMethod(method, metadata, factory, this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedCassandraQuery(namedQuery, queryMethod, this.operations, this.valueExpressionDelegate);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedCassandraQuery(queryMethod, this.operations, this.valueExpressionDelegate);
            }
            return new PartTreeCassandraQuery(queryMethod, this.operations);
        }
    }
}

