/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.cassandra.core.cql.keyspace.AlterKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DataCenterReplication;
import org.springframework.data.cassandra.core.cql.keyspace.DefaultOption;
import org.springframework.data.cassandra.core.cql.keyspace.DropKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceActionSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOption;
import org.springframework.data.cassandra.core.cql.keyspace.Option;

class KeyspaceActionSpecificationFactory {
    private final CqlIdentifier name;
    private final List<DataCenterReplication> replications;
    private final KeyspaceOption.ReplicationStrategy replicationStrategy;
    private final long replicationFactor;
    private final boolean durableWrites;

    KeyspaceActionSpecificationFactory(CqlIdentifier name, List<DataCenterReplication> replications, KeyspaceOption.ReplicationStrategy replicationStrategy, long replicationFactor, boolean durableWrites) {
        this.name = name;
        this.replications = replications;
        this.replicationStrategy = replicationStrategy;
        this.replicationFactor = replicationFactor;
        this.durableWrites = durableWrites;
    }

    public static KeyspaceActionSpecificationFactoryBuilder builder(String keyspaceName) {
        return KeyspaceActionSpecificationFactory.builder(CqlIdentifier.fromCql((String)keyspaceName));
    }

    public static KeyspaceActionSpecificationFactoryBuilder builder(CqlIdentifier keyspaceName) {
        return new KeyspaceActionSpecificationFactoryBuilder(keyspaceName);
    }

    public CreateKeyspaceSpecification create(boolean ifNotExists) {
        CreateKeyspaceSpecification create = CreateKeyspaceSpecification.createKeyspace(this.name).ifNotExists(ifNotExists).with(KeyspaceOption.DURABLE_WRITES, this.durableWrites);
        Map<Option, Object> replication = this.getReplication();
        if (!replication.isEmpty()) {
            create.with(KeyspaceOption.REPLICATION, replication);
        }
        return create;
    }

    public KeyspaceActionSpecification alter() {
        AlterKeyspaceSpecification alter = (AlterKeyspaceSpecification)AlterKeyspaceSpecification.alterKeyspace(this.name).with(KeyspaceOption.DURABLE_WRITES, this.durableWrites);
        Map<Option, Object> replication = this.getReplication();
        if (!replication.isEmpty()) {
            alter.with(KeyspaceOption.REPLICATION, replication);
        }
        return alter;
    }

    protected Map<Option, Object> getReplication() {
        HashMap<Option, Object> replicationStrategyMap = new HashMap<Option, Object>();
        if (this.hasReplicationOptions()) {
            replicationStrategyMap.put(new DefaultOption("class", String.class, true, false, true), this.replicationStrategy.getValue());
            if (this.replicationStrategy == KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY) {
                replicationStrategyMap.put(new DefaultOption("replication_factor", Long.class, true, false, false), this.replicationFactor);
            }
            if (this.replicationStrategy == KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY) {
                for (DataCenterReplication datacenter : this.replications) {
                    replicationStrategyMap.put(new DefaultOption(datacenter.getDataCenter(), Long.class, true, false, false), datacenter.getReplicationFactor());
                }
            }
        }
        return replicationStrategyMap;
    }

    private boolean hasReplicationOptions() {
        if (this.replicationStrategy == KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY && this.replicationFactor > 0L) {
            return true;
        }
        return this.replicationStrategy == KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY && !this.replications.isEmpty();
    }

    public DropKeyspaceSpecification drop(boolean ifExists) {
        return DropKeyspaceSpecification.dropKeyspace(this.name).ifExists(ifExists);
    }

    static class KeyspaceActionSpecificationFactoryBuilder {
        private final CqlIdentifier name;
        private final List<DataCenterReplication> replications = new ArrayList<DataCenterReplication>();
        private KeyspaceOption.ReplicationStrategy replicationStrategy = KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY;
        private long replicationFactor;
        private boolean durableWrites = false;

        private KeyspaceActionSpecificationFactoryBuilder(CqlIdentifier name) {
            this.name = name;
        }

        KeyspaceActionSpecificationFactoryBuilder simpleReplication(int replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this.replicationStrategy(KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY);
        }

        KeyspaceActionSpecificationFactoryBuilder withDataCenter(DataCenterReplication replication) {
            this.replicationStrategy(KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY);
            this.replications.add(replication);
            return this;
        }

        private KeyspaceActionSpecificationFactoryBuilder replicationStrategy(KeyspaceOption.ReplicationStrategy strategy) {
            this.replicationStrategy = strategy;
            return this;
        }

        KeyspaceActionSpecificationFactoryBuilder durableWrites(boolean durableWrites) {
            this.durableWrites = durableWrites;
            return this;
        }

        public KeyspaceActionSpecificationFactory build() {
            return new KeyspaceActionSpecificationFactory(this.name, new ArrayList<DataCenterReplication>(this.replications), this.replicationStrategy, this.replicationFactor, this.durableWrites);
        }
    }
}

