/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParametersParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryExecution;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.CassandraRepositoryQuerySupport;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;

public abstract class AbstractCassandraQuery
extends CassandraRepositoryQuerySupport {
    private final CassandraOperations operations;

    public AbstractCassandraQuery(CassandraQueryMethod queryMethod, CassandraOperations operations) {
        super(queryMethod, (MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)operations.getConverter().getMappingContext());
        this.operations = operations;
    }

    protected CassandraOperations getOperations() {
        return this.operations;
    }

    public @Nullable Object execute(Object[] parameters) {
        CassandraParametersParameterAccessor parameterAccessor = new CassandraParametersParameterAccessor(this.getQueryMethod(), parameters);
        ResultProcessor resultProcessor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        SimpleStatement statement = this.createQuery(parameterAccessor);
        CassandraQueryExecution queryExecution = this.getExecution(parameterAccessor, new CassandraQueryExecution.ResultProcessingConverter(resultProcessor, this.getMappingContext(), this.getEntityInstantiators()));
        Class<?> resultType = this.resolveResultType(resultProcessor);
        return queryExecution.execute((Statement<?>)statement, resultType);
    }

    private Class<?> resolveResultType(ResultProcessor resultProcessor) {
        CassandraRepositoryQuerySupport.CassandraReturnedType returnedType = new CassandraRepositoryQuerySupport.CassandraReturnedType(this, resultProcessor.getReturnedType(), this.getOperations().getConverter().getCustomConversions());
        return returnedType.getResultType();
    }

    protected abstract SimpleStatement createQuery(CassandraParameterAccessor var1);

    private CassandraQueryExecution getExecution(CassandraParameterAccessor parameterAccessor, Converter<Object, Object> resultProcessing) {
        return new CassandraQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(parameterAccessor, resultProcessing), resultProcessing);
    }

    private CassandraQueryExecution getExecutionToWrap(CassandraParameterAccessor parameterAccessor, Converter<Object, Object> resultProcessing) {
        if (this.getQueryMethod().isSliceQuery()) {
            return new CassandraQueryExecution.SlicedExecution(this.getOperations(), parameterAccessor.getPageable());
        }
        if (this.getQueryMethod().isScrollQuery()) {
            return new CassandraQueryExecution.WindowExecution(this.getOperations(), parameterAccessor.getScrollPosition(), parameterAccessor.getLimit());
        }
        if (this.getQueryMethod().isSearchQuery()) {
            return new CassandraQueryExecution.SearchExecution(this.getOperations(), parameterAccessor);
        }
        if (this.getQueryMethod().isCollectionQuery()) {
            return new CassandraQueryExecution.CollectionExecution(this.getOperations());
        }
        if (this.getQueryMethod().isResultSetQuery()) {
            return new CassandraQueryExecution.ResultSetQuery(this.getOperations());
        }
        if (this.getQueryMethod().isStreamQuery()) {
            return new CassandraQueryExecution.StreamExecution(this.getOperations(), resultProcessing);
        }
        if (this.isCountQuery()) {
            return (statement, type) -> new CassandraQueryExecution.SingleEntityExecution(this.getOperations(), false).execute(statement, Long.class);
        }
        if (this.isExistsQuery()) {
            return new CassandraQueryExecution.ExistsExecution(this.getOperations());
        }
        if (this.isModifyingQuery()) {
            return (statement, type) -> this.getOperations().execute(statement).wasApplied();
        }
        return new CassandraQueryExecution.SingleEntityExecution(this.getOperations(), this.isLimiting());
    }

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isLimiting();

    protected abstract boolean isModifyingQuery();
}

