/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.EntityQueryUtils;
import org.springframework.data.cassandra.core.ExecutableSelectOperation;
import org.springframework.data.cassandra.core.QueryResultConverter;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.domain.Slice;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class ExecutableSelectOperationSupport
implements ExecutableSelectOperation {
    private final CassandraTemplate template;

    public ExecutableSelectOperationSupport(CassandraTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableSelectOperation.ExecutableSelect<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableSelectSupport(this.template, domainType, domainType, QueryResultConverter.entity(), Query.empty(), null);
    }

    @Override
    public ExecutableSelectOperation.UntypedSelect query(String cql) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return new UntypedSelectSupport(this.template, (Statement<?>)SimpleStatement.newInstance((String)cql));
    }

    @Override
    public ExecutableSelectOperation.UntypedSelect query(Statement<?> statement) {
        Assert.notNull(statement, (String)"Statement must not be null");
        return new UntypedSelectSupport(this.template, statement);
    }

    static class ExecutableSelectSupport<S, T>
    implements ExecutableSelectOperation.ExecutableSelect<T> {
        private final CassandraTemplate template;
        private final Class<?> domainType;
        private final Class<S> returnType;
        private final QueryResultConverter<? super S, ? extends T> mappingFunction;
        private final Query query;
        private final @Nullable CqlIdentifier tableName;

        public ExecutableSelectSupport(CassandraTemplate template, Class<?> domainType, Class<S> returnType, QueryResultConverter<? super S, ? extends T> mappingFunction, Query query2, @Nullable CqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.mappingFunction = mappingFunction;
            this.query = query2;
            this.tableName = tableName;
        }

        @Override
        public <R> ExecutableSelectOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            Assert.notNull(converter, (String)"Mapping function name must not be null");
            return new ExecutableSelectSupport<S, R>(this.template, this.domainType, this.returnType, this.mappingFunction.andThen(converter), this.query, this.tableName);
        }

        @Override
        public ExecutableSelectOperation.SelectWithProjection<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ExecutableSelectSupport<S, T>(this.template, this.domainType, this.returnType, this.mappingFunction, this.query, tableName);
        }

        @Override
        public <R> ExecutableSelectOperation.SelectWithQuery<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null");
            return new ExecutableSelectSupport(this.template, this.domainType, returnType, QueryResultConverter.entity(), this.query, this.tableName);
        }

        @Override
        public ExecutableSelectOperation.TerminatingSelect<T> matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ExecutableSelectSupport<S, T>(this.template, this.domainType, this.returnType, this.mappingFunction, query2, this.tableName);
        }

        @Override
        public long count() {
            return this.template.doCount(this.query, this.domainType, this.getTableName());
        }

        @Override
        public boolean exists() {
            return this.template.doExists(this.query, this.domainType, this.getTableName());
        }

        @Override
        public @Nullable T firstValue() {
            List<T> result = this.template.doSelect(this.query.limit(1L), this.domainType, this.getTableName(), this.returnType, this.mappingFunction);
            return ObjectUtils.isEmpty(result) ? null : (T)result.iterator().next();
        }

        @Override
        public @Nullable T oneValue() {
            List<T> result = this.template.doSelect(this.query.limit(2L), this.domainType, this.getTableName(), this.returnType, this.mappingFunction);
            if (ObjectUtils.isEmpty(result)) {
                return null;
            }
            if (result.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(String.format("Query [%s] returned non unique result", this.query), 1);
            }
            return result.iterator().next();
        }

        @Override
        public List<T> all() {
            return this.template.doSelect(this.query, this.domainType, this.getTableName(), this.returnType, this.mappingFunction);
        }

        @Override
        public Slice<T> slice() {
            return this.template.doSlice(this.query, this.domainType, this.getTableName(), this.returnType, this.mappingFunction);
        }

        @Override
        public Stream<T> stream() {
            return this.template.doStream(this.query, this.domainType, this.getTableName(), this.returnType, this.mappingFunction);
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }

    private record UntypedSelectSupport(CassandraTemplate template, Statement<?> statement) implements ExecutableSelectOperation.UntypedSelect
    {
        @Override
        public <T> ExecutableSelectOperation.TerminatingResults<T> as(Class<T> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null");
            return new TypedSelectSupport<T>(this.template, this.statement, resultType);
        }

        @Override
        public <T> ExecutableSelectOperation.TerminatingResults<T> map(RowMapper<T> mapper) {
            Assert.notNull(mapper, (String)"RowMapper must not be null");
            return new TerminatingSelectResultSupport(this.template, this.statement, mapper);
        }
    }

    static class TerminatingSelectResultSupport<S, T>
    implements ExecutableSelectOperation.TerminatingResults<T> {
        final CassandraTemplate template;
        final Statement<?> statement;
        final RowMapper<T> rowMapper;

        TerminatingSelectResultSupport(CassandraTemplate template, Statement<?> statement, RowMapper<T> rowMapper) {
            this.template = template;
            this.statement = statement;
            this.rowMapper = rowMapper;
        }

        TerminatingSelectResultSupport(CassandraTemplate template, Statement<?> statement, Class<S> domainType, QueryResultConverter<? super S, ? extends T> mappingFunction) {
            this(template, statement, template.getRowMapper(domainType, EntityQueryUtils.getTableName(statement), mappingFunction));
        }

        @Override
        public <R> ExecutableSelectOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            return new TerminatingSelectResultSupport<S, Object>(this.template, this.statement, (row, rowNum) -> converter.mapRow(row, () -> this.rowMapper.mapRow(row, rowNum)));
        }

        @Override
        public @Nullable T firstValue() {
            List<T> result = this.template.getCqlOperations().query(this.statement, this.rowMapper);
            return ObjectUtils.isEmpty(result) ? null : (T)result.iterator().next();
        }

        @Override
        public @Nullable T oneValue() {
            List<T> result = this.template.getCqlOperations().query(this.statement, this.rowMapper);
            if (ObjectUtils.isEmpty(result)) {
                return null;
            }
            if (result.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(String.format("Query [%s] returned non unique result", QueryExtractorDelegate.getCql(this.statement)), 1);
            }
            return result.iterator().next();
        }

        @Override
        public List<T> all() {
            return this.template.getCqlOperations().query(this.statement, this.rowMapper);
        }

        @Override
        public Slice<T> slice() {
            return this.template.doSlice(this.statement, this.rowMapper);
        }

        @Override
        public Stream<T> stream() {
            return this.template.getCqlOperations().queryForStream(this.statement, this.rowMapper);
        }
    }

    static class TypedSelectSupport<T>
    extends TerminatingSelectResultSupport<T, T>
    implements ExecutableSelectOperation.TerminatingResults<T> {
        private final Class<T> domainType;

        TypedSelectSupport(CassandraTemplate template, Statement<?> statement, Class<T> domainType) {
            super(template, statement, template.getRowMapper(domainType, EntityQueryUtils.getTableName(statement), QueryResultConverter.entity()));
            this.domainType = domainType;
        }

        @Override
        public <R> ExecutableSelectOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            Assert.notNull(converter, (String)"Mapping function must not be null");
            return new TerminatingSelectResultSupport<T, R>(this.template, this.statement, this.domainType, converter);
        }
    }
}

