/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.type.DataType;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.core.query.CassandraScrollPosition;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;

public class CassandraParametersParameterAccessor
extends ParametersParameterAccessor
implements CassandraParameterAccessor {
    public CassandraParametersParameterAccessor(CassandraQueryMethod method, Object ... values) {
        super((Parameters)method.getParameters(), values);
    }

    @Override
    public @Nullable DataType getDataType(int index) {
        CassandraType cassandraType = this.findCassandraType(index);
        return cassandraType != null ? CassandraSimpleTypeHolder.getDataTypeFor(cassandraType.type()) : CassandraSimpleTypeHolder.getDataTypeFor(this.getParameterType(index));
    }

    @Override
    public @Nullable CassandraType findCassandraType(int index) {
        return ((CassandraParameters.CassandraParameter)this.getParameters().getParameter(index)).getCassandraType();
    }

    @Override
    public Class<?> getParameterType(int index) {
        return ((CassandraParameters.CassandraParameter)this.getParameters().getParameter(index)).getType();
    }

    public CassandraParameters getParameters() {
        return (CassandraParameters)super.getParameters();
    }

    @Override
    public @Nullable Object[] getValues() {
        return super.getValues();
    }

    @Override
    public @Nullable Object getValue(int parameterIndex) {
        return super.getValue(parameterIndex);
    }

    @Override
    public CassandraScrollPosition getScrollPosition() {
        ScrollPosition scrollPosition = super.getScrollPosition();
        if (scrollPosition instanceof CassandraScrollPosition) {
            CassandraScrollPosition csp = (CassandraScrollPosition)scrollPosition;
            return csp;
        }
        if (scrollPosition == null) {
            return CassandraScrollPosition.initial();
        }
        throw new IllegalArgumentException("Unsupported scroll position " + String.valueOf(scrollPosition) + ". Only CassandraScrollPosition supported.");
    }

    @Override
    public @Nullable ScoringFunction getScoringFunction() {
        int scoringFunctionIndex;
        Score score = this.getScore();
        if (score != null) {
            return score.getFunction();
        }
        Range range = this.getScoreRange();
        if (range != null) {
            if (range.getLowerBound().isBounded()) {
                return ((Score)range.getLowerBound().getValue().get()).getFunction();
            }
            if (range.getUpperBound().isBounded()) {
                return ((Score)range.getUpperBound().getValue().get()).getFunction();
            }
        }
        if ((scoringFunctionIndex = this.getParameters().getScoringFunctionIndex()) != -1) {
            return (ScoringFunction)this.getValue(scoringFunctionIndex);
        }
        return null;
    }

    public Limit getLimit() {
        if (!this.getParameters().hasLimitParameter()) {
            return Limit.unlimited();
        }
        return super.getLimit();
    }

    @Override
    public @Nullable QueryOptions getQueryOptions() {
        int queryOptionsIndex = this.getParameters().getQueryOptionsIndex();
        Object value = queryOptionsIndex != -1 ? this.getValue(queryOptionsIndex) : null;
        return (QueryOptions)value;
    }
}

