/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.core.util.Strings;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.mapping.NamingStrategy;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class CqlIdentifierGenerator {
    private @Nullable NamingStrategy namingStrategy;

    CqlIdentifierGenerator() {
    }

    static CqlIdentifier createIdentifier(String simpleName, boolean forceQuote) {
        if (Strings.isDoubleQuoted((String)simpleName)) {
            return CqlIdentifier.fromCql((String)simpleName);
        }
        if (forceQuote || Strings.needsDoubleQuotes((String)simpleName)) {
            return CqlIdentifier.fromInternal((String)simpleName);
        }
        return CqlIdentifier.fromCql((String)simpleName);
    }

    private static CqlIdentifier createIdentifier(GeneratedName name) {
        return CqlIdentifierGenerator.createIdentifier(name.getRequiredName(), name.useForceQuote());
    }

    public <T> GeneratedName generate(@Nullable String providedName, boolean forceQuote, BiFunction<NamingStrategy, T, String> defaultNameGenerator, T source, ValueExpressionParser parser, BiFunction<Object, ExpressionDependencies, ValueEvaluationContext> contextFunction) {
        String name;
        boolean useForceQuote = forceQuote;
        if (StringUtils.hasText((String)providedName)) {
            ValueExpression expression = parser.parse(providedName);
            name = ObjectUtils.nullSafeToString((Object)expression.evaluate(contextFunction.apply(null, expression.getExpressionDependencies())));
            useForceQuote = true;
        } else {
            name = defaultNameGenerator.apply(this.getNamingStrategy(forceQuote), (NamingStrategy)source);
        }
        return new GeneratedName(name, useForceQuote, source, CqlIdentifierGenerator::createIdentifier);
    }

    public void setNamingStrategy(@Nullable NamingStrategy namingStrategy) {
        Assert.notNull((Object)namingStrategy, (String)"NamingStrategy must not be null");
        this.namingStrategy = namingStrategy;
    }

    private NamingStrategy getNamingStrategy(boolean forceQuote) {
        if (this.namingStrategy == null) {
            if (forceQuote) {
                return new NamingStrategy(){};
            }
            return NamingStrategy.INSTANCE;
        }
        return this.namingStrategy;
    }

    record GeneratedName(@Nullable String name, boolean useForceQuote, Object source, Function<GeneratedName, CqlIdentifier> identifierFunction) {
        public boolean hasName() {
            return this.name != null;
        }

        public String getRequiredName() {
            String name = this.name();
            if (name == null) {
                throw new IllegalStateException(String.format("Cannot determine default name for %s", this.source));
            }
            return name;
        }

        public @Nullable CqlIdentifier getIdentifier() {
            return this.hasName() ? this.identifierFunction.apply(this) : null;
        }

        public CqlIdentifier getRequiredIdentifier() {
            CqlIdentifier identifier = this.getIdentifier();
            if (identifier == null) {
                throw new IllegalStateException(String.format("Cannot determine default name for %s", this.source));
            }
            return identifier;
        }
    }
}

