/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.util;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.util.Bindings;
import org.springframework.data.cassandra.core.cql.util.TermFactory;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class StatementBuilder<S extends BuildableQuery> {
    private final S statement;
    private final CodecRegistry registry;
    private final List<BuilderRunnable<S>> queryActions = new ArrayList<BuilderRunnable<S>>();
    private final List<Consumer<SimpleStatementBuilder>> onBuild = new ArrayList<Consumer<SimpleStatementBuilder>>();
    private final List<UnaryOperator<SimpleStatement>> onBuilt = new ArrayList<UnaryOperator<SimpleStatement>>();

    public static <S extends BuildableQuery> StatementBuilder<S> of(S stub) {
        return StatementBuilder.of(stub, CodecRegistry.DEFAULT);
    }

    public static <S extends BuildableQuery> StatementBuilder<S> of(S stub, CodecRegistry registry) {
        Assert.notNull(stub, (String)"Query stub must not be null");
        Assert.notNull((Object)registry, (String)"CodecRegistry stub must not be null");
        return new StatementBuilder<S>(stub, registry);
    }

    private StatementBuilder(S statement, CodecRegistry registry) {
        this.statement = statement;
        this.registry = registry;
    }

    @Contract(value="_ -> this")
    public StatementBuilder<S> bind(BindFunction<S> action) {
        Assert.notNull(action, (String)"BindFunction must not be null");
        this.queryActions.add(action::bind);
        return this;
    }

    @Contract(value="_ -> this")
    public <R extends BuildableQuery> StatementBuilder<S> apply(Function<S, R> action) {
        Assert.notNull(action, (String)"BindFunction must not be null");
        this.queryActions.add((source, termFactory) -> (BuildableQuery)action.apply(source));
        return this;
    }

    @Contract(value="_ -> this")
    public StatementBuilder<S> onBuild(Consumer<SimpleStatementBuilder> action) {
        Assert.notNull(action, (String)"Consumer must not be null");
        this.onBuild.add(action);
        return this;
    }

    @Contract(value="_ -> this")
    public StatementBuilder<S> transform(UnaryOperator<SimpleStatement> mappingFunction) {
        Assert.notNull(mappingFunction, (String)"Mapping function must not be null");
        this.onBuilt.add(mappingFunction);
        return this;
    }

    @CheckReturnValue
    public SimpleStatement build() {
        return this.build(ParameterHandling.BY_INDEX, this.registry);
    }

    @CheckReturnValue
    public SimpleStatement build(ParameterHandling parameterHandling) {
        return this.build(parameterHandling, this.registry);
    }

    @CheckReturnValue
    public SimpleStatement build(ParameterHandling parameterHandling, final CodecRegistry codecRegistry) {
        Assert.notNull((Object)((Object)parameterHandling), (String)"ParameterHandling must not be null");
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        Object statement = this.statement;
        if (parameterHandling == ParameterHandling.INLINE) {
            TermFactory termFactory = new TermFactory(){

                @Override
                public Term create(@Nullable Object value) {
                    return StatementBuilder.toLiteralTerms(value, codecRegistry);
                }

                @Override
                public boolean canBindCollection() {
                    return false;
                }
            };
            for (BuilderRunnable<S> runnable : this.queryActions) {
                statement = (BuildableQuery)runnable.run(statement, termFactory);
            }
            return this.build(statement.builder());
        }
        if (parameterHandling == ParameterHandling.BY_INDEX) {
            final ArrayList values = new ArrayList();
            TermFactory termFactory = new TermFactory(){

                public BindMarker create(@Nullable Object value) {
                    values.add(value);
                    return QueryBuilder.bindMarker();
                }

                @Override
                public <T> T ifBoundOrInline(Function<Bindings, T> bindingFunction, Supplier<T> inlineFunction) {
                    return bindingFunction.apply(this::create);
                }
            };
            for (BuilderRunnable<S> runnable : this.queryActions) {
                statement = (BuildableQuery)runnable.run(statement, termFactory);
            }
            SimpleStatementBuilder builder = statement.builder();
            values.forEach(arg_0 -> ((SimpleStatementBuilder)builder).addPositionalValue(arg_0));
            return this.build(builder);
        }
        if (parameterHandling == ParameterHandling.BY_NAME) {
            final LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            TermFactory termFactory = new TermFactory(){

                public BindMarker create(@Nullable Object value) {
                    String name = "p" + values.size();
                    values.put(name, value);
                    return QueryBuilder.bindMarker((String)name);
                }

                @Override
                public <T> T ifBoundOrInline(Function<Bindings, T> bindingFunction, Supplier<T> inlineFunction) {
                    return bindingFunction.apply(this::create);
                }
            };
            for (BuilderRunnable<S> runnable : this.queryActions) {
                statement = (BuildableQuery)runnable.run(statement, termFactory);
            }
            SimpleStatementBuilder builder = statement.builder();
            values.forEach((arg_0, arg_1) -> ((SimpleStatementBuilder)builder).addNamedValue(arg_0, arg_1));
            return this.build(builder);
        }
        throw new UnsupportedOperationException(String.format("ParameterHandling %s not supported", new Object[]{parameterHandling}));
    }

    private SimpleStatement build(SimpleStatementBuilder builder) {
        SimpleStatement statmentToUse = this.onBuild(builder).build();
        for (UnaryOperator<SimpleStatement> operator : this.onBuilt) {
            statmentToUse = (SimpleStatement)operator.apply(statmentToUse);
        }
        return statmentToUse;
    }

    private SimpleStatementBuilder onBuild(SimpleStatementBuilder statementBuilder) {
        this.onBuild.forEach(it -> it.accept(statementBuilder));
        return statementBuilder;
    }

    private static Term toLiteralTerms(@Nullable Object value, CodecRegistry codecRegistry) {
        if (value instanceof List) {
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Object o : (List)value) {
                terms.add(StatementBuilder.toLiteralTerms(o, codecRegistry));
            }
            return new ListTerm(terms);
        }
        if (value instanceof Set) {
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Object o : (Set)value) {
                terms.add(StatementBuilder.toLiteralTerms(o, codecRegistry));
            }
            return new SetTerm(terms);
        }
        if (value instanceof Map) {
            LinkedHashMap terms = new LinkedHashMap();
            ((Map)value).forEach((k, v) -> terms.put(StatementBuilder.toLiteralTerms(k, codecRegistry), StatementBuilder.toLiteralTerms(v, codecRegistry)));
            return new MapTerm(terms);
        }
        return QueryBuilder.literal((Object)value, (CodecRegistry)codecRegistry);
    }

    @FunctionalInterface
    public static interface BindFunction<S> {
        public S bind(S var1, TermFactory var2);
    }

    @FunctionalInterface
    static interface BuilderRunnable<S> {
        public S run(S var1, TermFactory var2);
    }

    public static enum ParameterHandling {
        INLINE,
        BY_INDEX,
        BY_NAME;

    }

    static class ListTerm
    implements Term {
        private final Collection<? extends Term> components;

        public ListTerm(@NonNull Collection<? extends Term> components) {
            this.components = components;
        }

        public void appendTo(@NonNull StringBuilder builder) {
            if (this.components.isEmpty()) {
                builder.append("[]");
                return;
            }
            CqlHelper.append(this.components, (StringBuilder)builder, (String)"[", (String)",", (String)"]");
        }

        public boolean isIdempotent() {
            for (Term term : this.components) {
                if (term.isIdempotent()) continue;
                return false;
            }
            return true;
        }
    }

    static class SetTerm
    implements Term {
        private final Collection<? extends Term> components;

        public SetTerm(@NonNull Collection<? extends Term> components) {
            this.components = components;
        }

        public void appendTo(@NonNull StringBuilder builder) {
            if (this.components.isEmpty()) {
                builder.append("{}");
                return;
            }
            CqlHelper.append(this.components, (StringBuilder)builder, (String)"{", (String)",", (String)"}");
        }

        public boolean isIdempotent() {
            for (Term term : this.components) {
                if (term.isIdempotent()) continue;
                return false;
            }
            return true;
        }
    }

    static class MapTerm
    implements Term {
        private final Map<? extends Term, ? extends Term> components;

        public MapTerm(Map<? extends Term, ? extends Term> components) {
            this.components = components;
        }

        public void appendTo(@NonNull StringBuilder builder) {
            if (this.components.isEmpty()) {
                builder.append("{}");
                return;
            }
            boolean first = true;
            for (Map.Entry<? extends Term, ? extends Term> entry : this.components.entrySet()) {
                if (first) {
                    builder.append("{");
                    first = false;
                } else {
                    builder.append(",");
                }
                entry.getKey().appendTo(builder);
                builder.append(":");
                entry.getValue().appendTo(builder);
            }
            if (!first) {
                builder.append("}");
            }
        }

        public boolean isIdempotent() {
            for (Map.Entry<? extends Term, ? extends Term> entry : this.components.entrySet()) {
                if (entry.getKey().isIdempotent() && entry.getValue().isIdempotent()) continue;
                return false;
            }
            return true;
        }
    }
}

