/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.ReservedKeyword;
import org.springframework.util.Assert;

@Deprecated
public final class KeyspaceIdentifier
implements Comparable<KeyspaceIdentifier> {
    public static final String REGEX = "(?i)[a-z][\\w]{0,47}";
    public static final Pattern PATTERN = Pattern.compile("(?i)[a-z][\\w]{0,47}");
    private final String identifier;

    private KeyspaceIdentifier(CharSequence identifier) {
        Assert.notNull((Object)identifier, (String)"Identifier must not be null");
        String string = identifier.toString();
        Assert.hasText((String)string, (String)"Identifier must not be empty");
        if (!KeyspaceIdentifier.isIdentifier(string)) {
            throw new IllegalArgumentException(String.format("given string [%s] is not a valid keyspace identifier", identifier));
        }
        this.identifier = string.toLowerCase();
    }

    @Deprecated
    public static KeyspaceIdentifier ksId(CharSequence identifier) {
        return new KeyspaceIdentifier(identifier);
    }

    public static KeyspaceIdentifier of(CharSequence identifier) {
        return new KeyspaceIdentifier(identifier);
    }

    public static boolean isIdentifier(CharSequence chars) {
        return PATTERN.matcher(chars).matches() && !ReservedKeyword.isReserved(chars);
    }

    public String toCql() {
        return this.identifier;
    }

    public StringBuilder toCql(StringBuilder sb) {
        return sb.append(this.toCql());
    }

    public String toString() {
        return this.toCql();
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(@Nullable Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof KeyspaceIdentifier) && !(that instanceof CharSequence)) {
            return false;
        }
        KeyspaceIdentifier other = that instanceof KeyspaceIdentifier ? (KeyspaceIdentifier)that : KeyspaceIdentifier.of((CharSequence)that);
        return this.identifier.equals(other.identifier);
    }

    @Override
    public int compareTo(KeyspaceIdentifier that) {
        return this.identifier.compareTo(that.identifier);
    }

    public CqlIdentifier toCqlIdentifier() {
        return CqlIdentifier.fromCql((String)this.identifier);
    }
}

