/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.CqlVector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.SpecificationBuilder;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.Indexed;
import org.springframework.data.cassandra.core.mapping.SASI;
import org.springframework.data.cassandra.core.mapping.SaiIndexed;
import org.springframework.data.domain.Vector;
import org.springframework.data.mapping.MappingException;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class IndexSpecificationFactory {
    private static final Map<Class<? extends Annotation>, CreateIndexConfigurer<? super Annotation>> INDEX_CONFIGURERS;

    IndexSpecificationFactory() {
    }

    static List<CreateIndexSpecification> createIndexSpecifications(@Nullable CqlIdentifier keyspace, CassandraPersistentProperty property) {
        CreateIndexSpecification index;
        ArrayList<CreateIndexSpecification> indexes = new ArrayList<CreateIndexSpecification>();
        if (property.isAnnotationPresent(Indexed.class)) {
            index = IndexSpecificationFactory.createIndexSpecification(keyspace, (Indexed)property.getRequiredAnnotation(Indexed.class), property);
            if (property.isMapLike()) {
                index.entries();
            }
            indexes.add(index);
        }
        if (property.isAnnotationPresent(SASI.class)) {
            indexes.add(IndexSpecificationFactory.createIndexSpecification(keyspace, (SASI)property.getRequiredAnnotation(SASI.class), property));
        }
        if (property.isAnnotationPresent(SaiIndexed.class)) {
            index = IndexSpecificationFactory.createIndexSpecification(keyspace, (SaiIndexed)property.getRequiredAnnotation(SaiIndexed.class), property);
            if (property.isMapLike()) {
                index.entries();
            }
            indexes.add(index);
        }
        if (property.isMapLike()) {
            indexes.addAll(IndexSpecificationFactory.createTypeAnnotatedIndexes(Indexed.class, property, indexed -> IndexSpecificationFactory.createIndexSpecification(keyspace, indexed, property)));
            indexes.addAll(IndexSpecificationFactory.createTypeAnnotatedIndexes(SaiIndexed.class, property, indexed -> IndexSpecificationFactory.createIndexSpecification(keyspace, indexed, property)));
        }
        return indexes;
    }

    private static <T extends Annotation> List<CreateIndexSpecification> createTypeAnnotatedIndexes(Class<T> annotationType, CassandraPersistentProperty property, Function<T, CreateIndexSpecification> indexFunction) {
        AnnotatedType type = property.findAnnotatedType(annotationType);
        if (type instanceof AnnotatedParameterizedType) {
            Annotation valueIndex;
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            ArrayList<CreateIndexSpecification> indexes = new ArrayList<CreateIndexSpecification>(2);
            AnnotatedType[] typeArgs = parameterizedType.getAnnotatedActualTypeArguments();
            Annotation keyIndex = typeArgs.length == 2 ? AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)typeArgs[0], annotationType) : null;
            Annotation annotation = valueIndex = typeArgs.length == 2 ? AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)typeArgs[1], annotationType) : null;
            if (keyIndex != null && valueIndex != null) {
                throw new MappingException("Multiple index declarations for " + property + " found; A map index must be either declared for entries, keys or values");
            }
            if (keyIndex != null) {
                indexes.add(indexFunction.apply(keyIndex).keys());
            }
            if (valueIndex != null) {
                indexes.add(indexFunction.apply(valueIndex).values());
            }
            return indexes;
        }
        return Collections.emptyList();
    }

    static CreateIndexSpecification createIndexSpecification(@Nullable CqlIdentifier keyspace, Indexed annotation, CassandraPersistentProperty property) {
        CreateIndexSpecification index = StringUtils.hasText((String)annotation.value()) ? SpecificationBuilder.createIndex(keyspace, CqlIdentifier.fromCql((String)annotation.value())) : SpecificationBuilder.createIndex(keyspace, null);
        return index.columnName(property.getRequiredColumnName());
    }

    private static CreateIndexSpecification createIndexSpecification(@Nullable CqlIdentifier keyspace, SASI annotation, CassandraPersistentProperty property) {
        CreateIndexSpecification index = StringUtils.hasText((String)annotation.value()) ? SpecificationBuilder.createIndex(keyspace, CqlIdentifier.fromCql((String)annotation.value())) : SpecificationBuilder.createIndex(keyspace, null);
        index.using("org.apache.cassandra.index.sasi.SASIIndex").columnName(property.getRequiredColumnName()).withOption("mode", annotation.indexMode().name());
        long analyzerCount = INDEX_CONFIGURERS.keySet().stream().filter(arg_0 -> ((CassandraPersistentProperty)property).isAnnotationPresent(arg_0)).count();
        if (analyzerCount > 1L) {
            throw new IllegalStateException(String.format("SASI indexed property %s must be annotated only with a single analyzer annotation", property));
        }
        for (Class<? extends Annotation> annotationType : INDEX_CONFIGURERS.keySet()) {
            if (!property.isAnnotationPresent(annotationType)) continue;
            Annotation analyzed = property.findAnnotation(annotationType);
            INDEX_CONFIGURERS.get(annotationType).accept(analyzed, index);
        }
        return index;
    }

    private static CreateIndexSpecification createIndexSpecification(@Nullable CqlIdentifier keyspace, SaiIndexed annotation, CassandraPersistentProperty property) {
        CreateIndexSpecification index = StringUtils.hasText((String)annotation.value()) ? SpecificationBuilder.createIndex(keyspace, CqlIdentifier.fromCql((String)annotation.value())) : SpecificationBuilder.createIndex(keyspace, null);
        CreateIndexSpecification sai = index.using("sai").columnName(property.getRequiredColumnName());
        if (IndexSpecificationFactory.isVector(property.getType())) {
            return sai.withOption("similarity_function", annotation.similarityFunction().name());
        }
        return sai.withOption("case_sensitive", Boolean.toString(annotation.caseSensitive())).withOption("normalize", Boolean.toString(annotation.normalize())).withOption("ascii", Boolean.toString(annotation.ascii()));
    }

    private static boolean isVector(Class<?> type) {
        return type.equals(CqlVector.class) || Vector.class.isAssignableFrom(type);
    }

    static {
        HashMap<Class, Enum> configurers = new HashMap<Class, Enum>();
        configurers.put(SASI.StandardAnalyzed.class, StandardAnalyzedConfigurer.INSTANCE);
        configurers.put(SASI.NonTokenizingAnalyzed.class, NonTokenizingAnalyzedConfigurer.INSTANCE);
        INDEX_CONFIGURERS = Collections.unmodifiableMap(configurers);
    }

    static interface CreateIndexConfigurer<T extends Annotation>
    extends BiConsumer<T, CreateIndexSpecification> {
    }

    static enum StandardAnalyzedConfigurer implements CreateIndexConfigurer<SASI.StandardAnalyzed>
    {
        INSTANCE;


        @Override
        public void accept(SASI.StandardAnalyzed standardAnalyzed, CreateIndexSpecification index) {
            index.withOption("analyzed", "true");
            index.withOption("analyzer_class", "org.apache.cassandra.index.sasi.analyzer.StandardAnalyzer");
            index.withOption("tokenization_enable_stemming", "" + standardAnalyzed.enableStemming());
            if (standardAnalyzed.normalization() == SASI.Normalization.LOWERCASE) {
                index.withOption("tokenization_normalize_lowercase", "true");
            }
            if (standardAnalyzed.normalization() == SASI.Normalization.UPPERCASE) {
                index.withOption("tokenization_normalize_uppercase", "true");
            }
            if (StringUtils.hasText((String)standardAnalyzed.locale())) {
                index.withOption("tokenization_locale", standardAnalyzed.locale());
            }
            if (!ObjectUtils.isEmpty((Object)standardAnalyzed.skipStopWords())) {
                index.withOption("tokenization_skip_stop_words", "" + standardAnalyzed.skipStopWords());
            }
        }
    }

    static enum NonTokenizingAnalyzedConfigurer implements CreateIndexConfigurer<SASI.NonTokenizingAnalyzed>
    {
        INSTANCE;


        @Override
        public void accept(SASI.NonTokenizingAnalyzed nonTokenizingAnalyzed, CreateIndexSpecification index) {
            index.withOption("analyzed", "true");
            index.withOption("analyzer_class", "org.apache.cassandra.index.sasi.analyzer.NonTokenizingAnalyzer");
            index.withOption("case_sensitive", "" + nonTokenizingAnalyzed.caseSensitive());
            if (nonTokenizingAnalyzed.normalization() == SASI.Normalization.LOWERCASE) {
                index.withOption("normalize_lowercase", "true");
            }
            if (nonTokenizingAnalyzed.normalization() == SASI.Normalization.UPPERCASE) {
                index.withOption("normalize_uppercase", "true");
            }
        }
    }
}

