/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.truncate.Truncate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.AsyncCassandraOperations;
import org.springframework.data.cassandra.core.EntityLifecycleEventDelegate;
import org.springframework.data.cassandra.core.EntityOperations;
import org.springframework.data.cassandra.core.EntityQueryUtils;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.PreparedStatementDelegate;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.cql.AsyncCqlOperations;
import org.springframework.data.cassandra.core.cql.AsyncCqlTemplate;
import org.springframework.data.cassandra.core.cql.AsyncPreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.AsyncSessionCallback;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.RowCallbackHandler;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.SingleColumnRowMapper;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.cql.util.StatementBuilder;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.SimpleUserTypeResolver;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.cassandra.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.CassandraMappingEvent;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class AsyncCassandraTemplate
implements AsyncCassandraOperations,
ApplicationEventPublisherAware,
ApplicationContextAware {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AsyncCqlOperations cqlOperations;
    private final CassandraConverter converter;
    private final EntityOperations entityOperations;
    private final StatementFactory statementFactory;
    private final EntityLifecycleEventDelegate eventDelegate;
    private @Nullable EntityCallbacks entityCallbacks;
    private boolean usePreparedStatements = true;

    public AsyncCassandraTemplate(CqlSession session) {
        this(session, (CassandraConverter)AsyncCassandraTemplate.newConverter(session));
    }

    public AsyncCassandraTemplate(CqlSession session, CassandraConverter converter) {
        this(new DefaultSessionFactory(session), converter);
    }

    public AsyncCassandraTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        this(new AsyncCqlTemplate(sessionFactory), converter);
    }

    public AsyncCassandraTemplate(AsyncCqlTemplate asyncCqlTemplate, CassandraConverter converter) {
        Assert.notNull((Object)asyncCqlTemplate, (String)"AsyncCqlTemplate must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = asyncCqlTemplate;
        this.entityOperations = new EntityOperations(converter);
        this.statementFactory = new StatementFactory(converter);
        this.eventDelegate = new EntityLifecycleEventDelegate();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventDelegate.setPublisher(applicationEventPublisher);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setEntityCallbacks(@Nullable EntityCallbacks entityCallbacks) {
        this.entityCallbacks = entityCallbacks;
    }

    public void setEntityLifecycleEventsEnabled(boolean enabled) {
        this.eventDelegate.setEventsEnabled(enabled);
    }

    @Override
    public AsyncCqlOperations getAsyncCqlOperations() {
        return this.cqlOperations;
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    public StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public boolean isUsePreparedStatements() {
        return this.usePreparedStatements;
    }

    public void setUsePreparedStatements(boolean usePreparedStatements) {
        this.usePreparedStatements = usePreparedStatements;
    }

    protected EntityOperations getEntityOperations() {
        return this.entityOperations;
    }

    @Deprecated
    protected SpelAwareProxyProjectionFactory getProjectionFactory() {
        return (SpelAwareProxyProjectionFactory)this.getConverter().getProjectionFactory();
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return this.getEntityOperations().getRequiredPersistentEntity(entityType);
    }

    private CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getEntityOperations().getTableName(entityClass);
    }

    @Override
    public <T> CompletableFuture<List<T>> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.select((Statement<?>)SimpleStatement.newInstance((String)cql), entityClass);
    }

    @Override
    public <T> CompletableFuture<Void> select(String cql, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement<?>)SimpleStatement.newInstance((String)cql), entityConsumer, entityClass);
    }

    @Override
    public <T> CompletableFuture<T> selectOne(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement<?>)SimpleStatement.newInstance((String)cql), entityClass);
    }

    @Override
    public CompletableFuture<AsyncResultSet> execute(Statement<?> statement) throws DataAccessException {
        Assert.notNull(statement, (String)"Statement must not be null");
        return this.doQueryForResultSet(statement);
    }

    @Override
    public <T> CompletableFuture<List<T>> select(Statement<?> statement, Class<T> entityClass) {
        Assert.notNull(statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return this.doQuery(statement, (Row row, int rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> CompletableFuture<Void> select(Statement<?> statement, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull(statement, (String)"Statement must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return this.doQuery(statement, (Row row) -> entityConsumer.accept(mapper.apply(row)));
    }

    @Override
    public <T> CompletableFuture<T> selectOne(Statement<?> statement, Class<T> entityClass) {
        return this.select(statement, entityClass).thenApply(list -> list.isEmpty() ? null : list.get(0));
    }

    @Override
    public <T> CompletableFuture<Slice<T>> slice(Statement<?> statement, Class<T> entityClass) {
        Assert.notNull(statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CompletableFuture<AsyncResultSet> resultSet = this.doQueryForResultSet(statement);
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return resultSet.thenApply(rs -> EntityQueryUtils.readSlice(rs, (row, rowNum) -> mapper.apply(row), 0, this.getEffectivePageSize(statement)));
    }

    @Override
    public <T> CompletableFuture<List<T>> select(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement<?>)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)).build(), entityClass);
    }

    @Override
    public <T> CompletableFuture<Void> select(Query query2, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement<?>)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)).build(), entityConsumer, entityClass);
    }

    @Override
    public <T> CompletableFuture<T> selectOne(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement<?>)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)).build(), entityClass);
    }

    @Override
    public <T> CompletableFuture<Slice<T>> slice(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.slice((Statement<?>)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)).build(), entityClass);
    }

    @Override
    public CompletableFuture<Boolean> update(Query query2, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doExecute((Statement<?>)this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass)).build(), (Function)AsyncResultSet::wasApplied);
    }

    @Override
    public CompletableFuture<Boolean> delete(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doDelete(query2, entityClass, this.getTableName(entityClass));
    }

    private CompletableFuture<Boolean> doDelete(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        StatementBuilder<Delete> builder = this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        SimpleStatement delete = builder.build();
        this.maybeEmitEvent(() -> new BeforeDeleteEvent((Statement<?>)delete, entityClass, tableName));
        CompletableFuture<Boolean> future = this.doExecute((Statement<?>)delete, (Function)AsyncResultSet::wasApplied);
        future.thenAccept(success -> this.maybeEmitEvent(() -> new AfterDeleteEvent((Statement<?>)delete, entityClass, tableName)));
        return future;
    }

    @Override
    public CompletableFuture<Long> count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doCount(Query.empty(), entityClass, this.getTableName(entityClass));
    }

    @Override
    public CompletableFuture<Long> count(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doCount(query2, entityClass, this.getTableName(entityClass));
    }

    CompletableFuture<Long> doCount(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        StatementBuilder<Select> countStatement = this.getStatementFactory().count(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        SimpleStatement statement = countStatement.build();
        CompletableFuture<@Nullable Long> result = this.doExecute((Statement<?>)statement, (Function)it -> {
            SingleColumnRowMapper<@Nullable Long> mapper = SingleColumnRowMapper.newInstance(Long.class);
            Row row = (Row)DataAccessUtils.requiredUniqueResult((Collection)Streamable.of((Iterable)it.currentPage()).toList());
            return mapper.mapRow(row, 0);
        });
        return result.thenApply(it -> it != null ? it : 0L);
    }

    @Override
    public CompletableFuture<Boolean> exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        StatementBuilder<Select> select2 = this.getStatementFactory().selectOneById(id, entity, entity.getTableName());
        return this.doExecute((Statement<?>)select2.build(), (Function)resultSet -> resultSet.one() != null);
    }

    @Override
    public CompletableFuture<Boolean> exists(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        StatementBuilder<Select> select2 = this.getStatementFactory().select(query2.limit(1L), this.getRequiredPersistentEntity(entityClass), this.getTableName(entityClass));
        return this.doExecute((Statement<?>)select2.build(), (Function)resultSet -> resultSet.one() != null);
    }

    @Override
    public <T> CompletableFuture<T> selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        StatementBuilder<Select> select2 = this.getStatementFactory().selectOneById(id, entity, tableName);
        Function mapper = this.getMapper(entityClass, entityClass, tableName);
        return this.doQuery((Statement<?>)select2.build(), (Row row, int rowNum) -> mapper.apply(row)).thenApply(it -> it.isEmpty() ? null : it.get(0));
    }

    @Override
    public <T> CompletableFuture<T> insert(T entity) {
        return this.insert(entity, InsertOptions.empty()).thenApply(EntityWriteResult::getEntity);
    }

    @Override
    public <T> CompletableFuture<EntityWriteResult<T>> insert(T entity, InsertOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        return this.doInsert(entity, options, this.getTableName(entity.getClass()));
    }

    private <T> CompletableFuture<EntityWriteResult<T>> doInsert(T entity, WriteOptions options, CqlIdentifier tableName) {
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(this.maybeCallBeforeConvert(entity, tableName), this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        T entityToUse = source.isVersionedEntity() ? source.initializeVersionProperty() : source.getBean();
        StatementBuilder<RegularInsert> builder = this.getStatementFactory().insert(entityToUse, options, persistentEntity, tableName);
        if (source.isVersionedEntity()) {
            builder.apply(Insert::ifNotExists);
            return this.doInsertVersioned(builder.build(), entityToUse, source, tableName);
        }
        return this.doInsert(builder.build(), entityToUse, source, tableName);
    }

    private <T> CompletableFuture<EntityWriteResult<T>> doInsertVersioned(SimpleStatement insert, T entity, EntityOperations.AdaptibleEntity<T> source, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, insert, result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot insert entity %s with version %s into table %s as it already exists", entity, source.getVersion(), tableName));
            }
        });
    }

    private <T> CompletableFuture<EntityWriteResult<T>> doInsert(SimpleStatement insert, T entity, EntityOperations.AdaptibleEntity<T> source, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, insert);
    }

    @Override
    public <T> CompletableFuture<T> update(T entity) {
        return this.update(entity, UpdateOptions.empty()).thenApply(EntityWriteResult::getEntity);
    }

    @Override
    public <T> CompletableFuture<EntityWriteResult<T>> update(T entity, UpdateOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        T entityToUpdate = this.maybeCallBeforeConvert(entity, tableName);
        return source.isVersionedEntity() ? this.doUpdateVersioned(entityToUpdate, options, tableName, persistentEntity) : this.doUpdate(entityToUpdate, options, tableName, persistentEntity);
    }

    private <T> CompletableFuture<EntityWriteResult<T>> doUpdateVersioned(T entity, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        EntityOperations.AdaptibleEntity source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        Number previousVersion = source.getVersion();
        Object toSave = source.incrementVersion();
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update = this.getStatementFactory().update(toSave, options, persistentEntity, tableName);
        source.appendVersionCondition(update, previousVersion);
        return this.executeSave(toSave, tableName, update.build(), result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot save entity %s with version %s to table %s; Has it been modified meanwhile", toSave, source.getVersion(), tableName));
            }
        });
    }

    private <T> CompletableFuture<EntityWriteResult<T>> doUpdate(T entity, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update = this.getStatementFactory().update(entity, options, persistentEntity, tableName);
        return this.executeSave(entity, tableName, update.build());
    }

    @Override
    public <T> CompletableFuture<T> delete(T entity) {
        return this.delete(entity, QueryOptions.empty()).thenApply(writeResult -> entity);
    }

    @Override
    public CompletableFuture<WriteResult> delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        EntityOperations.AdaptibleEntity<Object> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        return source.isVersionedEntity() ? this.doDeleteVersioned(entity, options, source, tableName) : this.doDelete(entity, options, tableName);
    }

    private CompletableFuture<WriteResult> doDeleteVersioned(Object entity, QueryOptions options, EntityOperations.AdaptibleEntity<Object> source, CqlIdentifier tableName) {
        StatementBuilder<Delete> delete = this.getStatementFactory().delete(entity, options, (EntityWriter<Object, Object>)this.getConverter(), tableName);
        return this.executeDelete(entity, tableName, source.appendVersionCondition(delete).build(), result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot delete entity %s with version %s in table %s; Has it been modified meanwhile", entity, source.getVersion(), tableName));
            }
        });
    }

    private CompletableFuture<WriteResult> doDelete(Object entity, QueryOptions options, CqlIdentifier tableName) {
        StatementBuilder<Delete> delete = this.getStatementFactory().delete(entity, options, (EntityWriter<Object, Object>)this.getConverter(), tableName);
        return this.executeDelete(entity, tableName, delete.build(), result -> {});
    }

    @Override
    public CompletableFuture<Boolean> deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        StatementBuilder<Delete> builder = this.getStatementFactory().deleteById(id, entity, tableName);
        SimpleStatement delete = builder.build();
        this.maybeEmitEvent(() -> new BeforeDeleteEvent((Statement<?>)delete, entityClass, tableName));
        CompletableFuture<Boolean> future = this.doExecute((Statement<?>)delete, (Function)AsyncResultSet::wasApplied);
        future.thenAccept(success -> this.maybeEmitEvent(() -> new AfterDeleteEvent((Statement<?>)delete, entityClass, tableName)));
        return future;
    }

    @Override
    public CompletableFuture<Void> truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        Truncate truncate = QueryBuilder.truncate((CqlIdentifier)entity.getKeyspace(), (CqlIdentifier)tableName);
        SimpleStatement statement = truncate.build();
        this.maybeEmitEvent(() -> new BeforeDeleteEvent((Statement<?>)statement, entityClass, tableName));
        CompletableFuture<Boolean> future = this.doExecute((Statement<?>)statement, (Function)AsyncResultSet::wasApplied);
        future.thenAccept(success -> this.maybeEmitEvent(() -> new AfterDeleteEvent((Statement<?>)statement, entityClass, tableName)));
        return future.thenApply(aBoolean -> null);
    }

    protected AsyncPreparedStatementHandler createPreparedStatementHandler(Statement<?> statement) {
        return new PreparedStatementHandler(statement);
    }

    private <T> CompletableFuture<EntityWriteResult<T>> executeSave(T entity, CqlIdentifier tableName, SimpleStatement statement) {
        return this.executeSave(entity, tableName, statement, ignore -> {});
    }

    private <T> CompletableFuture<EntityWriteResult<T>> executeSave(T entity, CqlIdentifier tableName, SimpleStatement statement, Consumer<WriteResult> beforeAfterSaveEvent) {
        this.maybeEmitEvent(() -> new BeforeSaveEvent<Object>(entity, tableName, (Statement<?>)statement));
        Object entityToSave = this.maybeCallBeforeSave(entity, tableName, (Statement<?>)statement);
        CompletableFuture<AsyncResultSet> result = this.doQueryForResultSet((Statement<?>)statement);
        return result.thenApply(resultSet -> {
            EntityWriteResult<Object> writeResult = new EntityWriteResult<Object>(Collections.singletonList(resultSet.getExecutionInfo()), resultSet.wasApplied(), AsyncCassandraTemplate.getFirstPage(resultSet), entityToSave);
            beforeAfterSaveEvent.accept(writeResult);
            this.maybeEmitEvent(() -> new AfterSaveEvent<Object>(entityToSave, tableName));
            return writeResult;
        });
    }

    private CompletableFuture<WriteResult> executeDelete(Object entity, CqlIdentifier tableName, SimpleStatement statement, Consumer<WriteResult> resultConsumer) {
        this.maybeEmitEvent(() -> new BeforeDeleteEvent((Statement<?>)statement, entity.getClass(), tableName));
        CompletableFuture<AsyncResultSet> result = this.doQueryForResultSet((Statement<?>)statement);
        return result.thenApply(resultSet -> {
            WriteResult writeResult = new WriteResult(Collections.singletonList(resultSet.getExecutionInfo()), resultSet.wasApplied(), AsyncCassandraTemplate.getFirstPage(resultSet));
            resultConsumer.accept(writeResult);
            this.maybeEmitEvent(() -> new AfterDeleteEvent((Statement<?>)statement, entity.getClass(), tableName));
            return writeResult;
        });
    }

    private <T> CompletableFuture<List<T>> doQuery(Statement<?> statement, RowMapper<T> rowMapper) {
        if (PreparedStatementDelegate.canPrepare(this.isUsePreparedStatements(), statement, this.log)) {
            AsyncPreparedStatementHandler statementHandler = this.createPreparedStatementHandler(statement);
            return this.getAsyncCqlOperations().query((AsyncPreparedStatementCreator)statementHandler, (PreparedStatementBinder)statementHandler, rowMapper);
        }
        return this.getAsyncCqlOperations().query(statement, rowMapper);
    }

    private CompletableFuture<Void> doQuery(Statement<?> statement, RowCallbackHandler callbackHandler) {
        if (PreparedStatementDelegate.canPrepare(this.isUsePreparedStatements(), statement, this.log)) {
            AsyncPreparedStatementHandler statementHandler = this.createPreparedStatementHandler(statement);
            return this.getAsyncCqlOperations().query((AsyncPreparedStatementCreator)statementHandler, (PreparedStatementBinder)statementHandler, callbackHandler);
        }
        return this.getAsyncCqlOperations().query(statement, callbackHandler);
    }

    private CompletableFuture<AsyncResultSet> doQueryForResultSet(Statement<?> statement) {
        return this.doExecute(statement, Function.identity());
    }

    private <T> CompletableFuture<T> doExecute(Statement<?> statement, Function<AsyncResultSet, T> mappingFunction) {
        if (PreparedStatementDelegate.canPrepare(this.isUsePreparedStatements(), statement, this.log)) {
            AsyncPreparedStatementHandler statementHandler = this.createPreparedStatementHandler(statement);
            return this.getAsyncCqlOperations().query((AsyncPreparedStatementCreator)statementHandler, (PreparedStatementBinder)statementHandler, resultSet -> CompletableFuture.completedFuture(mappingFunction.apply(resultSet)));
        }
        return this.getAsyncCqlOperations().queryForResultSet(statement).thenApply(mappingFunction);
    }

    private static List<Row> getFirstPage(AsyncResultSet resultSet) {
        return StreamSupport.stream(resultSet.currentPage().spliterator(), false).collect(Collectors.toList());
    }

    private static int getConfiguredPageSize(CqlSession session) {
        return session.getContext().getConfig().getDefaultProfile().getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, 5000);
    }

    private int getEffectivePageSize(final Statement<?> statement) {
        CassandraAccessor accessor;
        if (statement.getPageSize() > 0) {
            return statement.getPageSize();
        }
        AsyncCqlOperations asyncCqlOperations = this.getAsyncCqlOperations();
        if (asyncCqlOperations instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)asyncCqlOperations)).getPageSize() != -1) {
            return accessor.getPageSize();
        }
        class GetConfiguredPageSize
        implements AsyncSessionCallback<Integer>,
        CqlProvider {
            GetConfiguredPageSize() {
            }

            @Override
            public CompletableFuture<Integer> doInSession(CqlSession session) {
                return CompletableFuture.completedFuture(AsyncCassandraTemplate.getConfiguredPageSize(session));
            }

            @Override
            public String getCql() {
                return QueryExtractorDelegate.getCql(statement);
            }
        }
        return this.getAsyncCqlOperations().execute(new GetConfiguredPageSize()).join();
    }

    private <T> Function<Row, T> getMapper(Class<?> entityType, Class<T> targetType, CqlIdentifier tableName) {
        EntityProjection projection = this.entityOperations.introspectProjection(targetType, entityType);
        return row -> {
            this.maybeEmitEvent(() -> new AfterLoadEvent((Row)row, targetType, tableName));
            Object result = this.getConverter().project(projection, (Row)row);
            if (result != null) {
                this.maybeEmitEvent(() -> new AfterConvertEvent<Object>((Row)row, result, tableName));
            }
            return result;
        };
    }

    private static MappingCassandraConverter newConverter(CqlSession session) {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.setUserTypeResolver(new SimpleUserTypeResolver(session));
        converter.setCodecRegistry(session.getContext().getCodecRegistry());
        converter.afterPropertiesSet();
        return converter;
    }

    protected <E extends CassandraMappingEvent<T>, T> void maybeEmitEvent(Supplier<E> event) {
        this.eventDelegate.publishEvent(event);
    }

    protected <T> T maybeCallBeforeConvert(T object, CqlIdentifier tableName) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, object, new Object[]{tableName});
        }
        return object;
    }

    protected <T> T maybeCallBeforeSave(T object, CqlIdentifier tableName, Statement<?> statement) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(BeforeSaveCallback.class, object, new Object[]{tableName, statement});
        }
        return object;
    }

    static class PreparedStatementHandler
    implements AsyncPreparedStatementHandler {
        private final SimpleStatement statement;

        public PreparedStatementHandler(Statement<?> statement) {
            this.statement = PreparedStatementDelegate.getStatementForPrepare(statement);
        }

        public CompletableFuture<PreparedStatement> createPreparedStatement(CqlSession session) throws DriverException {
            return this.doPrepare(session).toCompletableFuture();
        }

        protected CompletionStage<PreparedStatement> doPrepare(CqlSession session) {
            return session.prepareAsync(this.statement.getQuery());
        }

        @Override
        public BoundStatement bindValues(PreparedStatement ps) throws DriverException {
            return PreparedStatementDelegate.bind(this.statement, ps);
        }

        @Override
        public String getCql() {
            return this.statement.getQuery();
        }
    }

    public static interface AsyncPreparedStatementHandler
    extends AsyncPreparedStatementCreator,
    PreparedStatementBinder,
    CqlProvider {
    }
}

