/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.data.util.TypeScanner;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class CassandraEntityClassScanner {
    private Set<String> entityBasePackages = new HashSet<String>();
    private Set<Class<?>> entityBasePackageClasses = new HashSet();
    private @Nullable ClassLoader beanClassLoader;

    public static Set<Class<?>> scan(String ... entityBasePackages) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackages).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Class<?> ... entityBasePackageClasses) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackageClasses).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Collection<String> entityBasePackages) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackages).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Collection<String> entityBasePackages, Collection<Class<?>> entityBasePackageClasses) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackages, entityBasePackageClasses).scanForEntityClasses();
    }

    public CassandraEntityClassScanner() {
    }

    public CassandraEntityClassScanner(Class<?> ... entityBasePackageClasses) {
        this.setEntityBasePackageClasses(Arrays.asList(entityBasePackageClasses));
    }

    public CassandraEntityClassScanner(String ... entityBasePackages) {
        this(Arrays.asList(entityBasePackages));
    }

    public CassandraEntityClassScanner(Collection<String> entityBasePackages) {
        this.setEntityBasePackages(entityBasePackages);
    }

    public CassandraEntityClassScanner(Collection<String> entityBasePackages, Collection<Class<?>> entityBasePackageClasses) {
        this.setEntityBasePackages(entityBasePackages);
        this.setEntityBasePackageClasses(entityBasePackageClasses);
    }

    public Set<String> getEntityBasePackages() {
        if (ObjectUtils.isEmpty(this.entityBasePackageClasses)) {
            return Collections.unmodifiableSet(this.entityBasePackages);
        }
        return this.entityBasePackageClasses.stream().map(ClassUtils::getPackageName).collect(Collectors.toSet());
    }

    public void setEntityBasePackages(Collection<String> entityBasePackages) {
        this.entityBasePackages = new HashSet<String>(entityBasePackages);
    }

    public Set<Class<?>> getEntityBasePackageClasses() {
        return Collections.unmodifiableSet(this.entityBasePackageClasses);
    }

    public void setEntityBasePackageClasses(Collection<Class<?>> entityBasePackageClasses) {
        this.entityBasePackageClasses = new HashSet(entityBasePackageClasses);
    }

    public void setBeanClassLoader(@Nullable ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public Set<Class<?>> scanForEntityClasses() {
        ClassLoader cl;
        TypeScanner scanner = this.beanClassLoader != null ? TypeScanner.typeScanner((ClassLoader)this.beanClassLoader) : TypeScanner.typeScanner((ClassLoader)((cl = ClassUtils.getDefaultClassLoader()) != null ? cl : this.getClass().getClassLoader()));
        return scanner.forTypesAnnotatedWith((Class[])this.getEntityAnnotations()).scanPackages(this.getEntityBasePackages()).collectAsSet();
    }

    protected Class<? extends Annotation>[] getEntityAnnotations() {
        return new Class[]{Table.class, PrimaryKeyClass.class};
    }
}

