/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.function.Function;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.NamingStrategy;
import org.springframework.lang.Nullable;

public class TransformingNamingStrategy
implements NamingStrategy {
    private final Function<String, String> mappingFunction;
    private final NamingStrategy delegate;

    public TransformingNamingStrategy(NamingStrategy delegate, Function<String, String> mappingFunction) {
        this.delegate = delegate;
        this.mappingFunction = mappingFunction;
    }

    @Override
    @Nullable
    public String getKeyspace(CassandraPersistentEntity<?> entity) {
        String keyspace = this.delegate.getKeyspace(entity);
        return keyspace != null ? this.mappingFunction.apply(keyspace) : null;
    }

    @Override
    public String getTableName(CassandraPersistentEntity<?> entity) {
        return this.mappingFunction.apply(this.delegate.getTableName(entity));
    }

    @Override
    public String getUserDefinedTypeName(CassandraPersistentEntity<?> entity) {
        return this.mappingFunction.apply(this.delegate.getUserDefinedTypeName(entity));
    }

    @Override
    public String getColumnName(CassandraPersistentProperty property) {
        return this.mappingFunction.apply(this.delegate.getColumnName(property));
    }
}

