/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.generator;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.data.cassandra.core.cql.generator.CqlIdentifierUtil;
import org.springframework.data.cassandra.core.cql.generator.IndexNameCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.CqlStringUtils;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.util.StringUtils;

public class CreateIndexCqlGenerator
extends IndexNameCqlGenerator<CreateIndexSpecification> {
    public CreateIndexCqlGenerator(CreateIndexSpecification specification) {
        super(specification);
    }

    public static String toCql(CreateIndexSpecification specification) {
        return new CreateIndexCqlGenerator(specification).toCql();
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        Map<String, String> options;
        cql.append("CREATE").append(((CreateIndexSpecification)this.spec()).isCustom() ? " CUSTOM" : "").append(" INDEX").append(((CreateIndexSpecification)this.spec()).getIfNotExists() ? " IF NOT EXISTS" : "");
        if (((CreateIndexSpecification)this.spec()).getName() != null) {
            cql.append(" ").append(CqlIdentifierUtil.renderName(((CreateIndexSpecification)this.spec()).getKeyspace(), ((CreateIndexSpecification)this.spec()).getName()));
        }
        cql.append(" ON ").append(CqlIdentifierUtil.renderName(((CreateIndexSpecification)this.spec()).getKeyspace(), ((CreateIndexSpecification)this.spec()).getTableName())).append(" (");
        if (((CreateIndexSpecification)this.spec()).getColumnFunction() != CreateIndexSpecification.ColumnFunction.NONE) {
            cql.append(((CreateIndexSpecification)this.spec()).getColumnFunction().name()).append("(").append(((CreateIndexSpecification)this.spec()).getColumnName().asCql(true)).append(")");
        } else {
            cql.append(((CreateIndexSpecification)this.spec()).getColumnName().asCql(true));
        }
        cql.append(")");
        if (StringUtils.hasText((String)((CreateIndexSpecification)this.spec()).getUsing())) {
            cql.append(" USING ").append("'").append(((CreateIndexSpecification)this.spec()).getUsing()).append("'");
        }
        if (!(options = ((CreateIndexSpecification)this.spec()).getOptions()).isEmpty()) {
            ArrayList entries = new ArrayList(options.size());
            options.forEach((key, value) -> entries.add(String.format("'%s': '%s'", CqlStringUtils.escapeSingle(key), CqlStringUtils.escapeSingle(value))));
            StringBuilder optionsCql = new StringBuilder(" WITH OPTIONS = ").append("{");
            optionsCql.append(StringUtils.collectionToDelimitedString(entries, (String)", "));
            optionsCql.append("}");
            cql.append((CharSequence)optionsCql);
        }
        cql.append(";");
        return cql;
    }
}

