/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.springframework.data.cassandra.core.cql.ReservedKeyword;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Deprecated(forRemoval=true)
public final class CqlIdentifier
implements Comparable<CqlIdentifier>,
Serializable {
    private static final long serialVersionUID = -974441606330912437L;
    public static final String UNQUOTED_REGEX = "(?i)[a-z][\\w]*";
    public static final Pattern UNQUOTED = Pattern.compile("(?i)[a-z][\\w]*");
    public static final String QUOTED_REGEX = "(?i)[a-z]([\\w]*(\"\")+[\\w]*)+";
    public static final Pattern QUOTED = Pattern.compile("(?i)[a-z]([\\w]*(\"\")+[\\w]*)+");
    private final String identifier;
    private final String unquoted;
    private final boolean quoted;

    private CqlIdentifier(CharSequence identifier) {
        this(identifier, false);
    }

    private CqlIdentifier(CharSequence identifier, boolean forceQuote) {
        Assert.notNull((Object)identifier, (String)"Identifier must not be null");
        String string = identifier.toString();
        Assert.hasText((String)string, (String)"Identifier must not be empty");
        if (forceQuote || CqlIdentifier.requiresQuoting(string)) {
            this.unquoted = string;
            this.identifier = "\"" + string + "\"";
            this.quoted = true;
        } else if (CqlIdentifier.isUnquotedIdentifier(string)) {
            this.identifier = this.unquoted = string.toLowerCase();
            this.quoted = false;
        } else {
            throw new IllegalArgumentException(String.format("given string [%s] is not a valid quoted or unquoted identifier", identifier));
        }
    }

    @Deprecated(forRemoval=true)
    public static CqlIdentifier cqlId(CharSequence identifier) {
        return new CqlIdentifier(identifier);
    }

    @Deprecated(forRemoval=true)
    public static CqlIdentifier cqlId(CharSequence identifier, boolean forceQuote) {
        return new CqlIdentifier(identifier, forceQuote);
    }

    public static CqlIdentifier of(CharSequence identifier) {
        return new CqlIdentifier(identifier);
    }

    public static CqlIdentifier of(CharSequence identifier, boolean forceQuote) {
        return new CqlIdentifier(identifier, forceQuote);
    }

    @Deprecated(forRemoval=true)
    public static CqlIdentifier quotedCqlId(CharSequence identifier) {
        return new CqlIdentifier(identifier, true);
    }

    public static CqlIdentifier quoted(CharSequence identifier) {
        return new CqlIdentifier(identifier, true);
    }

    public static boolean isUnquotedIdentifier(CharSequence chars) {
        return UNQUOTED.matcher(chars).matches() && !ReservedKeyword.isReserved(chars);
    }

    public static boolean isQuotedIdentifier(CharSequence chars) {
        return chars != null && chars.length() > 1 && chars.charAt(0) == '\"' && chars.charAt(chars.length() - 1) == '\"';
    }

    public static boolean requiresQuoting(CharSequence chars) {
        return QUOTED.matcher(chars).matches() || ReservedKeyword.isReserved(chars);
    }

    public String getUnquoted() {
        return this.unquoted;
    }

    public String toCql() {
        return this.identifier;
    }

    public StringBuilder toCql(StringBuilder builder) {
        return builder.append(this.toCql());
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    @Override
    public int compareTo(CqlIdentifier identifier) {
        int comparison = Boolean.valueOf(this.quoted).compareTo(identifier.quoted);
        return comparison != 0 ? comparison : this.identifier.compareTo(identifier.identifier);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CqlIdentifier)) {
            return false;
        }
        CqlIdentifier that = (CqlIdentifier)o;
        if (this.quoted != that.quoted) {
            return false;
        }
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + (this.quoted ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.toCql();
    }

    public com.datastax.oss.driver.api.core.CqlIdentifier toCqlIdentifier() {
        return com.datastax.oss.driver.api.core.CqlIdentifier.fromInternal((String)this.unquoted);
    }
}

