/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.ExecutionProfileResolver;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class UpdateOptions
extends WriteOptions {
    private static final UpdateOptions EMPTY = new UpdateOptionsBuilder().build();
    @Nullable
    private final Filter ifCondition;
    private final boolean ifExists;

    private UpdateOptions(@Nullable ConsistencyLevel consistencyLevel, ExecutionProfileResolver executionProfileResolver, @Nullable Filter ifCondition, boolean ifExists, @Nullable Boolean idempotent, @Nullable CqlIdentifier keyspace, @Nullable Integer pageSize, @Nullable CqlIdentifier routingKeyspace, @Nullable ByteBuffer routingKey, @Nullable ConsistencyLevel serialConsistencyLevel, Duration timeout, @Nullable Duration ttl, @Nullable Long timestamp, @Nullable Boolean tracing) {
        super(consistencyLevel, executionProfileResolver, idempotent, keyspace, pageSize, routingKeyspace, routingKey, serialConsistencyLevel, timeout, ttl, timestamp, tracing);
        this.ifCondition = ifCondition;
        this.ifExists = ifExists;
    }

    public static UpdateOptionsBuilder builder() {
        return new UpdateOptionsBuilder();
    }

    public static UpdateOptions empty() {
        return EMPTY;
    }

    @Override
    public UpdateOptionsBuilder mutate() {
        return new UpdateOptionsBuilder(this);
    }

    @Nullable
    public Filter getIfCondition() {
        return this.ifCondition;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdateOptions that = (UpdateOptions)o;
        if (this.ifExists != that.ifExists) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.ifCondition, (Object)that.ifCondition);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ifExists ? 1 : 0);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.ifCondition);
        return result;
    }

    public static class UpdateOptionsBuilder
    extends WriteOptions.WriteOptionsBuilder {
        @Nullable
        private Filter ifCondition;
        private boolean ifExists;

        private UpdateOptionsBuilder() {
        }

        private UpdateOptionsBuilder(UpdateOptions updateOptions) {
            super(updateOptions);
            this.ifCondition = updateOptions.ifCondition;
            this.ifExists = updateOptions.ifExists;
        }

        @Override
        public UpdateOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            super.consistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public UpdateOptionsBuilder executionProfile(String profileName) {
            super.executionProfile(profileName);
            return this;
        }

        @Override
        public UpdateOptionsBuilder executionProfile(ExecutionProfileResolver executionProfileResolver) {
            super.executionProfile(executionProfileResolver);
            return this;
        }

        @Override
        @Deprecated(forRemoval=true)
        public UpdateOptionsBuilder fetchSize(int fetchSize) {
            super.fetchSize(fetchSize);
            return this;
        }

        @Override
        public UpdateOptionsBuilder idempotent(boolean idempotent) {
            super.idempotent(idempotent);
            return this;
        }

        @Override
        public UpdateOptionsBuilder keyspace(CqlIdentifier keyspace) {
            super.keyspace(keyspace);
            return this;
        }

        @Override
        public UpdateOptionsBuilder pageSize(int pageSize) {
            super.pageSize(pageSize);
            return this;
        }

        @Override
        @Deprecated(forRemoval=true)
        public UpdateOptionsBuilder readTimeout(long readTimeout) {
            super.readTimeout(readTimeout);
            return this;
        }

        @Override
        @Deprecated(forRemoval=true)
        public UpdateOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            super.readTimeout(readTimeout, timeUnit);
            return this;
        }

        @Override
        public UpdateOptionsBuilder routingKeyspace(CqlIdentifier routingKeyspace) {
            super.routingKeyspace(routingKeyspace);
            return this;
        }

        @Override
        public UpdateOptionsBuilder routingKey(ByteBuffer routingKey) {
            super.routingKey(routingKey);
            return this;
        }

        @Override
        public UpdateOptionsBuilder serialConsistencyLevel(ConsistencyLevel consistencyLevel) {
            super.serialConsistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public UpdateOptionsBuilder timeout(Duration timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public UpdateOptionsBuilder ttl(Duration ttl) {
            super.ttl(ttl);
            return this;
        }

        @Override
        public UpdateOptionsBuilder tracing(boolean tracing) {
            super.tracing(tracing);
            return this;
        }

        @Override
        public UpdateOptionsBuilder withTracing() {
            super.withTracing();
            return this;
        }

        @Override
        public UpdateOptionsBuilder ttl(int ttl) {
            super.ttl(ttl);
            return this;
        }

        @Override
        public UpdateOptionsBuilder timestamp(long timestamp) {
            super.timestamp(timestamp);
            return this;
        }

        @Override
        public UpdateOptionsBuilder timestamp(Instant timestamp) {
            super.timestamp(timestamp);
            return this;
        }

        public UpdateOptionsBuilder ifCondition(CriteriaDefinition criteria) {
            Assert.notNull((Object)criteria, (String)"CriteriaDefinition must not be null");
            return this.ifCondition(Filter.from(criteria));
        }

        public UpdateOptionsBuilder ifCondition(Filter condition) {
            Assert.notNull((Object)condition, (String)"Filter condition must not be null");
            this.ifCondition = condition;
            this.ifExists = false;
            return this;
        }

        public UpdateOptionsBuilder withIfExists() {
            return this.ifExists(true);
        }

        public UpdateOptionsBuilder ifExists(boolean ifNotExists) {
            this.ifExists = ifNotExists;
            this.ifCondition = null;
            return this;
        }

        @Override
        public UpdateOptions build() {
            return new UpdateOptions(this.consistencyLevel, this.executionProfileResolver, this.ifCondition, this.ifExists, this.idempotent, this.keyspace, this.pageSize, this.routingKeyspace, this.routingKey, this.serialConsistencyLevel, this.timeout, this.ttl, this.timestamp, this.tracing);
        }
    }
}

