/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.data.cassandra.core.CassandraBatchOperations;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.DeleteOptions;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.convert.EntityWriter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class CassandraBatchTemplate
implements CassandraBatchOperations {
    private final AtomicBoolean executed = new AtomicBoolean();
    private final BatchStatementBuilder batch;
    private final CassandraConverter converter;
    private final CassandraMappingContext mappingContext;
    private final CassandraOperations operations;
    private final StatementFactory statementFactory;
    private QueryOptions options = QueryOptions.empty();

    CassandraBatchTemplate(CassandraTemplate operations, BatchType batchType) {
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        Assert.notNull((Object)batchType, (String)"BatchType must not be null");
        this.operations = operations;
        this.batch = BatchStatement.builder((BatchType)batchType);
        this.converter = operations.getConverter();
        this.mappingContext = this.converter.getMappingContext();
        this.statementFactory = operations.getStatementFactory();
    }

    protected CassandraConverter getConverter() {
        return this.converter;
    }

    protected CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    @Override
    public WriteResult execute() {
        if (this.executed.compareAndSet(false, true)) {
            BatchStatement statement = QueryOptionsUtil.addQueryOptions(this.batch.build(), this.options);
            return WriteResult.of(this.operations.getCqlOperations().queryForResultSet((Statement<?>)statement));
        }
        throw new IllegalStateException("This Cassandra Batch was already executed");
    }

    @Override
    public CassandraBatchOperations withTimestamp(long timestamp) {
        this.assertNotExecuted();
        this.batch.setQueryTimestamp(timestamp);
        return this;
    }

    @Override
    public CassandraBatchOperations withQueryOptions(QueryOptions options) {
        this.assertNotExecuted();
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        this.options = options;
        return this;
    }

    @Override
    public CassandraBatchOperations addStatement(BatchableStatement<?> statement) {
        this.assertNotExecuted();
        Assert.notNull(statement, (String)"Statement must not be null");
        this.batch.addStatement(statement);
        return this;
    }

    @Override
    public CassandraBatchOperations addStatements(BatchableStatement<?> ... statements) {
        this.assertNotExecuted();
        Assert.notNull(statements, (String)"Statements must not be null");
        this.batch.addStatements(statements);
        return this;
    }

    @Override
    public CassandraBatchOperations addStatements(Iterable<? extends BatchableStatement<?>> statements) {
        this.assertNotExecuted();
        Assert.notNull(statements, (String)"Statements must not be null");
        this.batch.addStatements(statements);
        return this;
    }

    @Override
    public CassandraBatchOperations insert(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.insert(Arrays.asList(entities));
    }

    @Override
    public CassandraBatchOperations insert(Iterable<?> entities) {
        return this.insert(entities, (WriteOptions)InsertOptions.empty());
    }

    @Override
    public CassandraBatchOperations insert(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        CassandraBatchTemplate.assertNotStatement("insert", entities);
        CassandraMappingContext mappingContext = this.getMappingContext();
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            CassandraBatchTemplate.assertNotStatement("insert", entity);
            CassandraBatchTemplate.assertNotQueryOptions(entity);
            BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)mappingContext.getRequiredPersistentEntity(entity.getClass());
            SimpleStatement insertQuery = this.getStatementFactory().insert(entity, options, persistentEntity, persistentEntity.getTableName()).build();
            this.addStatement((BatchableStatement<?>)insertQuery);
        }
        return this;
    }

    @Override
    public CassandraBatchOperations update(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.update(Arrays.asList(entities));
    }

    @Override
    public CassandraBatchOperations update(Iterable<?> entities) {
        return this.update(entities, (WriteOptions)UpdateOptions.empty());
    }

    @Override
    public CassandraBatchOperations update(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            CassandraBatchTemplate.assertNotStatement("update", entity);
            CassandraBatchTemplate.assertNotQueryOptions(entity);
            CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
            SimpleStatement update = this.getStatementFactory().update(entity, options, persistentEntity, persistentEntity.getTableName()).build();
            this.addStatement((BatchableStatement<?>)update);
        }
        return this;
    }

    @Override
    public CassandraBatchOperations delete(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.delete(Arrays.asList(entities));
    }

    @Override
    public CassandraBatchOperations delete(Iterable<?> entities) {
        return this.delete(entities, (WriteOptions)DeleteOptions.empty());
    }

    @Override
    public CassandraBatchOperations delete(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            CassandraBatchTemplate.assertNotStatement("delete", entity);
            CassandraBatchTemplate.assertNotQueryOptions(entity);
            CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
            SimpleStatement delete = this.getStatementFactory().delete(entity, options, (EntityWriter<Object, Object>)this.getConverter(), persistentEntity.getTableName()).build();
            this.addStatement((BatchableStatement<?>)delete);
        }
        return this;
    }

    private void assertNotExecuted() {
        Assert.state((!this.executed.get() ? 1 : 0) != 0, (String)"This Cassandra Batch was already executed");
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entityType));
    }

    private static void assertNotQueryOptions(Object o) {
        if (o instanceof QueryOptions) {
            throw new IllegalArgumentException(String.format("%s must not be used as entity; Please make sure to call the appropriate method accepting %s", ClassUtils.getDescriptiveType((Object)o), ClassUtils.getShortName(o.getClass())));
        }
    }

    private static void assertNotStatement(String operation, Object o) {
        if (o instanceof Statement) {
            throw new IllegalArgumentException(String.format("%s cannot use a Statement: %s. Use only entities for %s", StringUtils.capitalize((String)operation), ClassUtils.getDescriptiveType((Object)o), operation));
        }
    }
}

