/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import java.util.regex.Pattern;

public enum CqlConstantType {
    STRING(Regex.STRING_PATTERN),
    INTEGER(Regex.INTEGER_PATTERN),
    FLOAT(Regex.FLOAT_PATTERN),
    BOOLEAN(Regex.BOOLEAN_PATTERN),
    UUID(Regex.UUID_PATTERN),
    BLOB(Regex.BLOB_PATTERN);

    private Pattern pattern;

    private CqlConstantType(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean matches(CharSequence candidate) {
        return this.pattern.matcher(candidate).matches();
    }

    public static class Regex {
        public static final String STRING_REGEX = "'((?:[^']+|'')*)'";
        public static final Pattern STRING_PATTERN = Pattern.compile("'((?:[^']+|'')*)'");
        public static final String INTEGER_REGEX = "\\-?[0-9]+";
        public static final Pattern INTEGER_PATTERN = Pattern.compile("\\-?[0-9]+");
        public static final String FLOAT_REGEX = "(\\-?[0-9]+(\\.[0-9]*)?([eE][+-]?[0-9+])?)|NaN|Infinity";
        public static final Pattern FLOAT_PATTERN = Pattern.compile("(\\-?[0-9]+(\\.[0-9]*)?([eE][+-]?[0-9+])?)|NaN|Infinity");
        public static final String BOOLEAN_REGEX = "(?i)true|false";
        public static final Pattern BOOLEAN_PATTERN = Pattern.compile("(?i)true|false");
        public static final String UUID_REGEX = "(?i)[0-9a-f]{8}+\\-[0-9a-f]{4}+\\-[0-9a-f]{4}+\\-[0-9a-f]{4}+\\-[0-9a-f]{12}+";
        public static final Pattern UUID_PATTERN = Pattern.compile("(?i)[0-9a-f]{8}+\\-[0-9a-f]{4}+\\-[0-9a-f]{4}+\\-[0-9a-f]{4}+\\-[0-9a-f]{12}+");
        public static final String BLOB_REGEX = "(?i)0[x](0-9a-f)+";
        public static final Pattern BLOB_PATTERN = Pattern.compile("(?i)0[x](0-9a-f)+");
    }
}

