/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BasicMapId
implements MapId {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public BasicMapId() {
    }

    public BasicMapId(Map<String, Object> map) {
        Assert.notNull(map, (String)"Map must not be null");
        this.map.putAll(map);
    }

    public static MapId id() {
        return new BasicMapId();
    }

    public static MapId id(String name, Object value) {
        return new BasicMapId().with(name, value);
    }

    public static MapId id(MapId id) {
        return new BasicMapId(id);
    }

    @Override
    public BasicMapId with(String name, @Nullable Object value) {
        this.put(name, value);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object name) {
        return this.map.containsKey(name);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(@Nullable Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof Map)) {
            return false;
        }
        return this.map.equals(that);
    }

    @Override
    public Object get(Object name) {
        return this.map.get(name);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(String name, Object value) {
        return this.map.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> source) {
        this.map.putAll(source);
    }

    @Override
    public Object remove(Object name) {
        return this.map.remove(name);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{ ");
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(entry.getKey()).append(" : ").append(entry.getValue());
        }
        return s.append(" }").toString();
    }
}

