/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.aot;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.Arrays;
import java.util.List;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.DecoratingProxy;
import org.springframework.data.cassandra.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.cassandra.core.mapping.event.ReactiveBeforeConvertCallback;
import org.springframework.data.cassandra.core.mapping.event.ReactiveBeforeSaveCallback;
import org.springframework.data.cassandra.observability.CassandraObservationSupplier;
import org.springframework.data.cassandra.repository.support.SimpleCassandraRepository;
import org.springframework.data.cassandra.repository.support.SimpleReactiveCassandraRepository;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class CassandraRuntimeHints
implements RuntimeHintsRegistrar {
    private static final boolean PROJECT_REACTOR_PRESENT = ReactiveWrappers.isAvailable((ReactiveWrappers.ReactiveLibrary)ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR);
    private static final boolean OBSERVABILITY_PRESENT = ClassUtils.isPresent((String)"io.micrometer.observation.ObservationRegistry", (ClassLoader)CassandraRuntimeHints.class.getClassLoader());

    CassandraRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        hints.reflection().registerTypes(Arrays.asList(TypeReference.of(SimpleCassandraRepository.class), TypeReference.of(BeforeConvertCallback.class), TypeReference.of(BeforeSaveCallback.class)), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        if (PROJECT_REACTOR_PRESENT) {
            hints.reflection().registerTypes(Arrays.asList(TypeReference.of(SimpleReactiveCassandraRepository.class), TypeReference.of(ReactiveBeforeConvertCallback.class), TypeReference.of(ReactiveBeforeSaveCallback.class)), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        }
        if (OBSERVABILITY_PRESENT) {
            Class<?> observationDecorated;
            List<Class> statementInterfaces = Arrays.asList(BatchStatement.class, PreparedStatement.class, BoundStatement.class, SimpleStatement.class, Statement.class);
            hints.reflection().registerTypes(statementInterfaces.stream().map(TypeReference::of).toList(), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS}));
            hints.reflection().registerTypes(List.of(TypeReference.of(CassandraObservationSupplier.class)), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
            for (Class statementInterface : statementInterfaces) {
                hints.proxies().registerJdkProxy(new Class[]{statementInterface, CassandraObservationSupplier.class, SpringProxy.class, Advised.class, DecoratingProxy.class});
            }
            hints.proxies().registerJdkProxy(new Class[]{CqlSession.class, SpringProxy.class, Advised.class, DecoratingProxy.class});
            try {
                observationDecorated = Class.forName("org.springframework.data.cassandra.observability.CqlSessionObservationInterceptor.ObservationDecoratedProxy", false, classLoader);
            }
            catch (Exception e) {
                observationDecorated = null;
            }
            if (observationDecorated != null) {
                hints.proxies().registerJdkProxy(new Class[]{CqlSession.class, SpringProxy.class, Advised.class, DecoratingProxy.class, observationDecorated});
            }
        }
    }
}

