/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.ReactivePartTreeCassandraQuery;
import org.springframework.data.cassandra.repository.query.ReactiveStringBasedCassandraQuery;
import org.springframework.data.cassandra.repository.support.CachingExpressionParser;
import org.springframework.data.cassandra.repository.support.MappingCassandraEntityInformation;
import org.springframework.data.cassandra.repository.support.SimpleReactiveCassandraRepository;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReactiveCassandraRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final ReactiveCassandraOperations operations;
    private final MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext;

    public ReactiveCassandraRepositoryFactory(ReactiveCassandraOperations cassandraOperations) {
        Assert.notNull((Object)cassandraOperations, (String)"ReactiveCassandraOperations must not be null");
        this.operations = cassandraOperations;
        this.mappingContext = cassandraOperations.getConverter().getMappingContext();
        this.setEvaluationContextProvider((QueryMethodEvaluationContextProvider)ReactiveQueryMethodEvaluationContextProvider.DEFAULT);
    }

    protected ProjectionFactory getProjectionFactory(ClassLoader classLoader, BeanFactory beanFactory) {
        return this.operations.getConverter().getProjectionFactory();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleReactiveCassandraRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new CassandraQueryLookupStrategy(this.operations, (ReactiveQueryMethodEvaluationContextProvider)evaluationContextProvider, this.mappingContext));
    }

    public <T, ID> CassandraEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingCassandraEntityInformation(entity, this.operations.getConverter());
    }

    static /* synthetic */ SpelExpressionParser access$000() {
        return EXPRESSION_PARSER;
    }

    private static class CassandraQueryLookupStrategy
    implements QueryLookupStrategy {
        private final ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider;
        private final ReactiveCassandraOperations operations;
        private final MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext;
        private final ExpressionParser expressionParser = new CachingExpressionParser((ExpressionParser)ReactiveCassandraRepositoryFactory.access$000());

        CassandraQueryLookupStrategy(ReactiveCassandraOperations operations, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext) {
            this.evaluationContextProvider = evaluationContextProvider;
            this.operations = operations;
            this.mappingContext = mappingContext;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            ReactiveCassandraQueryMethod queryMethod = new ReactiveCassandraQueryMethod(method, metadata, factory, this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new ReactiveStringBasedCassandraQuery(namedQuery, queryMethod, this.operations, this.expressionParser, this.evaluationContextProvider);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new ReactiveStringBasedCassandraQuery(queryMethod, this.operations, this.expressionParser, this.evaluationContextProvider);
            }
            return new ReactivePartTreeCassandraQuery(queryMethod, this.operations);
        }
    }
}

