/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Criteria;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ConvertingParameterAccessor;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

class CassandraQueryCreator
extends AbstractQueryCreator<Query, Filter> {
    private static final Log LOG = LogFactory.getLog(CassandraQueryCreator.class);
    private final MappingContext<?, CassandraPersistentProperty> mappingContext;
    private final QueryBuilder queryBuilder = new QueryBuilder();

    public CassandraQueryCreator(PartTree tree, CassandraParameterAccessor parameterAccessor, MappingContext<?, CassandraPersistentProperty> mappingContext) {
        super(tree, (ParameterAccessor)parameterAccessor);
        Assert.notNull(mappingContext, (String)"CassandraMappingContext must not be null");
        this.mappingContext = mappingContext;
    }

    protected MappingContext<?, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    protected Filter create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.getMappingContext().getPersistentPropertyPath(part.getProperty());
        CassandraPersistentProperty property = (CassandraPersistentProperty)path.getLeafProperty();
        Assert.state((property != null && path.toDotPath() != null ? 1 : 0) != 0, (String)"Leaf property must not be null");
        Object filterOrCriteria = this.from(part, property, Criteria.where(path.toDotPath()), (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
        if (filterOrCriteria instanceof CriteriaDefinition) {
            return Filter.from((CriteriaDefinition)filterOrCriteria);
        }
        return (Filter)filterOrCriteria;
    }

    protected Filter and(Part part, Filter base, Iterator<Object> iterator) {
        Iterator<CriteriaDefinition> iterator2 = base.iterator();
        while (iterator2.hasNext()) {
            CriteriaDefinition criterion = iterator2.next();
            this.getQueryBuilder().and(criterion);
        }
        return this.create(part, (Iterator)iterator);
    }

    protected Filter or(Filter base, Filter criteria) {
        throw new InvalidDataAccessApiUsageException("Cassandra does not support an OR operator");
    }

    protected Query complete(Filter criteria, Sort sort) {
        if (criteria != null) {
            Iterator<CriteriaDefinition> iterator = criteria.iterator();
            while (iterator.hasNext()) {
                CriteriaDefinition criterion = iterator.next();
                this.getQueryBuilder().and(criterion);
            }
        }
        Query query2 = this.getQueryBuilder().create(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Created query [%s]", query2));
        }
        return query2;
    }

    private Object from(Part part, CassandraPersistentProperty property, Criteria where, ConvertingParameterAccessor.PotentiallyConvertingIterator parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return where.gt(parameters.nextConverted(property));
            }
            case GREATER_THAN_EQUAL: {
                return where.gte(parameters.nextConverted(property));
            }
            case BEFORE: 
            case LESS_THAN: {
                return where.lt(parameters.nextConverted(property));
            }
            case LESS_THAN_EQUAL: {
                return where.lte(parameters.nextConverted(property));
            }
            case BETWEEN: {
                return CassandraQueryCreator.computeBetweenPart(where, parameters);
            }
            case IN: {
                return where.in(this.nextAsArray(property, parameters));
            }
            case LIKE: 
            case STARTING_WITH: 
            case ENDING_WITH: {
                return where.like(this.like(type, parameters.nextConverted(property)));
            }
            case CONTAINING: {
                return this.containing(where, property, parameters.nextConverted(property));
            }
            case TRUE: {
                return where.is(true);
            }
            case FALSE: {
                return where.is(false);
            }
            case SIMPLE_PROPERTY: {
                return where.is(parameters.nextConverted(property));
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Unsupported keyword [%s] in part [%s]", type, part));
    }

    private static Filter computeBetweenPart(Criteria where, Iterator<Object> parameters) {
        Object value = parameters.next();
        if (!(value instanceof Range)) {
            return Filter.from(Criteria.where(where.getColumnName()).gt(value), Criteria.where(where.getColumnName()).lt(parameters.next()));
        }
        Range range = (Range)value;
        ArrayList criteria = new ArrayList();
        Optional min = range.getLowerBound().getValue();
        Optional max = range.getUpperBound().getValue();
        min.ifPresent(it -> {
            if (range.getLowerBound().isInclusive()) {
                criteria.add(Criteria.where(where.getColumnName()).gte(it));
            } else {
                criteria.add(Criteria.where(where.getColumnName()).gt(it));
            }
        });
        max.ifPresent(it -> {
            if (range.getUpperBound().isInclusive()) {
                criteria.add(Criteria.where(where.getColumnName()).lte(it));
            } else {
                criteria.add(Criteria.where(where.getColumnName()).lt(it));
            }
        });
        return Filter.from(criteria);
    }

    private CriteriaDefinition containing(Criteria where, CassandraPersistentProperty property, Object bindableValue) {
        if (property.isCollectionLike() || property.isMapLike()) {
            return where.contains(bindableValue);
        }
        return where.like(this.like(Part.Type.CONTAINING, bindableValue));
    }

    private Object like(Part.Type type, Object value) {
        switch (type) {
            case LIKE: {
                return value;
            }
            case CONTAINING: {
                return "%" + value + "%";
            }
            case STARTING_WITH: {
                return value + "%";
            }
            case ENDING_WITH: {
                return "%" + value;
            }
        }
        throw new IllegalArgumentException(String.format("Part Type [%s] not supported with like queries", type));
    }

    private Object[] nextAsArray(CassandraPersistentProperty property, ConvertingParameterAccessor.PotentiallyConvertingIterator iterator) {
        Object next = iterator.nextConverted(property);
        if (next instanceof Collection) {
            return ((Collection)next).toArray();
        }
        if (next.getClass().isArray()) {
            return (Object[])next;
        }
        return new Object[]{next};
    }

    static class QueryBuilder {
        private List<CriteriaDefinition> criterias = new ArrayList<CriteriaDefinition>();

        QueryBuilder() {
        }

        CriteriaDefinition and(CriteriaDefinition clause) {
            this.criterias.add(clause);
            return clause;
        }

        Query create(Sort sort) {
            Query query2 = Query.query(this.criterias);
            return query2.sort(sort);
        }
    }
}

