/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.ExecutionProfileResolver;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class WriteOptions
extends QueryOptions {
    private static final WriteOptions EMPTY = new WriteOptionsBuilder().build();
    private final Duration ttl;
    @Nullable
    private final Long timestamp;

    protected WriteOptions(@Nullable ConsistencyLevel consistencyLevel, ExecutionProfileResolver executionProfileResolver, @Nullable Boolean idempotent, @Nullable CqlIdentifier keyspace, @Nullable Integer pageSize, @Nullable CqlIdentifier routingKeyspace, @Nullable ByteBuffer routingKey, @Nullable ConsistencyLevel serialConsistencyLevel, Duration timeout, Duration ttl, @Nullable Long timestamp, @Nullable Boolean tracing) {
        super(consistencyLevel, executionProfileResolver, idempotent, keyspace, pageSize, routingKeyspace, routingKey, serialConsistencyLevel, timeout, tracing);
        this.ttl = ttl;
        this.timestamp = timestamp;
    }

    public static WriteOptions empty() {
        return EMPTY;
    }

    public static WriteOptionsBuilder builder() {
        return new WriteOptionsBuilder();
    }

    @Override
    public WriteOptionsBuilder mutate() {
        return new WriteOptionsBuilder(this);
    }

    public Duration getTtl() {
        return this.ttl;
    }

    @Nullable
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WriteOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WriteOptions that = (WriteOptions)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.ttl, (Object)that.ttl)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.timestamp, (Object)that.timestamp);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.ttl);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.timestamp);
        return result;
    }

    public static class WriteOptionsBuilder
    extends QueryOptions.QueryOptionsBuilder {
        protected Duration ttl = Duration.ofMillis(-1L);
        protected Long timestamp = null;

        protected WriteOptionsBuilder() {
        }

        protected WriteOptionsBuilder(WriteOptions writeOptions) {
            super(writeOptions);
            this.ttl = writeOptions.ttl;
            this.timestamp = writeOptions.timestamp;
        }

        @Override
        public WriteOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            super.consistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public WriteOptionsBuilder executionProfile(String profileName) {
            super.executionProfile(profileName);
            return this;
        }

        @Override
        public WriteOptionsBuilder executionProfile(ExecutionProfileResolver executionProfileResolver) {
            super.executionProfile(executionProfileResolver);
            return this;
        }

        @Override
        @Deprecated
        public WriteOptionsBuilder fetchSize(int pageSize) {
            super.fetchSize(pageSize);
            return this;
        }

        @Override
        public WriteOptionsBuilder idempotent(boolean idempotent) {
            super.idempotent(idempotent);
            return this;
        }

        @Override
        public WriteOptionsBuilder keyspace(CqlIdentifier keyspace) {
            super.keyspace(keyspace);
            return this;
        }

        @Override
        public WriteOptionsBuilder pageSize(int pageSize) {
            super.pageSize(pageSize);
            return this;
        }

        @Override
        @Deprecated
        public WriteOptionsBuilder readTimeout(long readTimeout) {
            super.readTimeout(readTimeout);
            return this;
        }

        @Override
        @Deprecated
        public WriteOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            super.readTimeout(readTimeout, timeUnit);
            return this;
        }

        @Override
        public WriteOptionsBuilder routingKeyspace(CqlIdentifier routingKeyspace) {
            super.routingKeyspace(routingKeyspace);
            return this;
        }

        @Override
        public WriteOptionsBuilder routingKey(ByteBuffer routingKey) {
            super.routingKey(routingKey);
            return this;
        }

        @Override
        public WriteOptionsBuilder serialConsistencyLevel(ConsistencyLevel consistencyLevel) {
            super.serialConsistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public WriteOptionsBuilder timeout(Duration timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public WriteOptionsBuilder tracing(boolean tracing) {
            super.tracing(tracing);
            return this;
        }

        @Override
        public WriteOptionsBuilder withTracing() {
            super.withTracing();
            return this;
        }

        public WriteOptionsBuilder ttl(int ttl) {
            return this.ttl(Duration.ofSeconds(ttl));
        }

        public WriteOptionsBuilder ttl(Duration ttl) {
            Assert.notNull((Object)ttl, (String)"TTL must not be null");
            Assert.isTrue((!ttl.isNegative() ? 1 : 0) != 0, (String)"TTL must be greater than equal to zero");
            this.ttl = ttl;
            return this;
        }

        public WriteOptionsBuilder timestamp(long timestamp) {
            Assert.isTrue((timestamp >= 0L ? 1 : 0) != 0, (String)"Timestamp must be greater than equal to zero");
            this.timestamp = timestamp;
            return this;
        }

        public WriteOptionsBuilder timestamp(Instant timestamp) {
            Assert.notNull((Object)timestamp, (String)"Timestamp must not be null");
            this.timestamp = TimeUnit.MILLISECONDS.toMicros(timestamp.toEpochMilli());
            return this;
        }

        @Override
        public WriteOptions build() {
            return new WriteOptions(this.consistencyLevel, this.executionProfileResolver, this.idempotent, this.keyspace, this.pageSize, this.routingKeyspace, this.routingKey, this.serialConsistencyLevel, this.timeout, this.ttl, this.timestamp, this.tracing);
        }
    }
}

