/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.ArgumentPreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.CassandraExceptionTranslator;
import org.springframework.data.cassandra.core.cql.ColumnMapRowMapper;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.data.cassandra.core.cql.ExecutionProfileResolver;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.SingleColumnRowMapper;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CqlExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();
    private ExecutionProfileResolver executionProfileResolver = ExecutionProfileResolver.none();
    @Nullable
    private CqlIdentifier keyspace;
    private int pageSize = -1;
    @Nullable
    private ConsistencyLevel consistencyLevel;
    @Nullable
    private ConsistencyLevel serialConsistencyLevel;
    @Nullable
    private SessionFactory sessionFactory;

    public void afterPropertiesSet() {
        Assert.state((this.sessionFactory != null ? 1 : 0) != 0, (String)"SessionFactory must not be null");
    }

    public void setConsistencyLevel(@Nullable ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    @Nullable
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setExceptionTranslator(CqlExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)exceptionTranslator, (String)"CQLExceptionTranslator must not be null");
        this.exceptionTranslator = exceptionTranslator;
    }

    public CqlExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void setExecutionProfile(String profileName) {
        this.setExecutionProfileResolver(ExecutionProfileResolver.from(profileName));
    }

    public void setExecutionProfileResolver(ExecutionProfileResolver executionProfileResolver) {
        Assert.notNull((Object)executionProfileResolver, (String)"ExecutionProfileResolver must not be null");
        this.executionProfileResolver = executionProfileResolver;
    }

    public ExecutionProfileResolver getExecutionProfileResolver() {
        return this.executionProfileResolver;
    }

    @Deprecated
    public void setFetchSize(int fetchSize) {
        this.setPageSize(fetchSize);
    }

    @Deprecated
    public int getFetchSize() {
        return this.getPageSize();
    }

    public void setKeyspace(CqlIdentifier keyspace) {
        Assert.notNull((Object)keyspace, (String)"Keyspace must not be null");
        this.keyspace = keyspace;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    public void setPageSize(int fetchSize) {
        this.pageSize = fetchSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setSerialConsistencyLevel(@Nullable ConsistencyLevel consistencyLevel) {
        this.serialConsistencyLevel = consistencyLevel;
    }

    @Nullable
    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistencyLevel;
    }

    public void setSession(CqlSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.setSessionFactory(new DefaultSessionFactory(session));
    }

    @Deprecated
    public CqlSession getSession() {
        Assert.state((this.getSessionFactory() != null ? 1 : 0) != 0, (String)"SessionFactory was not properly initialized");
        return this.getSessionFactory().getSession();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    @Nullable
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected SimpleStatement newStatement(String cql) {
        return SimpleStatement.newInstance((String)cql);
    }

    protected Statement<?> applyStatementSettings(Statement<?> statement) {
        BatchStatement statementToUse = statement;
        ConsistencyLevel consistencyLevel = this.getConsistencyLevel();
        ConsistencyLevel serialConsistencyLevel = this.getSerialConsistencyLevel();
        CqlIdentifier keyspace = this.getKeyspace();
        int pageSize = this.getPageSize();
        if (consistencyLevel != null) {
            statementToUse = statementToUse.setConsistencyLevel(consistencyLevel);
        }
        if (serialConsistencyLevel != null) {
            statementToUse = statementToUse.setSerialConsistencyLevel(serialConsistencyLevel);
        }
        if (pageSize > -1) {
            statementToUse = statementToUse.setPageSize(pageSize);
        }
        if (keyspace != null) {
            if (statementToUse instanceof BatchStatement) {
                statementToUse = ((BatchStatement)statementToUse).setKeyspace(keyspace);
            }
            if (statementToUse instanceof SimpleStatement) {
                statementToUse = ((SimpleStatement)statementToUse).setKeyspace(keyspace);
            }
        }
        statementToUse = this.getExecutionProfileResolver().apply((Statement<?>)statementToUse);
        return statementToUse;
    }

    @Nullable
    protected DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        Assert.notNull((Object)ex, (String)"RuntimeException must not be null");
        return this.getExceptionTranslator().translateExceptionIfPossible(ex);
    }

    protected DataAccessException translate(String task, @Nullable String cql, RuntimeException ex) {
        Assert.notNull((Object)ex, (String)"RuntimeException must not be null");
        return this.getExceptionTranslator().translate(task, cql, ex);
    }

    protected PreparedStatementBinder newPreparedStatementBinder(Object[] args) {
        return new ArgumentPreparedStatementBinder(args);
    }

    protected RowMapper<Map<String, Object>> newColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected <T> RowMapper<T> newSingleColumnRowMapper(Class<T> requiredType) {
        return SingleColumnRowMapper.newInstance(requiredType);
    }

    @Nullable
    protected static String toCql(@Nullable Object cqlProvider) {
        return QueryExtractorDelegate.getCql(cqlProvider);
    }
}

