/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.ReactiveInsertOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class ReactiveInsertOperationSupport
implements ReactiveInsertOperation {
    private final ReactiveCassandraTemplate template;

    public ReactiveInsertOperationSupport(ReactiveCassandraTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveInsertOperation.ReactiveInsert<T> insert(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveInsertSupport<T>(this.template, domainType, InsertOptions.empty(), null);
    }

    static class ReactiveInsertSupport<T>
    implements ReactiveInsertOperation.ReactiveInsert<T> {
        private final ReactiveCassandraTemplate template;
        private final Class<T> domainType;
        private final InsertOptions insertOptions;
        @Nullable
        private final CqlIdentifier tableName;

        public ReactiveInsertSupport(ReactiveCassandraTemplate template, Class<T> domainType, InsertOptions insertOptions, CqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.insertOptions = insertOptions;
            this.tableName = tableName;
        }

        @Override
        public ReactiveInsertOperation.InsertWithOptions<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveInsertSupport<T>(this.template, this.domainType, this.insertOptions, tableName);
        }

        @Override
        public ReactiveInsertOperation.TerminatingInsert<T> withOptions(InsertOptions insertOptions) {
            Assert.notNull((Object)insertOptions, (String)"InsertOptions must not be null");
            return new ReactiveInsertSupport<T>(this.template, this.domainType, insertOptions, this.tableName);
        }

        @Override
        public Mono<EntityWriteResult<T>> one(T object) {
            Assert.notNull(object, (String)"Object must not be null");
            return this.template.doInsert(object, this.insertOptions, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

