/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.convert.AbstractCassandraConverter;
import org.springframework.data.cassandra.core.convert.AnnotatedCassandraConstructorProperty;
import org.springframework.data.cassandra.core.convert.CassandraColumnType;
import org.springframework.data.cassandra.core.convert.CassandraConstructorProperty;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.convert.ColumnType;
import org.springframework.data.cassandra.core.convert.ColumnTypeResolver;
import org.springframework.data.cassandra.core.convert.DefaultColumnTypeResolver;
import org.springframework.data.cassandra.core.convert.RowReaderPropertyAccessor;
import org.springframework.data.cassandra.core.convert.RowValueProvider;
import org.springframework.data.cassandra.core.convert.TupleValueProvider;
import org.springframework.data.cassandra.core.convert.UdtValueProvider;
import org.springframework.data.cassandra.core.convert.Where;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.BasicMapId;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.Column;
import org.springframework.data.cassandra.core.mapping.Element;
import org.springframework.data.cassandra.core.mapping.Embedded;
import org.springframework.data.cassandra.core.mapping.EmbeddedEntityOperations;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.data.cassandra.core.mapping.MapIdentifiable;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MappingCassandraConverter
extends AbstractCassandraConverter
implements ApplicationContextAware,
BeanClassLoaderAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CassandraMappingContext mappingContext;
    private CodecRegistry codecRegistry;
    @Nullable
    private UserTypeResolver userTypeResolver;
    @Nullable
    private ClassLoader beanClassLoader;
    private SpELContext spELContext;
    private final DefaultColumnTypeResolver cassandraTypeResolver;
    private final EmbeddedEntityOperations embeddedEntityOperations;

    public MappingCassandraConverter() {
        super(MappingCassandraConverter.newConversionService());
        CassandraCustomConversions conversions = new CassandraCustomConversions(Collections.emptyList());
        this.mappingContext = MappingCassandraConverter.newDefaultMappingContext(conversions);
        this.codecRegistry = this.mappingContext.getCodecRegistry();
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
        this.cassandraTypeResolver = new DefaultColumnTypeResolver((MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty>)this.mappingContext, userTypeName -> this.getUserTypeResolver().resolveType(userTypeName), this::getCodecRegistry, this::getCustomConversions);
        this.setCustomConversions(conversions);
        this.embeddedEntityOperations = new EmbeddedEntityOperations((MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)this.mappingContext);
    }

    public MappingCassandraConverter(CassandraMappingContext mappingContext) {
        super(MappingCassandraConverter.newConversionService());
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        this.mappingContext = mappingContext;
        this.codecRegistry = mappingContext.getCodecRegistry();
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
        this.cassandraTypeResolver = new DefaultColumnTypeResolver((MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty>)mappingContext, userTypeName -> this.getUserTypeResolver().resolveType(userTypeName), this::getCodecRegistry, this::getCustomConversions);
        this.setCustomConversions(mappingContext.getCustomConversions());
        this.embeddedEntityOperations = new EmbeddedEntityOperations((MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)mappingContext);
    }

    protected ConversionContext getConversionContext() {
        return new ConversionContext(this.getCustomConversions(), this::doReadRow, this::doReadTupleValue, this::doReadUdtValue, this::readCollectionOrArray, this::readMap, this::getPotentiallyConvertedSimpleRead);
    }

    private static ConversionService newConversionService() {
        return new DefaultConversionService();
    }

    private static CassandraMappingContext newDefaultMappingContext(CassandraCustomConversions conversions) {
        CassandraMappingContext mappingContext = new CassandraMappingContext();
        mappingContext.setCustomConversions(conversions);
        mappingContext.afterPropertiesSet();
        return mappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    private TypeCodec<Object> getCodec(CassandraPersistentProperty property) {
        return this.getCodecRegistry().codecFor(this.cassandraTypeResolver.resolve(property).getDataType());
    }

    public void setCodecRegistry(CodecRegistry codecRegistry) {
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        this.codecRegistry = codecRegistry;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        if (this.codecRegistry == null) {
            return this.mappingContext.getCodecRegistry();
        }
        return this.codecRegistry;
    }

    public void setUserTypeResolver(UserTypeResolver userTypeResolver) {
        Assert.notNull((Object)userTypeResolver, (String)"UserTypeResolver must not be null");
        this.userTypeResolver = userTypeResolver;
    }

    public UserTypeResolver getUserTypeResolver() {
        if (this.userTypeResolver == null) {
            return this.mappingContext.getUserTypeResolver();
        }
        return this.userTypeResolver;
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public ColumnTypeResolver getColumnTypeResolver() {
        return this.cassandraTypeResolver;
    }

    private <S> ConvertingPropertyAccessor<S> newConvertingPropertyAccessor(S source, CassandraPersistentEntity<?> entity) {
        PersistentPropertyAccessor propertyAccessor = source instanceof PersistentPropertyAccessor ? (PersistentPropertyAccessor)source : entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(propertyAccessor, this.getConversionService());
    }

    private <S> CassandraPersistentEntityParameterValueProvider newParameterValueProvider(ConversionContext context, CassandraPersistentEntity<S> entity, CassandraValueProvider valueProvider) {
        return new CassandraPersistentEntityParameterValueProvider(entity, valueProvider, context, null);
    }

    private <T> Class<T> transformClassToBeanClassLoaderClass(Class<T> entity) {
        try {
            return ClassUtils.forName((String)entity.getName(), (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException | LinkageError ignore) {
            return entity;
        }
    }

    public <R> R read(Class<R> type, Object row) {
        if (row instanceof Row) {
            return this.readRow(type, (Row)row);
        }
        throw new MappingException(String.format("Unknown row object [%s]", ObjectUtils.nullSafeClassName((Object)row)));
    }

    public <R> R readRow(Class<R> type, Row row) {
        Class<R> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(type);
        ClassTypeInformation typeInfo = ClassTypeInformation.from(beanClassLoaderClass);
        return (R)this.doReadRow(this.getConversionContext(), row, (TypeInformation)typeInfo);
    }

    <S> S doReadRow(ConversionContext context, Row row, TypeInformation<? extends S> typeHint) {
        return this.doReadEntity(context, row, expressionEvaluator -> new RowValueProvider(row, (SpELExpressionEvaluator)expressionEvaluator), typeHint);
    }

    <S> S doReadTupleValue(ConversionContext context, TupleValue tupleValue, TypeInformation<? extends S> typeHint) {
        return this.doReadEntity(context, tupleValue, expressionEvaluator -> new TupleValueProvider(tupleValue, (SpELExpressionEvaluator)expressionEvaluator), typeHint);
    }

    <S> S doReadUdtValue(ConversionContext context, UdtValue udtValue, TypeInformation<? extends S> typeHint) {
        return this.doReadEntity(context, udtValue, expressionEvaluator -> new UdtValueProvider(udtValue, (SpELExpressionEvaluator)expressionEvaluator), typeHint);
    }

    private <S> S doReadEntity(ConversionContext context, Object value, Function<SpELExpressionEvaluator, CassandraValueProvider> valueProviderSupplier, TypeInformation<? extends S> typeHint) {
        DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator(value, this.spELContext);
        CassandraValueProvider valueProvider = valueProviderSupplier.apply((SpELExpressionEvaluator)expressionEvaluator);
        return this.doReadEntity(context, valueProvider, typeHint);
    }

    protected <S> S doReadEntity(ConversionContext context, CassandraValueProvider valueProvider, TypeInformation<? extends S> typeHint) {
        Class rawType = typeHint.getType();
        Class<?> rawSourceType = MappingCassandraConverter.getRawSourceType(valueProvider);
        if (rawSourceType.isAssignableFrom(rawType) && rawSourceType.isInstance(valueProvider.getSource())) {
            return (S)valueProvider.getSource();
        }
        if (this.getCustomConversions().hasCustomReadTarget(rawSourceType, rawType) || this.getConversionService().canConvert(rawSourceType, rawType)) {
            return (S)this.getConversionService().convert(valueProvider.getSource(), rawType);
        }
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getPersistentEntity(typeHint);
        if (entity == null) {
            throw new MappingException(String.format("Expected to read %s into type %s but didn't find a PersistentEntity for the latter!", rawSourceType.getSimpleName(), rawType.getName()));
        }
        return this.doReadEntity(context, valueProvider, entity);
    }

    private static Class<?> getRawSourceType(CassandraValueProvider valueProvider) {
        if (valueProvider.getSource() instanceof Row) {
            return Row.class;
        }
        if (valueProvider.getSource() instanceof TupleValue) {
            return TupleValue.class;
        }
        if (valueProvider.getSource() instanceof UdtValue) {
            return UdtValue.class;
        }
        throw new InvalidDataAccessApiUsageException("Unsupported source type: " + ClassUtils.getDescriptiveType((Object)valueProvider.getSource()));
    }

    private <S> S doReadEntity(ConversionContext context, CassandraValueProvider valueProvider, CassandraPersistentEntity<S> entity) {
        Object provider;
        PreferredConstructor persistenceConstructor = entity.getPersistenceConstructor();
        if (persistenceConstructor != null && persistenceConstructor.hasParameters()) {
            DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator(valueProvider.getSource(), this.spELContext);
            CassandraPersistentEntityParameterValueProvider parameterValueProvider = this.newParameterValueProvider(context, entity, valueProvider);
            provider = new ConverterAwareSpELExpressionParameterValueProvider((SpELExpressionEvaluator)evaluator, this.getConversionService(), parameterValueProvider, context);
        } else {
            provider = NoOpParameterValueProvider.INSTANCE;
        }
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)provider);
        if (entity.requiresPropertyPopulation()) {
            ConvertingPropertyAccessor<Object> propertyAccessor = this.newConvertingPropertyAccessor(instance, entity);
            this.readProperties(context, entity, valueProvider, (PersistentPropertyAccessor<?>)propertyAccessor);
            return (S)propertyAccessor.getBean();
        }
        return (S)instance;
    }

    private void readProperties(ConversionContext context, CassandraPersistentEntity<?> entity, CassandraValueProvider valueProvider, PersistentPropertyAccessor<?> propertyAccessor) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (entity.isConstructorArgument(property) || !property.isCompositePrimaryKey() && !valueProvider.hasProperty(property) && !property.isEmbedded()) continue;
            propertyAccessor.setProperty((PersistentProperty)property, this.getReadValue(context, valueProvider, property));
        }
    }

    @Override
    public Object convertToColumnType(Object obj) {
        return this.convertToColumnType(obj, (TypeInformation<?>)ClassTypeInformation.from(obj.getClass()));
    }

    @Override
    public Object convertToColumnType(Object value, ColumnType columnType) {
        return value.getClass().isArray() ? value : this.getWriteValue(value, columnType);
    }

    public void write(Object source, Object sink) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        Class<?> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(source.getClass());
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(beanClassLoaderClass);
        this.write(source, sink, entity);
    }

    @Override
    public void write(Object source, Object sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        if (entity == null) {
            throw new MappingException("No mapping metadata found for " + source.getClass());
        }
        if (sink instanceof Where) {
            this.writeWhereFromObject(source, (Where)sink, entity);
        } else if (sink instanceof Map) {
            this.writeInternal(this.newConvertingPropertyAccessor(source, entity), (Map)sink, entity);
        } else if (sink instanceof TupleValue) {
            this.writeTupleValue(this.newConvertingPropertyAccessor(source, entity), (TupleValue)sink, entity);
        } else if (sink instanceof UdtValue) {
            this.writeUDTValue(this.newConvertingPropertyAccessor(source, entity), (UdtValue)sink, entity);
        } else {
            throw new MappingException(String.format("Unknown write target [%s]", ObjectUtils.nullSafeClassName((Object)sink)));
        }
    }

    private void writeInternal(ConvertingPropertyAccessor<?> accessor, Map<CqlIdentifier, Object> sink, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            Object value;
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (property.isCompositePrimaryKey()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Property is a compositeKey");
                }
                if ((value = accessor.getProperty((PersistentProperty)property)) == null) continue;
                CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property);
                this.writeInternal(this.newConvertingPropertyAccessor(value, compositePrimaryKey), sink, compositePrimaryKey);
                continue;
            }
            value = this.getWriteValue(property, accessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doWithProperties Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (!property.isWritable()) continue;
            if (value != null && property.isEmbedded()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Mapping embedded property [{}] - [{}]", (Object)property.getRequiredColumnName(), value);
                }
                this.write(value, sink, this.embeddedEntityOperations.getEntity(property));
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding map.entry [{}] - [{}]", (Object)property.getRequiredColumnName(), value);
            }
            sink.put(property.getRequiredColumnName(), value);
        }
    }

    private void writeWhereFromObject(Object source, Where sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Id source must not be null");
        Object id = this.extractId(source, entity);
        Assert.notNull((Object)id, () -> String.format("No Id value found in object %s", source));
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        CassandraPersistentProperty compositeIdProperty = null;
        if (idProperty != null && idProperty.isCompositePrimaryKey()) {
            compositeIdProperty = idProperty;
        }
        if (id instanceof MapId) {
            CassandraPersistentEntity whereEntity = compositeIdProperty != null ? (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(compositeIdProperty) : entity;
            this.writeWhere((MapId)MapId.class.cast(id), sink, whereEntity);
            return;
        }
        if (idProperty == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot obtain where clauses for entity [%s] using [%s]", entity.getName(), source));
        }
        if (compositeIdProperty != null) {
            if (!ClassUtils.isAssignableValue((Class)compositeIdProperty.getType(), (Object)id)) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot use [%s] as composite Id for [%s]", id, entity.getName()));
            }
            CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(compositeIdProperty);
            this.writeInternal(this.newConvertingPropertyAccessor(id, compositePrimaryKey), sink, compositePrimaryKey);
            return;
        }
        Class<?> targetType = this.getTargetType(idProperty);
        sink.put(idProperty.getRequiredColumnName(), this.getPotentiallyConvertedSimpleValue(id, targetType));
    }

    @Nullable
    private Object extractId(Object source, CassandraPersistentEntity<?> entity) {
        if (ClassUtils.isAssignableValue((Class)entity.getType(), (Object)source)) {
            return this.getId(source, entity);
        }
        if (source instanceof MapId) {
            return source;
        }
        if (source instanceof MapIdentifiable) {
            return ((MapIdentifiable)source).getMapId();
        }
        return source;
    }

    private void writeWhere(MapId id, Where sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"MapId must not be null");
        for (Map.Entry entry : id.entrySet()) {
            CassandraPersistentProperty persistentProperty = (CassandraPersistentProperty)entity.getPersistentProperty((String)entry.getKey());
            if (persistentProperty == null) {
                throw new IllegalArgumentException(String.format("MapId contains references [%s] that is an unknown property of [%s]", entry.getKey(), entity.getName()));
            }
            Object writeValue = this.getWriteValue(entry.getValue(), this.cassandraTypeResolver.resolve(persistentProperty));
            sink.put(persistentProperty.getRequiredColumnName(), writeValue);
        }
    }

    private void writeWhere(ConvertingPropertyAccessor<?> accessor, Where sink, CassandraPersistentEntity<?> entity) {
        Assert.isTrue((boolean)entity.isCompositePrimaryKey(), () -> String.format("Entity [%s] is not a composite primary key", entity.getName()));
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            TypeCodec<Object> codec = this.getCodec(property);
            Object value = accessor.getProperty((PersistentProperty)property, codec.getJavaType().getRawType());
            sink.put(property.getRequiredColumnName(), value);
        }
    }

    private void writeTupleValue(ConvertingPropertyAccessor<?> propertyAccessor, TupleValue tupleValue, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, propertyAccessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writeTupleValue Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding tuple value [{}] - [{}]", (Object)property.getOrdinal(), value);
            }
            TypeCodec<Object> typeCodec = this.getCodec(property);
            tupleValue.set(property.getRequiredOrdinal(), value, typeCodec);
        }
    }

    private void writeUDTValue(ConvertingPropertyAccessor<?> propertyAccessor, UdtValue udtValue, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (!property.isWritable()) continue;
            Object value = this.getWriteValue(property, propertyAccessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writeUDTValueWhereFromObject Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding udt.value [{}] - [{}]", (Object)property.getRequiredColumnName(), value);
            }
            if (property.isEmbedded()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Mapping embedded property [{}] - [{}]", (Object)property.getRequiredColumnName(), value);
                }
                if (value == null) continue;
                CassandraPersistentEntity<?> targetEntity = this.embeddedEntityOperations.getEntity(property);
                this.writeUDTValue(new ConvertingPropertyAccessor(targetEntity.getPropertyAccessor(value), this.getConversionService()), udtValue, targetEntity);
                continue;
            }
            TypeCodec<Object> typeCodec = this.getCodec(property);
            udtValue.set(property.getRequiredColumnName().toString(), value, typeCodec);
        }
    }

    @Override
    public Object getId(Object object, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)object, (String)"Object instance must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        ConvertingPropertyAccessor<Object> propertyAccessor = this.newConvertingPropertyAccessor(object, entity);
        Assert.isTrue((boolean)entity.getType().isAssignableFrom(object.getClass()), () -> String.format("Given instance of type [%s] is not compatible with expected type [%s]", object.getClass().getName(), entity.getType().getName()));
        if (object instanceof MapIdentifiable) {
            return ((MapIdentifiable)object).getMapId();
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            return propertyAccessor.getProperty((PersistentProperty)idProperty, idProperty.isCompositePrimaryKey() ? idProperty.getType() : this.getTargetType(idProperty));
        }
        MapId id = BasicMapId.id();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (!property.isPrimaryKeyColumn()) continue;
            id.with(property.getName(), this.getWriteValue(property, propertyAccessor));
        }
        return id;
    }

    private Class<?> getTargetType(CassandraPersistentProperty property) {
        return this.getCustomConversions().getCustomWriteTarget(property.getType()).orElseGet(() -> this.cassandraTypeResolver.resolve(property).getType());
    }

    @Nullable
    private <T> T getWriteValue(CassandraPersistentProperty property, ConvertingPropertyAccessor propertyAccessor) {
        CassandraColumnType cassandraTypeDescriptor = this.cassandraTypeResolver.resolve(property);
        return (T)this.getWriteValue(propertyAccessor.getProperty((PersistentProperty)property, cassandraTypeDescriptor.getType()), cassandraTypeDescriptor);
    }

    @Nullable
    private Object getWriteValue(@Nullable Object value, ColumnType columnType) {
        if (value == null) {
            return null;
        }
        Class<?> requestedTargetType = columnType.getType();
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass(), requestedTargetType)) {
            Class<?> resolvedTargetType = this.getCustomConversions().getCustomWriteTarget(value.getClass(), requestedTargetType).orElse(requestedTargetType);
            return this.getConversionService().convert(value, resolvedTargetType);
        }
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass())) {
            Class resolvedTargetType = (Class)this.getCustomConversions().getCustomWriteTarget(value.getClass()).orElseThrow(() -> new IllegalStateException(String.format("Unable to determined custom write target for value type [%s]", value.getClass().getName())));
            return this.getConversionService().convert(value, resolvedTargetType);
        }
        if (this.getCustomConversions().isSimpleType(value.getClass())) {
            return this.getPotentiallyConvertedSimpleValue(value, requestedTargetType);
        }
        if (value instanceof Collection) {
            return this.writeCollectionInternal((Collection)value, columnType);
        }
        if (value instanceof Map) {
            return this.writeMapInternal((Map)value, columnType);
        }
        ClassTypeInformation type = ClassTypeInformation.from(value.getClass());
        TypeInformation actualType = type.getRequiredActualType();
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(actualType.getType());
        if (entity != null && columnType instanceof CassandraColumnType) {
            CassandraColumnType cassandraType = (CassandraColumnType)columnType;
            if (entity.isTupleType() && cassandraType.isTupleType()) {
                TupleValue tupleValue = ((TupleType)cassandraType.getDataType()).newValue();
                this.write(value, tupleValue, entity);
                return tupleValue;
            }
            if (entity.isUserDefinedType() && cassandraType.isUserDefinedType()) {
                UdtValue udtValue = ((UserDefinedType)cassandraType.getDataType()).newValue();
                this.write(value, udtValue, entity);
                return udtValue;
            }
        }
        return value;
    }

    private Object writeCollectionInternal(Collection<Object> source, ColumnType type) {
        Collection converted = CollectionFactory.createCollection(MappingCassandraConverter.getCollectionType(type), (int)source.size());
        ColumnType componentType = type.getRequiredComponentType();
        for (Object element : source) {
            converted.add(this.getWriteValue(element, componentType));
        }
        return converted;
    }

    private Object writeMapInternal(Map<Object, Object> source, ColumnType type) {
        Map converted = CollectionFactory.createMap(type.getType(), (int)source.size());
        ColumnType keyType = type.getRequiredComponentType();
        ColumnType valueType = type.getRequiredMapValueType();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            converted.put(this.getWriteValue(entry.getKey(), keyType), this.getWriteValue(entry.getValue(), valueType));
        }
        return converted;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleValue(@Nullable Object value, @Nullable Class<?> requestedTargetType) {
        if (value == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            if (requestedTargetType != null && !requestedTargetType.isEnum() && this.getConversionService().canConvert(value.getClass(), requestedTargetType)) {
                return this.getConversionService().convert(value, requestedTargetType);
            }
            return ((Enum)value).name();
        }
        return value;
    }

    protected Object getPotentiallyConvertedSimpleRead(Object value, TypeInformation<?> target) {
        return this.getPotentiallyConvertedSimpleRead(value, target.getType());
    }

    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (this.getCustomConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.doConvert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            if (value instanceof Number) {
                int ordinal = ((Number)value).intValue();
                return target.getEnumConstants()[ordinal];
            }
            return Enum.valueOf(target, value.toString());
        }
        return this.doConvert(value, target);
    }

    private <T> T doConvert(Object value, Class<T> target) {
        return (T)this.getConversionService().convert(value, target);
    }

    private static Class<?> getCollectionType(ColumnType type) {
        return type.getType();
    }

    @Nullable
    private Object getReadValue(ConversionContext context, CassandraValueProvider valueProvider, CassandraPersistentProperty property) {
        if (property.isCompositePrimaryKey()) {
            return context.convert(valueProvider.getSource(), property.getTypeInformation());
        }
        if (property.isEmbedded()) {
            CassandraPersistentEntity<?> targetEntity = this.embeddedEntityOperations.getEntity(property);
            return this.isNullEmbedded(targetEntity, property, valueProvider) ? null : this.doReadEntity(context, valueProvider, targetEntity);
        }
        if (!valueProvider.hasProperty(property)) {
            return null;
        }
        Object value = valueProvider.getPropertyValue(property);
        return value == null ? null : context.convert(value, property.getTypeInformation());
    }

    private boolean isNullEmbedded(CassandraPersistentEntity<?> entity, CassandraPersistentProperty property, CassandraValueProvider valueProvider) {
        if (Embedded.OnEmpty.USE_EMPTY.equals((Object)((Embedded)property.getRequiredAnnotation(Embedded.class)).onEmpty())) {
            return false;
        }
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty embeddedProperty = (CassandraPersistentProperty)iterator.next();
            if (!valueProvider.hasProperty(embeddedProperty) || valueProvider.getPropertyValue(embeddedProperty) == null) continue;
            return false;
        }
        return true;
    }

    protected Object readCollectionOrArray(ConversionContext context, Collection<?> source, TypeInformation<?> targetType) {
        ArrayList collection;
        Assert.notNull(targetType, (String)"Target type must not be null");
        Class<?> collectionType = MappingCassandraConverter.resolveCollectionType(targetType);
        Class<?> elementType = MappingCassandraConverter.resolveElementType(targetType);
        Collection<Object> collection2 = collection = targetType.getType().isArray() ? new ArrayList() : CollectionFactory.createCollection(collectionType, elementType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(collection, collectionType);
        }
        TypeInformation componentType = targetType.getComponentType();
        componentType = componentType == null ? ClassTypeInformation.from(elementType) : componentType;
        for (Object element : source) {
            collection.add(context.convert(element, componentType));
        }
        return this.getPotentiallyConvertedSimpleRead(collection, targetType.getType());
    }

    private static Class<?> resolveCollectionType(TypeInformation<?> typeInformation) {
        Class<List> collectionType = typeInformation.getType();
        return Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
    }

    private static Class<?> resolveElementType(TypeInformation<?> typeInformation) {
        TypeInformation componentType = typeInformation.getComponentType();
        return componentType != null ? componentType.getType() : Object.class;
    }

    protected Object readMap(ConversionContext context, Map<?, ?> source, TypeInformation<?> targetType) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        TypeInformation keyType = targetType.getComponentType();
        TypeInformation valueType = targetType.getMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : null;
        Map map = CollectionFactory.createMap(MappingCassandraConverter.resolveMapType(targetType), (Class)rawKeyType, (int)source.size());
        if (source.isEmpty()) {
            return map;
        }
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            Object key = entry.getKey();
            if (key != null && rawKeyType != null && !rawKeyType.isAssignableFrom(key.getClass())) {
                key = context.convert(key, keyType);
            }
            Object value = entry.getValue();
            map.put(key, context.convert(value, valueType == null ? ClassTypeInformation.OBJECT : valueType));
        }
        return map;
    }

    private static Class<?> resolveMapType(TypeInformation<?> typeInformation) {
        Class<Map> mapType = typeInformation.getType();
        return Map.class.isAssignableFrom(mapType) ? mapType : Map.class;
    }

    class CassandraPersistentEntityParameterValueProvider
    implements ParameterValueProvider<CassandraPersistentProperty> {
        private final CassandraPersistentEntity<?> entity;
        private final CassandraValueProvider provider;
        private final ConversionContext context;
        @Nullable
        private final Object parent;

        public CassandraPersistentEntityParameterValueProvider(CassandraPersistentEntity<?> entity, CassandraValueProvider provider, @Nullable ConversionContext context, Object parent) {
            this.entity = entity;
            this.provider = provider;
            this.context = context;
            this.parent = parent;
        }

        @Nullable
        public <T> T getParameterValue(PreferredConstructor.Parameter<T, CassandraPersistentProperty> parameter) {
            PreferredConstructor constructor = this.entity.getPersistenceConstructor();
            if (constructor != null && constructor.isEnclosingClassParameter(parameter)) {
                return (T)this.parent;
            }
            String name = parameter.getName();
            if (name == null) {
                throw new MappingException(String.format("Parameter %s does not have a name!", parameter));
            }
            CassandraPersistentProperty property = this.getPersistentProperty(name, parameter.getType(), parameter.getAnnotations());
            if (property == null) {
                throw new MappingException(String.format("No property %s found on entity %s to bind constructor parameter to!", name, this.entity.getType()));
            }
            return (T)MappingCassandraConverter.this.getReadValue(this.context, this.provider, property);
        }

        @Nullable
        private <T> CassandraPersistentProperty getPersistentProperty(String name, TypeInformation<?> typeInformation, MergedAnnotations annotations) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)this.entity.getPersistentProperty(name);
            if (annotations.isPresent(Column.class) || annotations.isPresent(Element.class)) {
                return new AnnotatedCassandraConstructorProperty(property == null ? new CassandraConstructorProperty(name, this.entity, typeInformation) : property, annotations);
            }
            return property;
        }
    }

    protected static class ConversionContext {
        private final CustomConversions conversions;
        private final ContainerValueConverter<Row> rowConverter;
        private final ContainerValueConverter<TupleValue> tupleConverter;
        private final ContainerValueConverter<UdtValue> udtConverter;
        private final ContainerValueConverter<Collection<?>> collectionConverter;
        private final ContainerValueConverter<Map<?, ?>> mapConverter;
        private final ValueConverter<Object> elementConverter;

        public ConversionContext(CustomConversions conversions, ContainerValueConverter<Row> rowConverter, ContainerValueConverter<TupleValue> tupleConverter, ContainerValueConverter<UdtValue> udtConverter, ContainerValueConverter<Collection<?>> collectionConverter, ContainerValueConverter<Map<?, ?>> mapConverter, ValueConverter<Object> elementConverter) {
            this.conversions = conversions;
            this.rowConverter = rowConverter;
            this.tupleConverter = tupleConverter;
            this.udtConverter = udtConverter;
            this.collectionConverter = collectionConverter;
            this.mapConverter = mapConverter;
            this.elementConverter = elementConverter;
        }

        public <S> S convert(Object source, TypeInformation<? extends S> typeHint) {
            Assert.notNull(typeHint, (String)"TypeInformation must not be null");
            if (this.conversions.hasCustomReadTarget(source.getClass(), typeHint.getType())) {
                return (S)this.elementConverter.convert(source, typeHint);
            }
            if (source instanceof Collection) {
                Class rawType = typeHint.getType();
                if (!(Object.class.equals((Object)rawType) || rawType.isArray() || ClassUtils.isAssignable(Iterable.class, (Class)rawType))) {
                    throw new MappingException(String.format("Cannot convert %1$s of type %2$s into an instance of %3$s! Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions.", source, source.getClass(), rawType));
                }
                if (typeHint.isCollectionLike() || typeHint.getType().isAssignableFrom(Collection.class)) {
                    return (S)this.collectionConverter.convert(this, (Collection)source, typeHint);
                }
            }
            if (typeHint.isMap()) {
                return (S)this.mapConverter.convert(this, (Map)source, typeHint);
            }
            if (source instanceof Row) {
                return (S)this.rowConverter.convert(this, (Row)source, typeHint);
            }
            if (source instanceof TupleValue) {
                return (S)this.tupleConverter.convert(this, (TupleValue)source, typeHint);
            }
            if (source instanceof UdtValue) {
                return (S)this.udtConverter.convert(this, (UdtValue)source, typeHint);
            }
            return (S)this.elementConverter.convert(source, typeHint);
        }

        static interface ContainerValueConverter<T> {
            public Object convert(ConversionContext var1, T var2, TypeInformation<?> var3);
        }

        static interface ValueConverter<T> {
            public Object convert(T var1, TypeInformation<?> var2);
        }
    }

    private class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<CassandraPersistentProperty> {
        private final ConversionContext context;

        public ConverterAwareSpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<CassandraPersistentProperty> delegate, ConversionContext context) {
            super(evaluator, conversionService, delegate);
            this.context = context;
        }

        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, CassandraPersistentProperty> parameter) {
            return (T)this.context.convert(object, parameter.getType());
        }
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<CassandraPersistentProperty>
    {
        INSTANCE;


        public <T> T getParameterValue(PreferredConstructor.Parameter<T, CassandraPersistentProperty> parameter) {
            return null;
        }
    }
}

