/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleUserTypeResolver
implements UserTypeResolver {
    private final CqlSession session;
    private final CqlIdentifier keyspaceName;

    public SimpleUserTypeResolver(CqlSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
        this.keyspaceName = session.getKeyspace().orElse(CqlIdentifier.fromCql((String)"system"));
    }

    public SimpleUserTypeResolver(CqlSession session, CqlIdentifier keyspaceName) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        Assert.notNull((Object)keyspaceName, (String)"Keyspace must not be null");
        this.session = session;
        this.keyspaceName = keyspaceName;
    }

    @Override
    @Nullable
    public UserDefinedType resolveType(CqlIdentifier typeName) {
        return this.session.getMetadata().getKeyspace(this.keyspaceName).flatMap(it -> it.getUserDefinedType(typeName)).orElse(null);
    }
}

