/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StringBasedQuery {
    private final String query;
    private final ExpressionEvaluatingParameterBinder parameterBinder;
    private final List<ExpressionEvaluatingParameterBinder.ParameterBinding> queryParameterBindings = new ArrayList<ExpressionEvaluatingParameterBinder.ParameterBinding>();

    StringBasedQuery(String query2, ExpressionEvaluatingParameterBinder parameterBinder) {
        Assert.hasText((String)query2, (String)"Query must not be empty");
        Assert.notNull((Object)parameterBinder, (String)"ExpressionEvaluatingParameterBinder must not be null");
        this.parameterBinder = parameterBinder;
        this.query = ParameterBindingParser.INSTANCE.parseAndCollectParameterBindingsFromQueryIntoBindings(query2, this.queryParameterBindings);
    }

    private ExpressionEvaluatingParameterBinder getParameterBinder() {
        return this.parameterBinder;
    }

    protected String getQuery() {
        return this.query;
    }

    SimpleStatement bindQuery(CassandraParameterAccessor parameterAccessor, CassandraQueryMethod queryMethod) {
        Assert.notNull((Object)parameterAccessor, (String)"CassandraParameterAccessor must not be null");
        Assert.notNull((Object)((Object)queryMethod), (String)"CassandraQueryMethod must not be null");
        List<Object> arguments = this.getParameterBinder().bind(parameterAccessor, new ExpressionEvaluatingParameterBinder.BindingContext(queryMethod, this.queryParameterBindings));
        return ParameterBinder.INSTANCE.bind(this.getQuery(), arguments);
    }

    static enum ParameterBindingParser {
        INSTANCE;

        private static final char CURRLY_BRACE_OPEN = '{';
        private static final char CURRLY_BRACE_CLOSE = '}';
        private static final Pattern INDEX_PARAMETER_BINDING_PATTERN;
        private static final Pattern NAMED_PARAMETER_BINDING_PATTERN;
        private static final Pattern INDEX_BASED_EXPRESSION_PATTERN;
        private static final Pattern NAME_BASED_EXPRESSION_PATTERN;
        private static final String ARGUMENT_PLACEHOLDER = "?_param_?";

        public String parseAndCollectParameterBindingsFromQueryIntoBindings(String input, List<ExpressionEvaluatingParameterBinder.ParameterBinding> bindings) {
            if (!StringUtils.hasText((String)input)) {
                return input;
            }
            Assert.notNull(bindings, (String)"Parameter bindings must not be null");
            return ParameterBindingParser.transformQueryAndCollectExpressionParametersIntoBindings(input, bindings);
        }

        private static String transformQueryAndCollectExpressionParametersIntoBindings(String input, List<ExpressionEvaluatingParameterBinder.ParameterBinding> bindings) {
            Matcher matcher;
            StringBuilder result = new StringBuilder();
            int startIndex = 0;
            int currentPosition = 0;
            while (currentPosition < input.length() && (matcher = ParameterBindingParser.findNextBindingOrExpression(input, currentPosition)) != null) {
                int exprStart;
                currentPosition = exprStart = matcher.start();
                if (matcher.pattern() == NAME_BASED_EXPRESSION_PATTERN || matcher.pattern() == INDEX_BASED_EXPRESSION_PATTERN) {
                    int curlyBraceOpenCount = 1;
                    currentPosition += 3;
                    block5: while (curlyBraceOpenCount > 0 && currentPosition < input.length()) {
                        switch (input.charAt(currentPosition++)) {
                            case '{': {
                                ++curlyBraceOpenCount;
                                continue block5;
                            }
                            case '}': {
                                --curlyBraceOpenCount;
                                continue block5;
                            }
                        }
                    }
                    result.append(input.subSequence(startIndex, exprStart));
                } else {
                    result.append(input.subSequence(startIndex, exprStart));
                }
                result.append(ARGUMENT_PLACEHOLDER);
                if (matcher.pattern() == NAME_BASED_EXPRESSION_PATTERN || matcher.pattern() == INDEX_BASED_EXPRESSION_PATTERN) {
                    bindings.add(ExpressionEvaluatingParameterBinder.ParameterBinding.expression(input.substring(exprStart + 3, currentPosition - 1), true));
                } else {
                    if (matcher.pattern() == INDEX_PARAMETER_BINDING_PATTERN) {
                        bindings.add(ExpressionEvaluatingParameterBinder.ParameterBinding.indexed(Integer.parseInt(matcher.group(1))));
                    } else {
                        bindings.add(ExpressionEvaluatingParameterBinder.ParameterBinding.named(matcher.group(1)));
                    }
                    currentPosition = matcher.end();
                }
                startIndex = currentPosition;
            }
            return result.append(input.subSequence(currentPosition, input.length())).toString();
        }

        @Nullable
        private static Matcher findNextBindingOrExpression(String input, int position) {
            ArrayList<Matcher> matchers = new ArrayList<Matcher>();
            matchers.add(INDEX_PARAMETER_BINDING_PATTERN.matcher(input));
            matchers.add(NAMED_PARAMETER_BINDING_PATTERN.matcher(input));
            matchers.add(INDEX_BASED_EXPRESSION_PATTERN.matcher(input));
            matchers.add(NAME_BASED_EXPRESSION_PATTERN.matcher(input));
            TreeMap<Integer, Matcher> matcherMap = new TreeMap<Integer, Matcher>();
            for (Matcher matcher : matchers) {
                if (!matcher.find(position)) continue;
                matcherMap.put(matcher.start(), matcher);
            }
            return matcherMap.isEmpty() ? null : (Matcher)matcherMap.values().iterator().next();
        }

        static {
            INDEX_PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");
            NAMED_PARAMETER_BINDING_PATTERN = Pattern.compile("\\:(\\w+)");
            INDEX_BASED_EXPRESSION_PATTERN = Pattern.compile("\\?\\#\\{");
            NAME_BASED_EXPRESSION_PATTERN = Pattern.compile("\\:\\#\\{");
        }
    }

    static enum ParameterBinder {
        INSTANCE;

        private static final String ARGUMENT_PLACEHOLDER = "?_param_?";
        private static final Pattern ARGUMENT_PLACEHOLDER_PATTERN;

        public SimpleStatement bind(String input, List<Object> parameters) {
            if (parameters.isEmpty()) {
                return SimpleStatement.newInstance((String)input);
            }
            StringBuilder result = new StringBuilder();
            int startIndex = 0;
            int currentPosition = 0;
            int parameterIndex = 0;
            Matcher matcher = ARGUMENT_PLACEHOLDER_PATTERN.matcher(input);
            while (currentPosition < input.length() && matcher.find()) {
                int exprStart = matcher.start();
                result.append(input.subSequence(startIndex, exprStart)).append("?");
                ++parameterIndex;
                startIndex = currentPosition = matcher.end();
            }
            String bindableStatement = result.append(input.subSequence(currentPosition, input.length())).toString();
            return SimpleStatement.newInstance((String)bindableStatement, (Object[])parameters.subList(0, parameterIndex).toArray());
        }

        static {
            ARGUMENT_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote(ARGUMENT_PLACEHOLDER));
        }
    }
}

